/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.actions.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;

public class MDSashForm
extends SashForm {
    private ArrayList<Object> _sashes = new ArrayList(0);
    private Listener listener = new Listener(){

        public void handleEvent(Event e) {
            switch (e.type) {
                case 6: {
                    e.widget.setData("hover", (Object)Boolean.TRUE);
                    ((Control)e.widget).redraw();
                    break;
                }
                case 7: {
                    e.widget.setData("hover", null);
                    ((Control)e.widget).redraw();
                    break;
                }
                case 9: {
                    MDSashForm.this.onSashPaint(e);
                    break;
                }
                case 11: {
                    MDSashForm.this.hookSashListeners();
                }
            }
        }
    };

    public MDSashForm(Composite parent, int style) {
        super(parent, style);
    }

    public Listener getListener() {
        return this.listener;
    }

    private void hookSashListeners() {
        this.purgeSashes();
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Sash sash;
            if (children[i] instanceof Sash && !this._sashes.contains(sash = (Sash)children[i])) {
                sash.addListener(9, this.listener);
                sash.addListener(6, this.listener);
                sash.addListener(7, this.listener);
                this._sashes.add(sash);
            }
            ++i;
        }
    }

    public void layout(boolean changed) {
        super.layout(changed);
        this.hookSashListeners();
    }

    public void layout(Control[] children) {
        super.layout(children);
        this.hookSashListeners();
    }

    private void onSashPaint(Event e) {
        Sash sash = (Sash)e.widget;
        IManagedForm form = (IManagedForm)sash.getParent().getData("form");
        FormColors colors = form.getToolkit().getColors();
        boolean vertical = (sash.getStyle() & 0x200) != 0;
        GC gc = e.gc;
        Boolean hover = (Boolean)sash.getData("hover");
        gc.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
        gc.setForeground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        Point size = sash.getSize();
        if (vertical) {
            if (hover != null) {
                gc.fillRectangle(0, 0, size.x, size.y);
            }
        } else if (hover != null) {
            gc.fillRectangle(0, 0, size.x, size.y);
        }
    }

    private void purgeSashes() {
        Iterator<Object> iter = this._sashes.iterator();
        while (iter.hasNext()) {
            Sash sash = (Sash)iter.next();
            if (!sash.isDisposed()) continue;
            iter.remove();
        }
    }
}

