/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.dialogs.importks;

import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ConvertKeyStoreTypeDialog
extends TitleAreaDialog {
    private static final String HELP_ID = "org.eclipse.andmore.android.certmanager.convert_keystore_type";
    private static final String WIZARD_BANNER = "icons/wizban/change_keystore_type_wiz.png";
    private IKeyStore keyStore;
    private String newType = "";
    private Text passwdText;
    private String password = "";
    private Table entriesTable;
    private TableViewer entriesTableViewer;
    private final Map<String, String> aliaseMap = new HashMap<String, String>();

    public ConvertKeyStoreTypeDialog(Shell parentShell, IKeyStore keyStore) {
        super(parentShell);
        this.setShellStyle(67680);
        this.keyStore = keyStore;
        this.setTitleImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)WIZARD_BANNER).createImage());
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_DialogTitle);
        this.setMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_DefaultMessage);
        this.setTitle(CertificateManagerNLS.ConvertKeyStoreTypeDialog_DialogTitle);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite convertTopComposite = new Composite(container, 0);
        convertTopComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        convertTopComposite.setLayout((Layout)new GridLayout(1, false));
        Composite keyStoreComposite = new Composite(convertTopComposite, 0);
        keyStoreComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        keyStoreComposite.setLayout((Layout)new GridLayout(3, false));
        Label keyStoreLabel = new Label(keyStoreComposite, 0);
        keyStoreLabel.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_KeyStoreLabel);
        final Combo keyStoreCombo = new Combo(keyStoreComposite, 8);
        keyStoreCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        final KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
        try {
            List<IKeyStore> keyStores = keyStoreManager.getKeyStores();
            for (IKeyStore keyStore : keyStores) {
                File ksFile = keyStore.getFile();
                String comboItem = String.valueOf(ksFile.getName()) + " - " + ksFile.getAbsolutePath();
                keyStoreCombo.add(comboItem);
                keyStoreCombo.setData(comboItem, (Object)keyStore);
                if (!keyStore.equals(this.keyStore)) continue;
                keyStoreCombo.select(keyStoreCombo.indexOf(comboItem));
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            this.setErrorMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_CouldNotLoad_Keystores_Error);
        }
        Label passwdLabel = new Label(keyStoreComposite, 0);
        passwdLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        passwdLabel.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Password_Label);
        this.passwdText = new Text(keyStoreComposite, 0x400800);
        this.passwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConvertKeyStoreTypeDialog.this.password = ConvertKeyStoreTypeDialog.this.passwdText.getText();
            }
        });
        this.passwdText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                ConvertKeyStoreTypeDialog.this.loadEntries();
            }
        });
        this.passwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button loadButton = new Button(keyStoreComposite, 0);
        GridData gd_loadButton = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_loadButton.widthHint = 80;
        loadButton.setLayoutData((Object)gd_loadButton);
        loadButton.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Load_Button);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertKeyStoreTypeDialog.this.loadEntries();
            }
        });
        Composite composite_1 = new Composite(convertTopComposite, 0);
        GridData gd_composite_1 = new GridData(4, 4, true, false, 1, 1);
        gd_composite_1.heightHint = 39;
        composite_1.setLayoutData((Object)gd_composite_1);
        composite_1.setLayout((Layout)new GridLayout(4, false));
        Label typeLabel = new Label(composite_1, 0);
        typeLabel.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Original_Type_Label);
        final Label currentTypeLabel = new Label(composite_1, 0);
        GridData gd_currentTypeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_currentTypeLabel.widthHint = 90;
        gd_currentTypeLabel.minimumWidth = 90;
        currentTypeLabel.setLayoutData((Object)gd_currentTypeLabel);
        currentTypeLabel.setText(this.keyStore.getType());
        Label newTypeLabel = new Label(composite_1, 0);
        newTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        newTypeLabel.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_NewType_Label);
        final Combo typeCombo = new Combo(composite_1, 8);
        typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.loadTypeCombo(keyStoreManager, typeCombo);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ConvertKeyStoreTypeDialog.this.newType = typeCombo.getText();
                ConvertKeyStoreTypeDialog.this.validateUi();
            }
        });
        keyStoreCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ConvertKeyStoreTypeDialog.this.updateUi(keyStoreCombo, keyStoreManager, currentTypeLabel, typeCombo);
                ConvertKeyStoreTypeDialog.this.validateUi();
            }
        });
        Group entriesGroup = new Group(container, 0);
        entriesGroup.setLayout((Layout)new GridLayout(1, true));
        GridData gd_entriesGroup = new GridData(4, 4, true, true, 1, 1);
        gd_entriesGroup.heightHint = 230;
        gd_entriesGroup.widthHint = 433;
        entriesGroup.setLayoutData((Object)gd_entriesGroup);
        entriesGroup.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Entries_Group);
        this.entriesTableViewer = new TableViewer((Composite)entriesGroup, 67588);
        this.entriesTableViewer.setContentProvider((IContentProvider)new EntriesContentProvider());
        this.entriesTable = this.entriesTableViewer.getTable();
        this.entriesTable.setHeaderVisible(true);
        this.entriesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn aliasViewerColumn = new TableViewerColumn(this.entriesTableViewer, 0);
        TableColumn tblclmnAlias = aliasViewerColumn.getColumn();
        tblclmnAlias.setWidth(100);
        tblclmnAlias.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Alias_Column);
        aliasViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((EntryModel)element).getAlias();
            }
        });
        TableViewerColumn passwordViewerColumn_1 = new TableViewerColumn(this.entriesTableViewer, 0);
        passwordViewerColumn_1.setEditingSupport((EditingSupport)new PasswordEditingSupport((ColumnViewer)this.entriesTableViewer));
        TableColumn tblclmnPassword = passwordViewerColumn_1.getColumn();
        tblclmnPassword.setWidth(100);
        tblclmnPassword.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Password_Column);
        passwordViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((EntryModel)element).getPasswd().replaceAll(".", "*");
            }
        });
        TableViewerColumn verifiedViewerColumn_2 = new TableViewerColumn(this.entriesTableViewer, 0);
        TableColumn tblclmnVerified = verifiedViewerColumn_2.getColumn();
        tblclmnVerified.setWidth(130);
        tblclmnVerified.setText(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Verified_Column);
        verifiedViewerColumn_2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((EntryModel)element).isVerified() ? CertificateManagerNLS.ConvertKeyStoreTypeDialog_Verified_Pass_Yes : CertificateManagerNLS.ConvertKeyStoreTypeDialog_Verified_Pass_Wrong;
            }
        });
        this.updateUi(keyStoreCombo, keyStoreManager, currentTypeLabel, typeCombo);
        return area;
    }

    protected Control createHelpControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), HELP_ID);
        return super.createHelpControl(parent);
    }

    private void updateUi(Combo keyStoreCombo, KeyStoreManager keyStoreManager, Label currentTypeLabel, Combo typeCombo) {
        this.keyStore = (IKeyStore)keyStoreCombo.getData(keyStoreCombo.getText());
        try {
            this.password = this.keyStore.getPasswordProvider().getKeyStorePassword(false);
        }
        catch (KeyStoreManagerException e) {
            AndmoreLogger.error((String)("Error while accessing keystore manager. " + e.getMessage()));
        }
        if (this.password == null) {
            this.password = "";
        }
        this.passwdText.setText(this.password);
        if (!this.password.isEmpty()) {
            IKeyStore keyStore = (IKeyStore)keyStoreCombo.getData(keyStoreCombo.getText());
            currentTypeLabel.setText(keyStore.getType());
            this.loadTypeCombo(keyStoreManager, typeCombo);
            this.aliaseMap.clear();
            try {
                if (keyStore.isPasswordValid(this.password)) {
                    List<String> aliases = keyStore.getAliases(this.password);
                    this.entriesTableViewer.setInput(aliases);
                } else {
                    this.validateUi();
                }
            }
            catch (KeyStoreManagerException e) {
                AndmoreLogger.error((String)("Error while accessing keystore manager. " + e.getMessage()));
            }
            catch (InvalidPasswordException invalidPasswordException) {
                this.validateUi();
            }
        }
    }

    private void loadEntries() {
        try {
            this.aliaseMap.clear();
            List<String> aliases = this.keyStore.getAliases(this.password);
            this.entriesTableViewer.setInput(aliases);
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            this.setErrorMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Error_Loading_Keystore);
            this.entriesTableViewer.setInput(new ArrayList());
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.setErrorMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Invalid_Keystore_Pass);
            this.entriesTableViewer.setInput(new ArrayList());
        }
        this.validateUi();
    }

    private void loadTypeCombo(KeyStoreManager keyStoreManager, Combo typeCombo) {
        typeCombo.setItems(new String[0]);
        List<String> availableTypes = keyStoreManager.getAvailableTypes();
        for (String type : availableTypes) {
            if (type.equals(this.keyStore.getType())) continue;
            typeCombo.add(type);
        }
        typeCombo.clearSelection();
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    public void validateUi() {
        Button okButton;
        Object input;
        boolean isValid = true;
        this.setErrorMessage(null);
        if (isValid && this.keyStore == null) {
            isValid = false;
            this.setMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Choose_KeyStore_Msg);
        }
        if (isValid) {
            boolean passwordValid;
            try {
                passwordValid = this.keyStore.isPasswordValid(this.password);
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                passwordValid = false;
            }
            catch (InvalidPasswordException invalidPasswordException) {
                passwordValid = false;
            }
            if (!passwordValid) {
                isValid = false;
                this.setErrorMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Invalid_Keystore_Pass);
            }
        }
        if (isValid && this.newType.isEmpty()) {
            isValid = false;
            this.setMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Choose_New_Type_Msg);
        }
        if (isValid && (input = this.entriesTableViewer.getInput()) != null) {
            int itemCount = ((List)input).size();
            int i = 0;
            while (i < itemCount) {
                EntryModel entryModel = (EntryModel)this.entriesTableViewer.getElementAt(i);
                if (entryModel != null && !entryModel.isVerified()) {
                    isValid = false;
                    this.setMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Incorrect_Entry_Pass, 2);
                    break;
                }
                ++i;
            }
        }
        if ((okButton = this.getButton(0)) != null) {
            if (!isValid) {
                okButton.setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
                this.setErrorMessage(null);
                this.setMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_DefaultMessage);
            }
        }
    }

    public IKeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getNewType() {
        return this.newType;
    }

    public Map<String, String> getAliases() {
        return this.aliaseMap;
    }

    public String getKeystorePassword() {
        return this.password;
    }

    public class EntriesContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<EntryModel> modelList = null;
            if (inputElement instanceof List) {
                List inputList = (List)inputElement;
                modelList = new ArrayList<EntryModel>(inputList.size());
                for (Object element : inputList) {
                    if (!(element instanceof String)) continue;
                    String alias = (String)element;
                    EntryModel entryModel = new EntryModel(alias);
                    modelList.add(entryModel);
                }
            }
            return modelList.toArray();
        }
    }

    public class EntryModel {
        private final String alias;
        private String passwd;
        private boolean verified;

        public EntryModel(String alias) {
            this.alias = alias;
            try {
                String savedPass = ConvertKeyStoreTypeDialog.this.keyStore.getPasswordProvider().getPassword(alias, false);
                this.setPasswd(savedPass != null ? savedPass : "");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                this.setPasswd("");
            }
        }

        public String toString() {
            return this.alias;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
            try {
                KeyStore.Entry entry = ConvertKeyStoreTypeDialog.this.keyStore.getKeyStore().getEntry(this.alias, new KeyStore.PasswordProtection(passwd.toCharArray()));
                this.setVerified(entry != null);
            }
            catch (Exception exception) {
                this.setVerified(false);
            }
            ConvertKeyStoreTypeDialog.this.aliaseMap.put(this.alias, passwd);
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isVerified() {
            return this.verified;
        }

        private void setVerified(boolean verified) {
            this.verified = verified;
            ConvertKeyStoreTypeDialog.this.validateUi();
        }
    }

    private final class PasswordEditingSupport
    extends EditingSupport {
        private PasswordEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)ConvertKeyStoreTypeDialog.this.entriesTable, 0x400000);
        }

        protected Object getValue(Object element) {
            return ((EntryModel)element).getPasswd();
        }

        protected void setValue(Object element, Object value) {
            EntryModel model = (EntryModel)element;
            model.setPasswd((String)value);
            this.getViewer().update(element, null);
        }
    }
}

