/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.codesnippets;

import org.eclipse.andmore.android.codesnippets.AndroidSnippetsTooltip;
import org.eclipse.andmore.android.codesnippets.SnippetsViewContributionItem;
import org.eclipse.andmore.android.codesnippets.TooltipDisplayConfigContriutionItem;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;

public class AndroidSnippetsStartup
implements IStartup {
    public static final String SNIPPETS_VIEW_ID = "org.eclipse.wst.common.snippets.internal.ui.SnippetsView";
    private static SnippetsViewContributionItem searchContributionItem;
    private static TooltipDisplayConfigContriutionItem tooltipDisplayConfigcontributionItem;
    private AndroidSnippetsTooltip tooltip = null;

    private static void addSearchBar(SnippetsView view) {
        ToolBarManager tbManager;
        if (searchContributionItem == null) {
            tbManager = (ToolBarManager)view.getViewSite().getActionBars().getToolBarManager();
            searchContributionItem = new SnippetsViewContributionItem(view);
            tbManager.add((IContributionItem)searchContributionItem);
            tbManager.update(true);
            view.getViewSite().getActionBars().updateActionBars();
        }
        if (tooltipDisplayConfigcontributionItem == null) {
            tbManager = (ToolBarManager)view.getViewSite().getActionBars().getToolBarManager();
            tooltipDisplayConfigcontributionItem = new TooltipDisplayConfigContriutionItem();
            tbManager.add((IContributionItem)tooltipDisplayConfigcontributionItem);
            tbManager.update(true);
            view.getViewSite().getActionBars().updateActionBars();
        }
    }

    public void earlyStartup() {
        final MouseListener snippetsMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                SnippetsView snippetsView = (SnippetsView)EclipseUtils.getActiveView((String)AndroidSnippetsStartup.SNIPPETS_VIEW_ID);
                ISnippetsEntry snippetEntry = snippetsView.getSelectedEntry();
                if (snippetEntry instanceof ISnippetItem && (AndroidSnippetsStartup.this.tooltip == null || !AndroidSnippetsStartup.this.tooltip.getItem().equals(snippetEntry)) && tooltipDisplayConfigcontributionItem.isTooltipDisplayed()) {
                    Control snippetsControl = snippetsView.getViewer().getControl();
                    AndroidSnippetsStartup.this.tooltip = new AndroidSnippetsTooltip((ISnippetItem)snippetEntry, snippetsControl);
                    AndroidSnippetsStartup.this.tooltip.setPopupDelay(250);
                    AndroidSnippetsStartup.this.tooltip.show(new Point(snippetsControl.getBounds().width, 0));
                } else {
                    if (AndroidSnippetsStartup.this.tooltip != null) {
                        AndroidSnippetsStartup.this.tooltip.hide();
                    }
                    AndroidSnippetsStartup.this.tooltip = null;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (AndroidSnippetsStartup.this.tooltip != null) {
                    AndroidSnippetsStartup.this.tooltip.hide();
                }
                AndroidSnippetsStartup.this.tooltip = null;
            }
        };
        final DragDetectListener snippetsMouseDragListener = new DragDetectListener(){

            public void dragDetected(DragDetectEvent e) {
                if (AndroidSnippetsStartup.this.tooltip != null) {
                    AndroidSnippetsStartup.this.tooltip.hide();
                }
            }
        };
        PerspectiveAdapter perspectiveListener = new PerspectiveAdapter(){
            boolean executed = false;

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IViewReference[] viewReferences;
                IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    SnippetsView snippetsView;
                    IViewReference viewReference = iViewReferenceArray[n2];
                    if (AndroidSnippetsStartup.SNIPPETS_VIEW_ID.equals(viewReference.getId()) && (snippetsView = (SnippetsView)viewReference.getView(true)) != null) {
                        Control control;
                        AndroidSnippetsStartup.addSearchBar(snippetsView);
                        PaletteViewer palleteViewer = snippetsView.getViewer();
                        if (palleteViewer != null && (control = palleteViewer.getControl()) != null) {
                            control.removeMouseListener(snippetsMouseListener);
                            control.removeDragDetectListener(snippetsMouseDragListener);
                            control.addMouseListener(snippetsMouseListener);
                            control.addDragDetectListener(snippetsMouseDragListener);
                            this.executed = true;
                        }
                    }
                    ++n2;
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
                if (AndroidSnippetsStartup.SNIPPETS_VIEW_ID.equals(partRef.getId())) {
                    if ("viewShow".equals(changeId)) {
                        if (!this.executed) {
                            SnippetsView snippetsView = (SnippetsView)partRef.getPart(false);
                            AndroidSnippetsStartup.addSearchBar(snippetsView);
                            snippetsView.getViewer().getControl().removeMouseListener(snippetsMouseListener);
                            snippetsView.getViewer().getControl().removeDragDetectListener(snippetsMouseDragListener);
                            snippetsView.getViewer().getControl().addMouseListener(snippetsMouseListener);
                            snippetsView.getViewer().getControl().addDragDetectListener(snippetsMouseDragListener);
                            this.executed = true;
                        }
                    } else if ("viewHide".equals(changeId)) {
                        if (searchContributionItem != null) {
                            searchContributionItem.getParent().remove((IContributionItem)searchContributionItem);
                        }
                        if (tooltipDisplayConfigcontributionItem != null) {
                            tooltipDisplayConfigcontributionItem.getParent().remove((IContributionItem)tooltipDisplayConfigcontributionItem);
                        }
                        searchContributionItem = null;
                        tooltipDisplayConfigcontributionItem = null;
                        this.executed = false;
                    }
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((IPerspectiveListener)perspectiveListener, snippetsMouseListener, snippetsMouseDragListener){
            private final /* synthetic */ IPerspectiveListener val$perspectiveListener;
            private final /* synthetic */ MouseListener val$snippetsMouseListener;
            private final /* synthetic */ DragDetectListener val$snippetsMouseDragListener;
            {
                this.val$perspectiveListener = iPerspectiveListener;
                this.val$snippetsMouseListener = mouseListener;
                this.val$snippetsMouseDragListener = dragDetectListener;
            }

            @Override
            public void run() {
                SnippetsView snippetsView;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                activeWindow.addPerspectiveListener(this.val$perspectiveListener);
                IViewReference viewReference = activeWindow.getActivePage().findViewReference(AndroidSnippetsStartup.SNIPPETS_VIEW_ID);
                if (viewReference != null && (snippetsView = (SnippetsView)viewReference.getView(true)) != null) {
                    AndroidSnippetsStartup.addSearchBar(snippetsView);
                    snippetsView.getViewer().getControl().addMouseListener(this.val$snippetsMouseListener);
                    snippetsView.getViewer().getControl().addDragDetectListener(this.val$snippetsMouseDragListener);
                }
            }
        });
    }
}

