/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.model;

import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.TableModel;

public class Field {
    private String name;
    private boolean primaryKey;
    private AutoIncrementType autoIncrementType;
    private DataType type;
    private String defaultValue;

    public boolean equals(Object other) {
        boolean equals = false;
        if (other instanceof Field) {
            equals = this.getName().equals(((Field)other).getName());
        }
        return equals;
    }

    public Field(String name, DataType type, boolean primaryKey, AutoIncrementType autoIncrementType, String defaultValue) {
        this.name = name;
        this.primaryKey = primaryKey;
        this.autoIncrementType = autoIncrementType;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public Field() {
        this("", DataType.TEXT, false, AutoIncrementType.NONE, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public AutoIncrementType getAutoIncrementType() {
        return this.autoIncrementType;
    }

    public void setAutoIncrementType(AutoIncrementType autoIncrementType) {
        this.autoIncrementType = autoIncrementType;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getErrorMessage() {
        String message = null;
        if (!(this.type.equals((Object)DataType.INTEGER) || this.type.equals((Object)DataType.REAL) || this.autoIncrementType.equals((Object)AutoIncrementType.NONE))) {
            message = DbCoreNLS.Field_ErrorAutoIncrementNotAllowed;
        }
        if (message == null && !TableModel.validateName(this.getName())) {
            message = String.valueOf(DbCoreNLS.AddTableFieldDialog_InvalidName) + this.getName();
        }
        return message;
    }

    public static enum AutoIncrementType {
        NONE("NONE"),
        ASCENDING("ASC"),
        DESCENDING("DESC");

        private String strValue;

        private AutoIncrementType(String strValue) {
            this.strValue = strValue;
        }

        public String toString() {
            return this.strValue;
        }
    }

    public static enum DataType {
        INTEGER("INTEGER"),
        TEXT("TEXT"),
        REAL("REAL"),
        BLOB("BLOB");

        private String strValue;

        private DataType(String dataType) {
            this.strValue = dataType;
        }

        public String toString() {
            return this.strValue;
        }
    }
}

