/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.wizards;

import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.Field;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.wizards.AddTableFieldDialog;
import org.eclipse.andmore.android.db.core.ui.wizards.TableWizardContentProvider;
import org.eclipse.andmore.android.db.core.ui.wizards.TableWizardLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateTableWizardPage
extends WizardPage {
    private TableViewer viewer;
    private Text tableName;
    private TableModel table = null;
    private final String TABLE_CONTEXT_HELP_ID = "org.eclipse.andmore.android.db.core.create_table_wizard";

    protected CreateTableWizardPage() {
        super(DbCoreNLS.CreateTableWizardPage_UI_PageTitle);
        this.setTitle(DbCoreNLS.CreateTableWizardPage_UI_CreateNewTable);
        this.setMessage(DbCoreNLS.CreateTableWizardPage_UI_CreateNewTableAddingItsFields);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 0, true, false);
        Composite nameComposite = new Composite(composite, 4);
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        nameComposite.setLayoutData((Object)layoutData);
        layoutData = new GridData(16384, 0, false, false);
        Label tableNameLabel = new Label(nameComposite, 0);
        tableNameLabel.setLayoutData((Object)layoutData);
        tableNameLabel.setText(DbCoreNLS.CreateTableWizardPage_UI_TableName);
        layoutData = new GridData(4, 0, true, false);
        this.tableName = new Text(nameComposite, 2052);
        this.tableName.setLayoutData((Object)layoutData);
        this.tableName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CreateTableWizardPage.this.viewer != null) {
                    CreateTableWizardPage.this.viewer.refresh();
                    CreateTableWizardPage.this.validatePage();
                    ((TableModel)CreateTableWizardPage.this.viewer.getInput()).setName(CreateTableWizardPage.this.tableName.getText());
                }
            }
        });
        if (this.table != null && this.table.getName() != null) {
            this.tableName.setText(this.table.getName());
        }
        Composite emptyComposite = new Composite(composite, 131072);
        emptyComposite.setLayout((Layout)new GridLayout(1, false));
        emptyComposite.layout();
        this.viewer = new TableViewer(composite, 67594);
        layoutData = new GridData(4, 4, true, true);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(DbCoreNLS.CreateTableWizardPage_UI_Name);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(100);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(DbCoreNLS.CreateTableWizardPage_UI_Type);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(100);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(DbCoreNLS.CreateTableWizardPage_UI_Default);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(100);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(DbCoreNLS.CreateTableWizardPage_UI_Primary);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(100);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setLayoutData((Object)layoutData);
        this.viewer.setContentProvider((IContentProvider)new TableWizardContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableWizardLabelProvider());
        Composite buttonBar = new Composite(composite, 0);
        layoutData = new GridData(131072, 128, false, true);
        buttonBar.setLayoutData((Object)layoutData);
        buttonBar.setLayout((Layout)new FillLayout(512));
        Button add = new Button(buttonBar, 8);
        add.setText(DbCoreNLS.CreateTableWizardPage_UI_Add);
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddTableFieldDialog diag = new AddTableFieldDialog(CreateTableWizardPage.this.getShell());
                if (diag.open() == 0) {
                    ((TableModel)CreateTableWizardPage.this.viewer.getInput()).addField(diag.getField());
                    CreateTableWizardPage.this.viewer.refresh();
                    CreateTableWizardPage.this.validatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button edit = new Button(buttonBar, 8);
        edit.setText(DbCoreNLS.CreateTableWizardPage_UI_Edit);
        edit.setEnabled(false);
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddTableFieldDialog diag;
                if (CreateTableWizardPage.this.viewer.getTable().getSelectionCount() == 1 && (diag = new AddTableFieldDialog(CreateTableWizardPage.this.getShell(), ((TableModel)CreateTableWizardPage.this.viewer.getInput()).getFields().get(CreateTableWizardPage.this.viewer.getTable().getSelectionIndex()))).open() == 0) {
                    CreateTableWizardPage.this.viewer.update((Object)diag.getField(), null);
                    CreateTableWizardPage.this.validatePage();
                }
            }
        });
        final Button remove = new Button(buttonBar, 8);
        remove.setText(DbCoreNLS.CreateTableWizardPage_UI_Remove);
        remove.setEnabled(false);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = CreateTableWizardPage.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    for (Object obj : structuredSelection.toList()) {
                        if (!(obj instanceof Field)) continue;
                        ((TableModel)CreateTableWizardPage.this.viewer.getInput()).removeField((Field)obj);
                    }
                    CreateTableWizardPage.this.viewer.refresh();
                    CreateTableWizardPage.this.validatePage();
                }
            }
        });
        if (this.table == null) {
            this.table = new TableModel();
        }
        this.viewer.setInput((Object)this.table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionCount = CreateTableWizardPage.this.viewer.getTable().getSelectionCount();
                remove.setEnabled(selectionCount > 0);
                edit.setEnabled(selectionCount == 1);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddTableFieldDialog diag;
                if (CreateTableWizardPage.this.viewer.getTable().getSelectionCount() == 1 && (diag = new AddTableFieldDialog(CreateTableWizardPage.this.getShell(), ((TableModel)CreateTableWizardPage.this.viewer.getInput()).getFields().get(CreateTableWizardPage.this.viewer.getTable().getSelectionIndex()))).open() == 0) {
                    CreateTableWizardPage.this.viewer.update((Object)diag.getField(), null);
                    CreateTableWizardPage.this.validatePage();
                }
            }
        });
        this.viewer.refresh();
        composite.pack();
        composite.layout();
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        if (!this.table.getFields().isEmpty()) {
            this.validatePage();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.db.core.create_table_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.andmore.android.db.core.create_table_wizard");
    }

    public void setTable(TableModel table) {
        this.table = table;
    }

    public TableModel getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.tableName.getText();
    }

    private void validatePage() {
        String errMsg = null;
        if (this.tableName.getText().trim().length() == 0) {
            errMsg = DbCoreNLS.CreateTableWizardPage_UI_TableNameCannotBeEmpty;
        }
        if (errMsg == null && this.tableName.getText().trim().contains(" ")) {
            errMsg = DbCoreNLS.CreateTableWizardPage_UI_InvalidTableName;
        }
        if (!TableModel.validateName(this.tableName.getText())) {
            errMsg = DbCoreNLS.CreateTableWizardPage_UI_InvalidTableName;
        }
        if (errMsg == null && this.viewer.getTable().getItemCount() == 0) {
            errMsg = DbCoreNLS.CreateTableWizardPage_UI_YouMustSupplyAtLeastOneField;
        }
        if (errMsg == null) {
            errMsg = ((TableModel)this.viewer.getInput()).getErrorMessage();
        }
        this.setErrorMessage(errMsg);
        this.setPageComplete(errMsg == null);
    }
}

