/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.DDMSUtils;
import org.eclipse.andmore.android.db.core.CanRefreshStatus;
import org.eclipse.andmore.android.db.core.exception.AndmoreDbException;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.action.IDbCreatorNode;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.andmore.android.db.devices.model.DeviceDbNode;
import org.eclipse.andmore.android.db.devices.model.DeviceNode;
import org.eclipse.andmore.android.db.devices.utils.DeviceDbUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApplicationNode
extends AbstractTreeNode
implements IDbCreatorNode {
    private String appName;
    private String serialNumber;

    private ApplicationNode() {
    }

    public ApplicationNode(String appName, DeviceNode parent) {
        super((ITreeNode)parent);
        this.serialNumber = parent.getSerialNumber();
        this.appName = appName;
        this.setId(appName);
        this.setName(appName);
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore", (String)"icons/android.png");
        this.setIcon(icon);
    }

    public IStatus canRefresh() {
        IStatus status = null;
        boolean hasConnectedDb = false;
        for (ITreeNode treeNode : this.getChildren()) {
            if (!(treeNode instanceof DeviceDbNode)) continue;
            DeviceDbNode dbNode = (DeviceDbNode)treeNode;
            hasConnectedDb = dbNode.isConnected();
            break;
        }
        if (hasConnectedDb) {
            status = new CanRefreshStatus(16, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.ApplicationNode_ConnectedDbs_Refresh_Message, (Object)this.getName()));
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public void refresh() {
        this.clear();
        try {
            List applicationDatabases = DDMSUtils.getApplicationDatabases((String)this.serialNumber, (String)this.appName);
            ArrayList<DeviceDbNode> dbNodes = new ArrayList<DeviceDbNode>(applicationDatabases.size());
            for (String dbLocation : applicationDatabases) {
                IPath dbPath = DeviceDbUtils.getRemoteDbPath(this.appName, dbLocation);
                DeviceDbNode deviceDbNode = new DeviceDbNode(dbPath, this.serialNumber, (ITreeNode)this);
                dbNodes.add(deviceDbNode);
            }
            this.putChildren(dbNodes);
            this.setNodeStatus(Status.OK_STATUS);
        }
        catch (IOException e) {
            this.setNodeStatus((IStatus)new Status(4, "org.eclipse.andmore.android.db.devices", e.getMessage()));
        }
    }

    public IStatus createDb(String dbName) {
        return this.createDb(dbName, null);
    }

    public IStatus createDb(String dbName, List<TableModel> tables) {
        Status status = null;
        IPath remoteDbPath = DeviceDbUtils.getRemoteDbPath(this.appName, dbName);
        try {
            DeviceDbNode dbNode = new DeviceDbNode(remoteDbPath, this.serialNumber, (ITreeNode)this, true);
            if (tables != null) {
                dbNode.createTables(tables);
            }
            this.putChild((ITreeNode)dbNode);
        }
        catch (AndmoreDbException andmoreDbException) {
            status = new Status(4, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.ApplicationNode_Could_Not_Create_Database, (Object)remoteDbPath.toString(), (Object)this.serialNumber));
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public boolean isLeaf() {
        return false;
    }

    public IStatus deleteDb(IDbNode dbNode) {
        IStatus status = dbNode.deleteDb();
        if (status.isOK()) {
            this.removeChild((ITreeNode)dbNode);
        }
        return status;
    }
}

