/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.devfrm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.andmore.android.emulator.core.devfrm.IDeviceFrameworkSupport;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DeviceFrameworkManager {
    private static final String DEV_FRAMEWORK_EXTENSION_POINT_ID = "org.eclipse.andmore.android.emulator.deviceFramework";
    private static final String DEV_FRAMEWORK_ELEM = "deviceFramework";
    private static final String DEV_FRAMEWORK_IMPL_CLASS_ATTR = "class";
    private static DeviceFrameworkManager instance;
    private Collection<IDeviceFrameworkSupport> allFrameworks = new HashSet<IDeviceFrameworkSupport>();

    private DeviceFrameworkManager() {
        this.populateModel();
    }

    public static DeviceFrameworkManager getInstance() {
        if (instance == null) {
            instance = new DeviceFrameworkManager();
        }
        return instance;
    }

    public Collection<IAndroidEmulatorInstance> getAllInstances() {
        LinkedHashSet<IAndroidEmulatorInstance> allInstancesSet = new LinkedHashSet<IAndroidEmulatorInstance>();
        for (IDeviceFrameworkSupport devFramework : this.allFrameworks) {
            Collection<IAndroidEmulatorInstance> devFrmInstances = devFramework.getAllInstances();
            if (devFrmInstances == null) continue;
            allInstancesSet.addAll(devFrmInstances);
        }
        return allInstancesSet;
    }

    public Collection<IAndroidEmulatorInstance> getAvailableInstances() {
        Collection<IAndroidEmulatorInstance> allInstances = this.getAllInstances();
        ArrayList<IAndroidEmulatorInstance> enabledInstances = new ArrayList<IAndroidEmulatorInstance>(allInstances.size());
        for (IAndroidEmulatorInstance emulatorInstance : allInstances) {
            if (!emulatorInstance.isAvailable()) continue;
            enabledInstances.add(emulatorInstance);
        }
        return enabledInstances;
    }

    public Collection<String> getAllInstanceNames() {
        LinkedHashSet<String> allInstancesNames = new LinkedHashSet<String>();
        for (IDeviceFrameworkSupport devFramework : this.allFrameworks) {
            for (IAndroidEmulatorInstance instance : devFramework.getAllInstances()) {
                allInstancesNames.add(instance.getName());
            }
        }
        return allInstancesNames;
    }

    public IAndroidEmulatorInstance getInstanceByName(String name) {
        IAndroidEmulatorInstance instanceToReturn = null;
        for (IAndroidEmulatorInstance instance : this.getAllInstances()) {
            if (Platform.getOS().equals("win32")) {
                if (!instance.getName().toLowerCase().equals(name.toLowerCase())) continue;
                instanceToReturn = instance;
                break;
            }
            if (!instance.getName().equals(name)) continue;
            instanceToReturn = instance;
            break;
        }
        return instanceToReturn;
    }

    public Collection<IAndroidEmulatorInstance> getAllStartedInstances() {
        HashSet<IAndroidEmulatorInstance> startedInstancesSet = new HashSet<IAndroidEmulatorInstance>();
        for (IDeviceFrameworkSupport devFramework : this.allFrameworks) {
            Collection<IAndroidEmulatorInstance> devFrmInstances = devFramework.getAllInstances();
            if (devFrmInstances == null) continue;
            for (IAndroidEmulatorInstance instance : devFrmInstances) {
                if (!instance.isStarted()) continue;
                startedInstancesSet.add(instance);
            }
        }
        return startedInstancesSet;
    }

    public Collection<IAndroidEmulatorInstance> getAllConnectedInstances() {
        HashSet<IAndroidEmulatorInstance> connectedInstancesSet = new HashSet<IAndroidEmulatorInstance>();
        for (IDeviceFrameworkSupport devFramework : this.allFrameworks) {
            Collection<IAndroidEmulatorInstance> devFrmInstances = devFramework.getAllInstances();
            if (devFrmInstances == null) continue;
            for (IAndroidEmulatorInstance instance : devFrmInstances) {
                if (!instance.isConnected()) continue;
                connectedInstancesSet.add(instance);
            }
        }
        return connectedInstancesSet;
    }

    public Set<String> getAllStartedInstancesHosts() {
        HashSet<String> hostSet = new HashSet<String>();
        for (IDeviceFrameworkSupport devFramework : this.allFrameworks) {
            Collection<IAndroidEmulatorInstance> devFrmInstances = devFramework.getAllInstances();
            if (devFrmInstances == null) continue;
            for (IAndroidEmulatorInstance instance : devFrmInstances) {
                if (!instance.isStarted()) continue;
                hostSet.add(instance.getInstanceIdentifier());
            }
        }
        return hostSet;
    }

    private void populateModel() {
        IExtension[] extensions;
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(DEV_FRAMEWORK_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension aExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = aExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement aConfig = iConfigurationElementArray[n4];
                if (aConfig.getName().equals(DEV_FRAMEWORK_ELEM)) {
                    try {
                        IDeviceFrameworkSupport devFramework = (IDeviceFrameworkSupport)aConfig.createExecutableExtension(DEV_FRAMEWORK_IMPL_CLASS_ATTR);
                        if (devFramework != null) {
                            this.allFrameworks.add(devFramework);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++n4;
            }
            ++n2;
        }
    }
}

