/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.emulationui;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.emulationui.EmuViewerNode;
import org.eclipse.andmore.android.emulator.core.exception.InstanceNotFoundException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.utils.EmulatorCoreUtils;

public class EmuViewerRootNode
extends EmuViewerNode {
    private final String serial;

    public EmuViewerRootNode(String identifier) {
        super(null, "ROOT");
        this.serial = identifier;
    }

    public String getEmulatorIdentifier() {
        return this.serial;
    }

    @Override
    public String toString() {
        String classString;
        String serial = this.getEmulatorIdentifier();
        try {
            IAndroidEmulatorInstance instance = EmulatorCoreUtils.getAndroidInstanceByIdentifier(serial);
            classString = instance.getName();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            AndmoreLogger.warn((String)"The instance could not be found for retrieving its name. Using serial port instead.");
            classString = serial;
        }
        return classString;
    }
}

