/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.exception.StartTimeoutException;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;

public class StartEmulatorProcessLogic
implements IAndroidLogic {
    private static final String EMULATOR_NO_SNAPSHOT_LOAD = "-no-snapshot-load";
    private static final String EMULATOR_NO_SNAPSHOT_SAVE = "-no-snapshot-save";
    private static final String EMULATOR_HTTP_PROXY_PARAMETER = "-http-proxy";
    private static final String PROXY_AT = "@";
    private static final String PROXY_COLON = ":";
    private static final String PROXY_HTTP = "http://";
    private static final String EMULATOR_VIEW = "org.eclipse.andmore.android.emulator.androidView";
    private static final String ARM_EMULATOR_RELATIVE_PATH = "/tools/emulator-arm";
    private static final String x86_EMULATOR_RELATIVE_PATH = "/tools/emulator-x86";
    private static final String EMULATOR_RELATIVE_PATH = "/tools/emulator";
    private static final String EMULATOR_VM_PARAMETER = "-avd";
    private static String selectedEmulatorPath = "";

    @Override
    public void execute(final IAndroidLogicInstance instance, int timeout, IProgressMonitor monitor) throws InstanceStartException, StartTimeoutException, StartCancelledException {
        Collection openedAndroidViews;
        Process p;
        File userdataDir;
        long timeoutLimit = AndroidLogicUtils.getTimeoutLimit(timeout);
        AndmoreLogger.info((String)("Starting the Android Emulator process: " + instance));
        instance.setWindowHandle(0L);
        File userData = instance.getUserdata();
        if (userData != null && (userdataDir = userData.getParentFile()) != null && !userdataDir.exists()) {
            userdataDir.mkdirs();
        }
        selectedEmulatorPath = StartEmulatorProcessLogic.retrieveEmulatorExecutableName(instance);
        File emulatorExe = new File(SdkUtils.getSdkPath(), selectedEmulatorPath);
        LinkedList<String> cmdList = new LinkedList<String>();
        cmdList.add(emulatorExe.getAbsolutePath());
        cmdList.add(EMULATOR_VM_PARAMETER);
        cmdList.add(instance.getName());
        Properties propArgs = instance.getCommandLineArgumentsAsProperties();
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        String adtEmuOptions = store.getString("org.eclipse.andmore.emuOptions");
        StringTokenizer adtOptionsTokenizer = new StringTokenizer(adtEmuOptions, " ");
        while (adtOptionsTokenizer.hasMoreTokens()) {
            String nextToken = adtOptionsTokenizer.nextToken();
            cmdList.add(nextToken);
        }
        for (Object key : propArgs.keySet()) {
            String value = propArgs.getProperty(key.toString());
            if (key.equals("other")) {
                StringTokenizer stringTokenizer = new StringTokenizer(value, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    cmdList.add(stringTokenizer.nextToken());
                }
                continue;
            }
            if (value.trim().length() > 0 && !value.equals(Boolean.TRUE.toString())) {
                cmdList.add(key.toString());
                if (Platform.getOS().equals("macosx")) {
                    if (value.contains(" ")) {
                        value = "\"" + value + "\"";
                    }
                } else {
                    if (value.contains("\\")) {
                        value = value.replace("\\", "\\\\");
                    }
                    if (value.contains(" ")) {
                        value = value.replace(" ", "\\ ");
                    }
                }
                cmdList.add(value);
                continue;
            }
            if (value.trim().length() <= 0 || !value.equals(Boolean.TRUE.toString())) continue;
            cmdList.add(key.toString());
        }
        Properties properties = instance.getProperties();
        if (properties != null) {
            String useProxy = properties.getProperty("UseProxy", "false");
            if (Boolean.TRUE.toString().equals(useProxy)) {
                this.addEmulatorProxyParameter(cmdList);
            }
        }
        StringBuffer cmdLog = new StringBuffer("");
        boolean httpProxyParamFound = false;
        boolean logHttpProxyUsage = false;
        for (String param : cmdList) {
            if (!httpProxyParamFound) {
                if (!param.equals(EMULATOR_HTTP_PROXY_PARAMETER)) {
                    if (param.startsWith(emulatorExe.getAbsolutePath())) {
                        cmdLog.append(String.valueOf(selectedEmulatorPath) + " ");
                        continue;
                    }
                    cmdLog.append(String.valueOf(param) + " ");
                    continue;
                }
                httpProxyParamFound = true;
                logHttpProxyUsage = true;
                continue;
            }
            httpProxyParamFound = false;
        }
        if (logHttpProxyUsage) {
            cmdLog.append("\nProxy settings are being used by the started emulator (-http-proxy parameter).");
        }
        if (properties != null) {
            String startFromSnapshot = properties.getProperty("startFromSnapshot", "false");
            if (Boolean.FALSE.toString().equals(startFromSnapshot)) {
                cmdList.add(EMULATOR_NO_SNAPSHOT_LOAD);
            }
        }
        if (properties != null) {
            String saveSnapshot = properties.getProperty("SaveSnapshot", "false");
            if (Boolean.FALSE.toString().equals(saveSnapshot)) {
                cmdList.add(EMULATOR_NO_SNAPSHOT_SAVE);
            }
        }
        try {
            p = AndroidLogicUtils.executeProcess(cmdList.toArray(new String[0]), cmdLog.toString());
        }
        catch (AndroidException e) {
            throw new InstanceStartException(e);
        }
        AndmoreLogger.info((String)("Wait until and emulator with the VM " + instance.getName() + " is up "));
        AndroidLogicUtils.testProcessStatus(p);
        instance.setProcess(p);
        instance.setComposite(null);
        final String avdName = instance.getName();
        if (!Platform.getOS().equals("macosx") && !(openedAndroidViews = EclipseUtils.getAllOpenedViewsWithId((String)EMULATOR_VIEW)).isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    long windowHandle = -1L;
                    long timeOutToFindWindow = System.currentTimeMillis() + 30000L;
                    do {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                        try {
                            AndroidLogicUtils.testTimeout(timeOutToFindWindow, "");
                        }
                        catch (StartTimeoutException startTimeoutException) {
                            AndmoreLogger.debug((String)("Emulator window could not be found, instance :" + avdName));
                            break;
                        }
                        try {
                            int port = AndroidLogicUtils.getEmulatorPort(DDMSFacade.getSerialNumberByName((String)instance.getName()));
                            if (port <= 0) continue;
                            windowHandle = NativeUIUtils.getWindowHandle((String)instance.getName(), (int)port);
                        }
                        catch (Exception t) {
                            t.getCause().getMessage();
                            System.out.println(t.getCause().getMessage());
                        }
                    } while (windowHandle <= 0L);
                    if (windowHandle > 0L) {
                        instance.setWindowHandle(windowHandle);
                        NativeUIUtils.hideWindow((long)windowHandle);
                    }
                }
            };
            Thread getHandleThread = new Thread(runnable, "Window Handle Thread");
            getHandleThread.start();
        }
        if (instance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).equals(Boolean.TRUE.toString())) {
            do {
                try {
                    Thread.sleep(450L);
                }
                catch (InterruptedException interruptedException) {}
                AndroidLogicUtils.testCanceled(monitor);
                try {
                    AndroidLogicUtils.testTimeout(timeoutLimit, NLS.bind((String)EmulatorNLS.EXC_TimeoutWhileStarting, (Object)avdName));
                }
                catch (StartTimeoutException e) {
                    AndmoreLogger.debug((String)("Emulator start timeout has been reached, instance :" + avdName + " has device: " + instance.hasDevice() + "isOnline? " + DDMSFacade.isDeviceOnline((String)DDMSFacade.getSerialNumberByName((String)avdName))));
                    throw e;
                }
            } while (!this.isEmulatorReady(avdName));
        }
        Thread t = new Thread("Process Error"){

            @Override
            public void run() {
                boolean shouldTryAgain = true;
                int i = 0;
                while (i < 90 && shouldTryAgain) {
                    try {
                        2.sleep(500L);
                        Process p = instance.getProcess();
                        if (p != null) {
                            AndroidLogicUtils.testProcessStatus(p);
                        }
                    }
                    catch (Exception exception) {
                        AndmoreLogger.info(StartEmulatorProcessLogic.class, (String)"Trying to stop the emulator process: execution stopped too early");
                        DialogWithToggleUtils.showError((String)"emulator.unexpectedly.stopped", (String)EmulatorNLS.GEN_Error, (String)NLS.bind((String)EmulatorNLS.ERR_AndroidLogicPlugin_EmulatorStopped, (Object)instance.getName()));
                        shouldTryAgain = false;
                        try {
                            instance.stop(true);
                        }
                        catch (InstanceStopException ise) {
                            AndmoreLogger.error(StartEmulatorProcessLogic.class, (String)"Error trying to stop instance on process error", (Throwable)((Object)ise));
                        }
                    }
                    ++i;
                }
            }
        };
        t.start();
        AndmoreLogger.debug((String)("Emulator instance is now up and running... " + instance));
    }

    private static String retrieveEmulatorExecutableName(IAndroidLogicInstance instance) {
        String emulatorPath = null;
        Properties prop = instance.getProperties();
        String abiType = prop.getProperty("Abi_Type");
        emulatorPath = abiType == null || abiType.equals("") ? EMULATOR_RELATIVE_PATH : (abiType.toLowerCase().contains("arm") ? ARM_EMULATOR_RELATIVE_PATH : x86_EMULATOR_RELATIVE_PATH);
        File emulatorExe = new File(SdkUtils.getSdkPath(), String.valueOf(emulatorPath) + ".exe");
        if (!emulatorExe.exists()) {
            emulatorPath = EMULATOR_RELATIVE_PATH;
        }
        return emulatorPath;
    }

    private IProxyService retrieveProxyService() {
        IProxyService proxyService = null;
        ServiceReference service = EmulatorPlugin.getDefault().getBundle().getBundleContext().getServiceReference(IProxyService.class.getCanonicalName());
        if (service != null) {
            proxyService = (IProxyService)EmulatorPlugin.getDefault().getBundle().getBundleContext().getService(service);
        }
        return proxyService;
    }

    private void addEmulatorProxyParameter(List<String> cmdList) {
        IProxyService proxyService = this.retrieveProxyService();
        if (proxyService != null) {
            String host = proxyService.getProxyData("HTTP").getHost();
            int port = proxyService.getProxyData("HTTP").getPort();
            boolean isAuthenticationRequired = proxyService.getProxyData("HTTP").isRequiresAuthentication();
            String userId = proxyService.getProxyData("HTTP").getUserId();
            String password = proxyService.getProxyData("HTTP").getPassword();
            if (host != null) {
                cmdList.add(EMULATOR_HTTP_PROXY_PARAMETER);
                if (isAuthenticationRequired) {
                    cmdList.add(PROXY_HTTP + userId + PROXY_COLON + password + PROXY_AT + host + PROXY_COLON + Integer.valueOf(port).toString());
                } else {
                    cmdList.add(PROXY_HTTP + host + PROXY_COLON + Integer.valueOf(port).toString());
                }
            }
        }
    }

    private boolean isEmulatorReady(String avdName) {
        String serialNum = DDMSFacade.getSerialNumberByName((String)avdName);
        return DDMSFacade.isDeviceOnline((String)serialNum);
    }
}

