/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic.start;

import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.exception.StartTimeoutException;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AbstractStartAndroidEmulatorLogic;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AndroidEmulatorStarter {
    public static IStatus startInstance(IAndroidLogicInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        if (instance == null) {
            AndmoreLogger.error((String)"Abort start operation. Instance is null.");
            return new Status(4, "org.eclipse.andmore.android.emulator", EmulatorNLS.ERR_AndroidEmulatorStarter_InstanceNullPointer);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus status = Status.OK_STATUS;
        if (!instance.isStarted()) {
            int timeout = instance.getTimeout();
            if (timeout <= 0) {
                status = new Status(4, "org.eclipse.andmore.android.emulator", NLS.bind((String)EmulatorNLS.ERR_AndroidLogicPlugin_InvalidTimeoutValue, (Object[])new Object[]{timeout}));
                return status;
            }
            try {
                try {
                    AbstractStartAndroidEmulatorLogic logic;
                    Object modeObject;
                    AbstractStartAndroidEmulatorLogic.LogicMode mode = AbstractStartAndroidEmulatorLogic.LogicMode.START_MODE;
                    if (arguments != null && (modeObject = arguments.get(AbstractStartAndroidEmulatorLogic.LogicMode.class)) instanceof AbstractStartAndroidEmulatorLogic.LogicMode) {
                        mode = (AbstractStartAndroidEmulatorLogic.LogicMode)((Object)modeObject);
                    }
                    if ((logic = instance.getStartLogic()) == null) {
                        AndmoreLogger.error((String)"Cannot start emulator because a logic is not provided for that.");
                        throw new InstanceStartException(EmulatorNLS.ERR_AndroidEmulatorStarter_NoLogicAvailableForStart);
                    }
                    AndmoreLogger.debug((String)("Retrieved start logic: " + logic));
                    logic.execute(instance, mode, timeout, monitor);
                    AndroidLogicUtils.testCanceled(monitor);
                }
                catch (Exception e) {
                    AndmoreLogger.error((String)("An exception happened while trying to execute the start emulator logic for " + instance + " Try to rollback by executing the stop process..."));
                    try {
                        instance.stop(true);
                    }
                    catch (InstanceStopException instanceStopException) {
                        AndmoreLogger.error((String)"There was an error while forcing the stop the instance");
                    }
                    throw e;
                }
            }
            catch (StartTimeoutException e) {
                AndmoreLogger.error((String)("A timeout has happeded during the start Android Emulator Instance. " + instance + "Cause: " + e.getMessage()));
                status = new Status(4, "org.eclipse.andmore.android.emulator", e.getMessage(), (Throwable)((Object)e));
            }
            catch (InstanceStartException e) {
                AndmoreLogger.error((String)("It was not possible to start the Android Emulator Instance. " + instance + "Cause: " + e.getMessage()));
                status = new Status(4, "org.eclipse.andmore.android.emulator", e.getMessage());
            }
            catch (StartCancelledException startCancelledException) {
                AndmoreLogger.info((String)("Start operation was cancelled." + instance));
                status = Status.CANCEL_STATUS;
            }
            catch (Exception e) {
                AndmoreLogger.error((String)("Unknown exception while starting the emulator instance: " + instance + " Cause: " + e.getMessage()));
                status = new Status(4, "org.eclipse.andmore.android.emulator", e.getMessage());
            }
        }
        return status;
    }
}

