/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.controls;

import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.ui.controls.IAndroidComposite;
import org.eclipse.andmore.android.emulator.ui.controls.RemoteCLIDisplay;
import org.eclipse.andmore.android.emulator.ui.controls.maindisplay.MainDisplayComposite;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class UIHelper {
    public static IAndroidEmulatorInstance getInstanceAssociatedToControl(Control control) {
        IAndroidEmulatorInstance result = null;
        Control composite = null;
        TabFolder folder = null;
        if (control instanceof ScrolledComposite) {
            composite = ((ScrolledComposite)control).getContent();
            folder = (TabFolder)composite.getParent();
        } else if (control instanceof MainDisplayComposite) {
            composite = control.getParent();
            folder = (TabFolder)control.getParent().getParent();
        } else if (control instanceof Composite && control instanceof IAndroidComposite) {
            composite = control;
            folder = (TabFolder)control.getParent();
        } else if (control instanceof SWTRemoteDisplay || control instanceof RemoteCLIDisplay) {
            composite = control.getParent();
            folder = (TabFolder)composite.getParent();
        }
        if (folder != null) {
            TabItem[] items;
            TabItem[] tabItemArray = items = folder.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem item = tabItemArray[n2];
                if (item.getControl() == composite) {
                    result = (IAndroidEmulatorInstance)item.getData();
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static SWTRemoteDisplay getRemoteDisplayAssociatedToControl(Control control) {
        SWTRemoteDisplay remoteDisplay = null;
        if (control instanceof Composite && control instanceof IAndroidComposite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                if (childControl instanceof SWTRemoteDisplay) {
                    remoteDisplay = (SWTRemoteDisplay)childControl;
                    break;
                }
                ++n2;
            }
        }
        return remoteDisplay;
    }

    public static void ajustCoordinates(MouseEvent e, IAndroidComposite composite) {
        int y;
        int x;
        SWTRemoteDisplay mainDisplay = UIHelper.getRemoteDisplayAssociatedToControl((Control)composite);
        IRemoteDisplay.Rotation rotation = mainDisplay.getRotation();
        double zoomFactor = composite.getZoomFactor();
        switch (rotation) {
            case ROTATION_90DEG_COUNTERCLOCKWISE: {
                x = mainDisplay.getScreenWidth() - (int)((double)e.y / zoomFactor);
                y = (int)((double)e.x / zoomFactor);
                break;
            }
            default: {
                x = (int)((double)e.x / zoomFactor);
                y = (int)((double)e.y / zoomFactor);
            }
        }
        e.x = x;
        e.y = y;
    }
}

