/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.controls.skin;

import java.util.Collection;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.model.IInputLogic;
import org.eclipse.andmore.android.emulator.core.skin.AndroidPressKey;
import org.eclipse.andmore.android.emulator.core.skin.AndroidSkinBean;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidKey;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.ui.controls.IAndroidComposite;
import org.eclipse.andmore.android.emulator.ui.controls.UIHelper;
import org.eclipse.andmore.android.emulator.ui.controls.skin.AndroidSkinLayout;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.PlatformUI;

public class SkinComposite
extends Composite
implements IAndroidComposite {
    public static final int FIRST_REFRESH_DELAY_MS = 300;
    public static final int REFRESH_DELAY_PERIOD_MS = 100;
    private static final double MINIMUM_ZOOM_FACTOR = 1.0E-4;
    private static final double ZOOM_STEP = 0.5;
    private final Rectangle displayRectangle = new Rectangle(0, 0, 0, 0);
    private IAndroidSkin skin;
    private Image currentSkinImage;
    private IAndroidKey currentKey;
    private boolean ctrlPressed = false;
    private KeyListener keyListener;
    private MouseListener mainDisplayMouseListener;
    private MouseMoveListener mainDisplayMouseMoveListener;
    private boolean scrollBarsUsed = true;
    private boolean isMouseLeftButtonPressed;
    private boolean isMouseRightButtonPressed;
    private double zoomFactor = 1.0;
    private double embeddedViewScale = 1.0;
    private IInputLogic androidInput;
    private boolean isMouseMainDisplayLeftButtonPressed;
    IAndroidEmulatorInstance androidInstance;

    public SkinComposite(Composite parent, IAndroidSkin androidSkin, IAndroidEmulatorInstance instance) {
        super(parent, 776);
        this.skin = androidSkin;
        this.androidInstance = instance;
        this.addListeners();
        this.createListenersForMainDisplay();
        this.setToolTipText(null);
        this.androidInput = instance.getInputLogic();
        this.initScrollBars();
        if (!Platform.getOS().equals("macosx")) {
            this.hideEmulatorWindow();
        }
    }

    private void hideEmulatorWindow() {
        int port = AndroidLogicUtils.getEmulatorPort(DDMSFacade.getSerialNumberByName((String)this.androidInstance.getName()));
        long windowHandle = NativeUIUtils.getWindowHandle((String)this.androidInstance.getName(), (int)port);
        this.androidInstance.setWindowHandle(windowHandle);
        NativeUIUtils.hideWindow((long)windowHandle);
    }

    private void addListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SkinComposite.this.drawSkin(e.gc, null);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    SkinComposite.this.isMouseLeftButtonPressed = false;
                } else if (e.button == 3) {
                    SkinComposite.this.isMouseRightButtonPressed = false;
                }
                if (e.button == 1) {
                    SkinComposite.this.cancelMouseSelection();
                }
            }

            public void mouseDown(MouseEvent e) {
                SkinComposite.this.setFocus();
                if (e.button == 1) {
                    SkinComposite.this.isMouseLeftButtonPressed = true;
                } else if (e.button == 3) {
                    SkinComposite.this.isMouseRightButtonPressed = true;
                }
                if (SkinComposite.this.currentKey != null) {
                    ImageData mergedImage = SkinComposite.this.getKeyImageData(SkinComposite.this.currentKey, false);
                    SkinComposite.this.setSkinImage(mergedImage, SkinComposite.this.currentKey, true);
                    if (e.button == 1 && !SkinComposite.this.isMouseRightButtonPressed && SkinComposite.this.currentKey != null) {
                        SkinComposite.this.androidInput.sendClick(SkinComposite.this.currentKey.getKeysym(), true);
                    } else if (e.button == 3) {
                        SkinComposite.this.cancelMouseSelection();
                    }
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int posX = (int)((double)(e.x + ((SkinComposite)SkinComposite.this).displayRectangle.x) / SkinComposite.this.zoomFactor);
                int posY = (int)((double)(e.y + ((SkinComposite)SkinComposite.this).displayRectangle.y) / SkinComposite.this.zoomFactor);
                IAndroidKey keyData = SkinComposite.this.getSkinKey(posX, posY);
                if (SkinComposite.this.isMouseLeftButtonPressed && keyData != SkinComposite.this.currentKey) {
                    SkinComposite.this.cancelMouseSelection();
                }
                if (!SkinComposite.this.isMouseLeftButtonPressed && SkinComposite.this.currentKey != keyData) {
                    SkinComposite.this.changeCurrentKey(keyData);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent event) {
                if (SkinComposite.this.ctrlPressed) {
                    double roundedZoomFactor = Math.floor(SkinComposite.this.zoomFactor / 0.5) * 0.5;
                    if (event.count > 0 && roundedZoomFactor < 2.0) {
                        SkinComposite.this.setZoomFactor(roundedZoomFactor + 0.5);
                        SkinComposite.this.applyZoomFactor();
                    } else if (event.count < 0 && roundedZoomFactor > 0.25) {
                        SkinComposite.this.setZoomFactor(roundedZoomFactor - 0.5);
                        SkinComposite.this.applyZoomFactor();
                    }
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseevent) {
                SkinComposite.this.changeCurrentKey(null);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (SkinComposite.this.scrollBarsUsed) {
                    SkinComposite.this.synchronizeScrollBars();
                } else {
                    ImageData imageData = SkinComposite.this.getImageData(false, false);
                    SkinComposite.this.setSkinImage(imageData, null, false);
                }
            }
        });
    }

    @Override
    public void applyLayout(String layoutName) {
        AndroidSkinBean skinBean = null;
        try {
            skinBean = this.skin.getSkinBean(layoutName);
        }
        catch (SkinException e) {
            AndmoreLogger.error((String)("The skin data could not be retrieved from skin files. Cause: " + e.getMessage()));
            EclipseUtils.showErrorDialog((AndroidException)e);
        }
        if (skinBean != null) {
            this.currentKey = null;
            RGB color = this.skin.getBackgroundColor(layoutName);
            this.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), color));
            Layout prevLayout = this.getLayout();
            if (prevLayout instanceof AndroidSkinLayout) {
                ((AndroidSkinLayout)prevLayout).dispose();
            }
            AndroidSkinLayout androidLayout = new AndroidSkinLayout(skinBean, this.skin.isFlipSupported());
            this.setLayout(androidLayout);
            this.embeddedViewScale = skinBean.getEmbeddedViewScale();
            this.layout();
            this.redraw();
        }
    }

    public void dispose() {
        Layout layout;
        if (this.androidInput != null) {
            this.androidInput.dispose();
        }
        if (this.currentSkinImage != null) {
            this.currentSkinImage.dispose();
        }
        if ((layout = this.getLayout()) instanceof AndroidSkinLayout) {
            ((AndroidSkinLayout)layout).dispose();
        }
        this.skin = null;
        this.currentKey = null;
        this.keyListener = null;
        this.mainDisplayMouseListener = null;
        this.mainDisplayMouseMoveListener = null;
        if (!Platform.getOS().equals("macosx")) {
            long hnd = this.androidInstance.getWindowHandle();
            if (hnd > 0L) {
                NativeUIUtils.showWindow((long)hnd);
                NativeUIUtils.restoreWindow((long)hnd);
            }
            this.androidInstance.setWindowHandle(0L);
        }
        super.dispose();
    }

    @Override
    public void applyZoomFactor() {
        if (this.getZoomFactor() == 0.0) {
            this.scrollBarsUsed = false;
            this.getVerticalBar().setEnabled(false);
            this.getHorizontalBar().setEnabled(false);
        } else {
            this.scrollBarsUsed = true;
            this.getVerticalBar().setEnabled(true);
            this.getHorizontalBar().setEnabled(true);
        }
        this.displayRectangle.x = 0;
        this.displayRectangle.y = 0;
        this.redrawReleasedImage();
    }

    private void redrawReleasedImage() {
        if (this.currentSkinImage != null) {
            ImageData imageData = this.getImageData(false, false);
            this.setSkinImage(imageData, null, false);
            this.layout();
            this.redraw();
        }
        if (this.scrollBarsUsed) {
            this.synchronizeScrollBars();
        }
    }

    private void drawSkin(GC gcUsedToDraw, IAndroidKey changedKey) {
        if (this.currentSkinImage == null) {
            IAndroidEmulatorInstance instance = UIHelper.getInstanceAssociatedToControl((Control)this);
            ImageData initialSkinImage = this.getImageData(false, false);
            this.setSkinImage(initialSkinImage, null, false);
            this.applyLayout(instance.getCurrentLayout());
            if (this.scrollBarsUsed) {
                this.synchronizeScrollBars();
            }
        }
        if (this.displayRectangle != null) {
            int destHeight;
            int destWidth;
            int destYPos;
            int destXPos;
            int srcHeight;
            int srcWidth;
            int srcYPos;
            int srcXPos;
            if (changedKey == null) {
                srcXPos = this.displayRectangle.x;
                srcYPos = this.displayRectangle.y;
                srcWidth = this.displayRectangle.width;
                srcHeight = this.displayRectangle.height;
                destXPos = 0;
                destYPos = 0;
                destWidth = Math.min(this.currentSkinImage.getImageData().width, this.displayRectangle.width);
                destHeight = Math.min(this.currentSkinImage.getImageData().height, this.displayRectangle.height);
            } else {
                srcXPos = (int)(changedKey.getKeyArea().x > 0 ? (double)changedKey.getKeyArea().x * this.zoomFactor : 0.0);
                srcYPos = (int)(changedKey.getKeyArea().y > 0 ? (double)changedKey.getKeyArea().y * this.zoomFactor : 0.0);
                srcWidth = (int)((double)changedKey.getKeyArea().width * this.zoomFactor);
                srcHeight = (int)((double)changedKey.getKeyArea().height * this.zoomFactor);
                destXPos = srcXPos - this.displayRectangle.x;
                destYPos = srcYPos - this.displayRectangle.y;
                destWidth = srcWidth;
                destHeight = srcHeight;
            }
            gcUsedToDraw.drawImage(this.currentSkinImage, srcXPos, srcYPos, srcWidth, srcHeight, destXPos, destYPos, destWidth, destHeight);
        }
    }

    private void setSkinImage(ImageData imageToSet, IAndroidKey changedKey, boolean forceDraw) {
        this.recalculateZoomFactor();
        if (imageToSet != null) {
            if (this.currentSkinImage != null) {
                this.currentSkinImage.dispose();
            }
            int width = this.zoomFactor == 1.0E-4 ? 1 : (int)((double)imageToSet.width * this.zoomFactor);
            int height = this.zoomFactor == 1.0E-4 ? 1 : (int)((double)imageToSet.height * this.zoomFactor);
            this.currentSkinImage = new Image((Device)this.getDisplay(), imageToSet.scaledTo(width, height));
            if (changedKey == null) {
                this.displayRectangle.x = 0;
                this.displayRectangle.y = 0;
            }
            if (forceDraw) {
                this.layout();
                GC gc = new GC((Drawable)this);
                this.drawSkin(gc, changedKey);
                gc.dispose();
            }
        } else {
            AndmoreLogger.info((String)"It was requested to set a skin image that was null. Operation aborted.");
        }
    }

    private void synchronizeScrollBars() {
        if (this.currentSkinImage != null) {
            Rectangle imageBound = this.currentSkinImage.getBounds();
            int cw = this.getClientArea().width;
            int ch = this.getClientArea().height;
            ScrollBar horizontal = this.getHorizontalBar();
            horizontal.setIncrement(cw / 100);
            horizontal.setPageIncrement(cw / 2);
            horizontal.setMaximum(imageBound.width);
            horizontal.setThumb(cw);
            horizontal.setSelection(this.displayRectangle.x);
            ScrollBar vertical = this.getVerticalBar();
            vertical.setIncrement(ch / 100);
            vertical.setPageIncrement(ch / 2);
            vertical.setMaximum(imageBound.height);
            vertical.setThumb(ch);
            vertical.setSelection(this.displayRectangle.y);
            if (horizontal.getMaximum() > cw) {
                horizontal.setEnabled(true);
            } else {
                horizontal.setEnabled(false);
            }
            if (vertical.getMaximum() > ch) {
                vertical.setEnabled(true);
            } else {
                vertical.setEnabled(false);
            }
        }
    }

    private void initScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setEnabled(false);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((SkinComposite)SkinComposite.this).displayRectangle.x = ((ScrollBar)event.widget).getSelection();
                SkinComposite.this.layout();
                SkinComposite.this.redraw();
            }
        });
        ScrollBar vertical = this.getVerticalBar();
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((SkinComposite)SkinComposite.this).displayRectangle.y = ((ScrollBar)event.widget).getSelection();
                SkinComposite.this.layout();
                SkinComposite.this.redraw();
            }
        });
        AndmoreLogger.debug((String)"Initialized scroll bars");
    }

    private IAndroidKey getSkinKey(int x, int y) {
        IAndroidKey keyToReturn = null;
        IAndroidEmulatorInstance instance = UIHelper.getInstanceAssociatedToControl((Control)this);
        Collection<IAndroidKey> keyAreas = this.skin.getKeyDataCollection(instance.getCurrentLayout());
        if (keyAreas != null) {
            for (IAndroidKey key : keyAreas) {
                AndroidPressKey defaultKeyData;
                if (!key.isInsideKey(x, y) || key instanceof AndroidPressKey && !(defaultKeyData = (AndroidPressKey)key).isFlipSlideValid(false)) continue;
                keyToReturn = key;
                break;
            }
        }
        return keyToReturn;
    }

    private ImageData getImageData(boolean isPressed, boolean isEnter) {
        ImageData imageData = null;
        IAndroidEmulatorInstance instance = UIHelper.getInstanceAssociatedToControl((Control)this);
        try {
            imageData = isPressed ? this.skin.getPressedImageData(instance.getCurrentLayout()) : (isEnter ? this.skin.getEnterImageData(instance.getCurrentLayout()) : this.skin.getReleasedImageData(instance.getCurrentLayout()));
        }
        catch (SkinException e) {
            AndmoreLogger.error((String)("The image requested from skin could not be retrieved. isPressed=" + isPressed + "; message=" + e.getMessage()));
            EclipseUtils.showErrorDialog((AndroidException)e);
            AndmoreLogger.error((String)"The skin could not provide an important resource. Stopping the instance");
            try {
                instance.stop(true);
            }
            catch (InstanceStopException instanceStopException) {
                AndmoreLogger.error((String)"Error while running service for stopping virtual machine");
                EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_General_CannotRunStopService);
            }
        }
        return imageData;
    }

    private ImageData getKeyImageData(IAndroidKey key, boolean isEnter) {
        ImageData releasedImage = this.getImageData(false, false);
        ImageData keyImage = isEnter ? this.getImageData(false, true) : this.getImageData(true, false);
        ImageData resultingImage = (ImageData)releasedImage.clone();
        Rectangle keyArea = key.getKeyArea();
        int resultingImageSize = resultingImage.width * keyArea.height;
        int[] keyPixelBuffer = new int[resultingImageSize];
        int startY = keyArea.y < 0 ? 0 : keyArea.y;
        keyImage.getPixels(0, startY, resultingImageSize, keyPixelBuffer, 0);
        int line = 0;
        while (line < keyArea.height) {
            int pos = line * resultingImage.width + Math.abs(keyArea.x);
            int startX = Math.abs(keyArea.x);
            startY = (keyArea.y < 0 ? 0 : keyArea.y) + line;
            if (startY >= 0) {
                int putWidth = keyArea.x < 0 ? keyArea.width - startX : keyArea.width;
                resultingImage.setPixels(startX, startY, putWidth, keyPixelBuffer, pos);
            }
            ++line;
        }
        return resultingImage;
    }

    private void cancelMouseSelection() {
        if (this.currentKey != null) {
            ImageData newImageData = this.getImageData(false, true);
            this.setSkinImage(newImageData, this.currentKey, true);
            this.androidInput.sendClick(this.currentKey.getKeysym(), false);
        }
    }

    private void changeCurrentKey(IAndroidKey newKey) {
        ImageData newImage;
        if (this.currentKey != null) {
            newImage = this.getImageData(false, false);
            this.setSkinImage(newImage, this.currentKey, true);
            this.setToolTipText(null);
        }
        if (newKey != null) {
            newImage = this.getKeyImageData(newKey, true);
            this.setSkinImage(newImage, newKey, true);
            this.setToolTipText(newKey.getToolTip());
        }
        this.currentKey = newKey;
    }

    Rectangle getDisplayRectangle() {
        return this.displayRectangle;
    }

    void updateDisplayRectangle() {
        if (this.currentSkinImage != null) {
            int hEdge;
            int vEdge;
            int clientAreaWidth = this.getClientArea().width;
            int clientAreaHeight = this.getClientArea().height;
            int currentSkinHeight = this.currentSkinImage.getImageData().height;
            int currentSkinWidth = this.currentSkinImage.getImageData().width;
            int blankY = clientAreaHeight - (currentSkinHeight - this.displayRectangle.y);
            if (blankY > 0) {
                int candidateY = this.displayRectangle.y - blankY;
                this.displayRectangle.y = candidateY > 0 ? candidateY : 0;
            }
            this.displayRectangle.height = (vEdge = this.displayRectangle.y + clientAreaHeight) > currentSkinHeight ? currentSkinHeight - this.displayRectangle.y : clientAreaHeight;
            int blankX = clientAreaWidth - (currentSkinWidth - this.displayRectangle.x);
            if (blankX > 0) {
                int candidateX = this.displayRectangle.x - blankX;
                this.displayRectangle.x = candidateX > 0 ? candidateX : 0;
            }
            this.displayRectangle.width = (hEdge = this.displayRectangle.x + clientAreaWidth) > currentSkinWidth ? currentSkinWidth - this.displayRectangle.x : clientAreaWidth;
        }
    }

    void recalculateZoomFactor() {
        if (!this.scrollBarsUsed) {
            Rectangle clientArea = this.getClientArea();
            if (clientArea.width == 0 || clientArea.height == 0) {
                this.setZoomFactor(1.0E-4);
            } else {
                ImageData currentSkin = this.getImageData(false, false);
                double widthRatio = (double)clientArea.width / (double)currentSkin.width;
                double heightRatio = (double)clientArea.height / (double)currentSkin.height;
                this.setZoomFactor(Math.min(widthRatio, heightRatio));
            }
        }
    }

    @Override
    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public boolean isFitToWindowSelected() {
        return !this.scrollBarsUsed;
    }

    @Override
    public void setZoomFactor(double zoom) {
        this.zoomFactor = zoom;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public MouseListener getMouseListener() {
        return this.mainDisplayMouseListener;
    }

    @Override
    public MouseMoveListener getMouseMoveListener() {
        return this.mainDisplayMouseMoveListener;
    }

    private void createListenersForMainDisplay() {
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                int keyCode = arg0.keyCode;
                if (keyCode == 262144) {
                    SkinComposite.this.ctrlPressed = true;
                } else {
                    if (keyCode == 0x1000002 || keyCode == 0x1000003 || keyCode == 0x1000004 || keyCode == 0x1000001) {
                        int dpadRotation = SkinComposite.this.skin.getDpadRotation(SkinComposite.this.androidInstance.getCurrentLayout());
                        keyCode = SkinComposite.this.getRotatedKeyCode(keyCode, dpadRotation);
                    }
                    SkinComposite.this.androidInput.sendKey(arg0.character, keyCode, SkinComposite.this.skin.getKeyCodes());
                }
            }

            public void keyReleased(KeyEvent arg0) {
                int keyCode = arg0.keyCode;
                if (keyCode == 262144) {
                    SkinComposite.this.ctrlPressed = false;
                }
            }
        };
        this.mainDisplayMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (SkinComposite.this.isMouseMainDisplayLeftButtonPressed) {
                    UIHelper.ajustCoordinates(e, SkinComposite.this);
                    SkinComposite.this.androidInput.sendMouseMove((int)((double)e.x / SkinComposite.this.embeddedViewScale), (int)((double)e.y / SkinComposite.this.embeddedViewScale));
                }
            }
        };
        this.mainDisplayMouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    SkinComposite.this.isMouseMainDisplayLeftButtonPressed = false;
                    UIHelper.ajustCoordinates(e, SkinComposite.this);
                    SkinComposite.this.androidInput.sendMouseUp((int)((double)e.x / SkinComposite.this.embeddedViewScale), (int)((double)e.y / SkinComposite.this.embeddedViewScale));
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    UIHelper.ajustCoordinates(e, SkinComposite.this);
                    SkinComposite.this.androidInput.sendMouseDown((int)((double)e.x / SkinComposite.this.embeddedViewScale), (int)((double)e.y / SkinComposite.this.embeddedViewScale));
                    SkinComposite.this.isMouseMainDisplayLeftButtonPressed = true;
                }
            }
        };
    }

    private int getRotatedKeyCode(int keyCode, int dpadRotation) {
        switch (dpadRotation % 4) {
            case 1: {
                switch (keyCode) {
                    case 0x1000002: {
                        keyCode = 0x1000004;
                        break;
                    }
                    case 0x1000003: {
                        keyCode = 0x1000002;
                        break;
                    }
                    case 0x1000004: {
                        keyCode = 0x1000001;
                        break;
                    }
                    case 0x1000001: {
                        keyCode = 0x1000003;
                    }
                }
                break;
            }
            case 2: {
                switch (keyCode) {
                    case 0x1000002: {
                        keyCode = 0x1000001;
                        break;
                    }
                    case 0x1000003: {
                        keyCode = 0x1000004;
                        break;
                    }
                    case 0x1000004: {
                        keyCode = 0x1000003;
                        break;
                    }
                    case 0x1000001: {
                        keyCode = 0x1000002;
                    }
                }
                break;
            }
            case 3: {
                switch (keyCode) {
                    case 0x1000002: {
                        keyCode = 0x1000003;
                        break;
                    }
                    case 0x1000003: {
                        keyCode = 0x1000001;
                        break;
                    }
                    case 0x1000004: {
                        keyCode = 0x1000002;
                        break;
                    }
                    case 0x1000001: {
                        keyCode = 0x1000004;
                    }
                }
                break;
            }
        }
        return keyCode;
    }
}

