/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.handlers;

import java.util.Map;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.ui.handlers.AbstractZoomHandler;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.andmore.android.emulator.ui.view.AndroidViewData;
import org.eclipse.ui.IViewPart;

public class ZoomInOutHandler
extends AbstractZoomHandler {
    @Override
    protected double getZoomFactor(Map parameters) {
        IViewPart viewPart;
        double zoomFactor = 1.0;
        IAndroidEmulatorInstance instance = AbstractAndroidView.getActiveInstance();
        String viewId = (String)parameters.get("activeViewId");
        String changeFactorString = (String)parameters.get("zoomChangeFactor");
        if (instance != null && viewId != null && changeFactorString != null && (viewPart = EclipseUtils.getActiveView((String)viewId)) instanceof AbstractAndroidView) {
            AbstractAndroidView view = (AbstractAndroidView)viewPart;
            double currentZoomFactor = view.getZoomFactor(instance);
            try {
                double changeZoomFactor = Double.parseDouble(changeFactorString);
                zoomFactor = currentZoomFactor + changeZoomFactor;
            }
            catch (Exception exception) {
                zoomFactor = currentZoomFactor;
            }
        }
        if (zoomFactor < 0.25) {
            zoomFactor = 0.25;
        } else if (zoomFactor > 2.0) {
            zoomFactor = 2.0;
        }
        return zoomFactor;
    }

    @Override
    protected boolean testZoomFactor(AndroidViewData viewData, Map parameters, double zoomFactor) {
        return false;
    }
}

