/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.collector.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.logger.collector.core.ILogFile;
import org.eclipse.andmore.android.logger.collector.util.LogCollectorExtensionLoader;
import org.eclipse.andmore.android.logger.collector.util.LoggerCollectorMessages;
import org.eclipse.andmore.android.logger.collector.util.PlatformException;
import org.eclipse.andmore.android.logger.collector.util.ZipUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.TableItem;

public class CollectLogFile {
    private final ArrayList<ILogFile> logs = LogCollectorExtensionLoader.getLogFiles();

    public ArrayList<ILogFile> getLogFileList() {
        return this.logs;
    }

    public boolean zipLogFiles(String fileName, List<TableItem> checkedItems) throws PlatformException {
        boolean toReturn = true;
        String nomalizedDirectory = FileUtil.normalizePath((String)new Path(fileName).removeLastSegments(1).toOSString());
        String tempFolderPath = String.valueOf(FileUtil.normalizePath((String)nomalizedDirectory)) + "temp" + Double.toString(Math.random()).replaceAll("\\.", "0") + File.separator;
        Path tempFolder = new Path(tempFolderPath);
        try {
            try {
                FileUtil.mkdir((String)tempFolderPath);
                for (TableItem item : checkedItems) {
                    ILogFile logFile = (ILogFile)item.getData();
                    IPath outputFolder = tempFolder.append(logFile.getOutputSubfolderName());
                    FileUtil.mkdir((String)outputFolder.toOSString());
                    for (IPath path : logFile.getLogFilePath()) {
                        FileUtil.copy((File)new File(path.toOSString()), (File)new File(outputFolder.append(path.lastSegment()).toOSString()));
                    }
                }
                new ZipUtil(fileName, tempFolderPath).zip();
            }
            catch (IOException iOException) {
                toReturn = false;
                throw new PlatformException((IStatus)new Status(8, "org.eclipse.andmore.android.logger.collector", LoggerCollectorMessages.getInstance().getString("error.logger.collector.zip")));
            }
        }
        finally {
            FileUtil.delete((String)tempFolderPath);
        }
        return toReturn;
    }
}

