/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.handlers;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.remote.RemoteDevicePlugin;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class USBModeServiceHandler
extends ServiceHandler {
    private static final int MIN_SDK_VERSION = 6;

    public IServiceHandler newInstance() {
        return new USBModeServiceHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.beginTask(RemoteDeviceNLS.USBModeServiceHandler_MsgStartingProcessOfSwitchingToUSBMode, 1000);
        ISerialNumbered device = (ISerialNumbered)instance;
        int deviceSdkVersion = -1;
        try {
            deviceSdkVersion = Integer.parseInt(DDMSFacade.getDeviceProperty((String)device.getSerialNumber(), (String)"ro.build.version.sdk"));
            subMonitor.worked(100);
        }
        catch (Exception e) {
            AndmoreLogger.error(USBModeServiceHandler.class, (String)RemoteDeviceNLS.USBModeServiceHandler_2, (Throwable)e);
        }
        if (!subMonitor.isCanceled() && deviceSdkVersion < 6 && deviceSdkVersion != -1) {
            EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.Title_ReturningToUSBConnectionDialog, (String)RemoteDeviceNLS.USBModeServiceHandler_MsgUnableToSwitchToUSBDueToSDKVersion);
        } else if (!subMonitor.isCanceled()) {
            subMonitor.setTaskName(RemoteDeviceNLS.WirelessServiceHandler_MsgRetrievingDeviceIPNumber);
            Properties properties = instance.getProperties();
            String host = properties.getProperty("org.eclipse.andmore.android.remote.hostProperty");
            String port = properties.getProperty("org.eclipse.andmore.android.remote.portProperty");
            String timeout = properties.getProperty("org.eclipse.andmore.android.remote.timeoutProperty");
            subMonitor.worked(600);
            if (host == null) {
                EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.Title_ReturningToUSBConnectionDialog, (String)RemoteDeviceNLS.ERR_WirelessWizard_No_IP);
            } else if (!subMonitor.isCanceled()) {
                subMonitor.setTaskName(RemoteDeviceNLS.USBModeServiceHandler_MsgSwithcingTCPToUSB);
                try {
                    IStatus status = DDMSFacade.switchFromTCPConnectionModeToUSBConnectionMode((ISerialNumbered)device, (String)host, (String)port, (int)Integer.parseInt(timeout), (IProgressMonitor)subMonitor.newChild(300));
                    if (status != null && status.getSeverity() == 4) {
                        EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.Title_ReturningToUSBConnectionDialog, (String)NLS.bind((String)RemoteDeviceNLS.USBModeServiceHandler_MsgItWasNotPossibleToSwitchDeviceToUSBMode, (Object)host), (IStatus)status);
                    } else {
                        EclipseUtils.showInformationDialog((String)RemoteDeviceNLS.Title_ReturningToUSBConnectionDialog, (String)NLS.bind((String)RemoteDeviceNLS.USBModeServiceHandler_MsgSuccess, (Object)host));
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)NLS.bind((String)"It was not possible to switch the android device {0} connection mode to USB.", (Object)device.getDeviceName()), (Throwable)e);
                    EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.Title_ReturningToUSBConnectionDialog, (String)NLS.bind((String)RemoteDeviceNLS.USBModeServiceHandler_MsgItWasNotPossibleToSwitchToUSBMode, (Object)device.getDeviceName()));
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus updatingService(IInstance arg0, IProgressMonitor arg1) {
        return Status.OK_STATUS;
    }

    public void setService(IService service) {
        super.setService(service);
        if (service != null) {
            service.setVisible(RemoteDevicePlugin.isWifiServiceEnabled());
        }
    }
}

