/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CleanProjects
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.isClosing() && (window = workbench.getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            Iterator it = sselection.iterator();
            ArrayList<IProject> projectList = new ArrayList<IProject>(sselection.size());
            while (it.hasNext()) {
                Object resource = it.next();
                if (resource instanceof IProject) {
                    projectList.add((IProject)resource);
                    continue;
                }
                if (!(resource instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)resource;
                projectList.add((IProject)adaptable.getAdapter(IProject.class));
            }
            if (projectList.size() > 0) {
                CleanProjectsJob job = new CleanProjectsJob(projectList);
                job.schedule();
            }
        }
        return null;
    }

    private final class CleanProjectsJob
    extends Job {
        private List<IProject> projectList;

        private CleanProjectsJob(List<IProject> projects) {
            super(AndroidNLS.UI_CleanProjectsJob_Name);
            this.projectList = null;
            this.projectList = projects;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(AndroidNLS.UI_CleanProjectsJob_Description, this.projectList.size());
            for (IProject p : this.projectList) {
                try {
                    p.build(15, monitor);
                    monitor.worked(1);
                }
                catch (CoreException e) {
                    AndmoreLogger.error(CleanProjectsJob.class, (String)("Error cleaning project " + p.getName() + ". "), (Throwable)e);
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

