/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.multidex;

import com.android.sdklib.internal.project.ProjectProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;

public class MultiDexManager {
    private static final String MULTIDEX_MAIN_DEX_LIST_PATH = "/files/main-dex-list.txt";
    private static final String MULTIDEX_MAIN_DEX_LIST_FILENAME = "main-dex-list.txt";
    private static final String MULTIDEX_ENABLED_PROPERTY = "multidex.enabled";
    private static final String MULTIDEX_ENABLED_STATEMENT = "multidex.enabled=true";
    private static final String MULTIDEX_MAIN_DEX_LIST_PROPERTY = "multidex.main-dex-list";
    private static final String MULTIDEX_MAIN_DEX_LIST_STATEMENT = "multidex.main-dex-list=main-dex-list.txt";
    private static final String DEFAULT_PROPERTIES_FILENAME = "default.properties";
    private static final String PROJECT_PROPERTIES_FILENAME = "project.properties";
    private static final String NL = System.getProperty("line.separator");

    public static IStatus enableMultiDex(IProject project, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        File projectPropertiesFile = project.getFile(PROJECT_PROPERTIES_FILENAME).getLocation().toFile();
        File defaultPropertiesFile = project.getFile(DEFAULT_PROPERTIES_FILENAME).getLocation().toFile();
        if (projectPropertiesFile.canWrite()) {
            defaultPropertiesFile = projectPropertiesFile;
        }
        try {
            MultiDexManager.addMultiDexEnabledStatement(defaultPropertiesFile);
            File mainDexListFile = MultiDexManager.getMainDexListFile(project);
            if (mainDexListFile == null) {
                MultiDexManager.addMainDexListStatement(defaultPropertiesFile);
                if (!MultiDexManager.fileExists(mainDexListFile)) {
                    MultiDexManager.copyMainDexListFile(project, monitor);
                }
            }
            try {
                project.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        catch (Exception e) {
            AndmoreLogger.error(MultiDexManager.class, (String)"Error while setting main-class-list for use with multidex", (Throwable)e);
            status = new Status(4, "org.eclipse.andmore.android", "Could not enable multidex", (Throwable)e);
        }
        AndmoreLogger.collectUsageData((String)"obfuscation", (String)"obfuscate_project", (String)"operation_executed", (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
        return status;
    }

    public static IStatus disableMultiDex(IProject project) {
        IStatus status = Status.OK_STATUS;
        File projectPropertiesFile = project.getFile(PROJECT_PROPERTIES_FILENAME).getLocation().toFile();
        File defaultPropertiesFile = project.getFile(DEFAULT_PROPERTIES_FILENAME).getLocation().toFile();
        if (projectPropertiesFile.canWrite()) {
            defaultPropertiesFile = projectPropertiesFile;
        }
        try {
            MultiDexManager.removeMultiStatements(defaultPropertiesFile);
            try {
                project.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        catch (Exception e) {
            AndmoreLogger.error(MultiDexManager.class, (String)"Error while removing MultiDex settings", (Throwable)e);
            status = new Status(4, "org.eclipse.andmore.android", "Could not remove MultiDex settings", (Throwable)e);
        }
        AndmoreLogger.collectUsageData((String)"obfuscation", (String)"desobfuscate_project", (String)"operation_executed", (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
        return status;
    }

    private static void write(File propertiesFile, String newContent) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(propertiesFile));
        try {
            out.write(newContent);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
        }
    }

    private static String read(File propertiesFile, boolean ignoreMultiDexStatement) throws IOException {
        StringBuilder text = new StringBuilder();
        Scanner scanner = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(propertiesFile);
            scanner = new Scanner(stream);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (ignoreMultiDexStatement && (line.contains(MULTIDEX_MAIN_DEX_LIST_PROPERTY) || line.contains(MULTIDEX_ENABLED_PROPERTY))) continue;
                text.append(String.valueOf(line) + NL);
            }
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.info((String)("Could not close stream while reading project.properties file. " + e.getMessage()));
            }
        }
        return text.toString();
    }

    private static boolean fileExists(File multiDexFile) {
        return multiDexFile != null && multiDexFile.exists();
    }

    private static void addMultiDexEnabledStatement(File propertiesFile) throws IOException {
        String currentContent = null;
        currentContent = MultiDexManager.read(propertiesFile, false);
        if (!currentContent.toString().contains(MULTIDEX_ENABLED_STATEMENT)) {
            String newContent = currentContent.endsWith(NL) ? String.valueOf(currentContent) + MULTIDEX_ENABLED_STATEMENT : String.valueOf(currentContent) + NL + MULTIDEX_ENABLED_STATEMENT;
            MultiDexManager.write(propertiesFile, newContent);
        }
    }

    private static void addMainDexListStatement(File propertiesFile) throws IOException {
        String currentContent = null;
        currentContent = MultiDexManager.read(propertiesFile, false);
        if (!currentContent.toString().contains(MULTIDEX_MAIN_DEX_LIST_STATEMENT)) {
            String newContent = currentContent.endsWith(NL) ? String.valueOf(currentContent) + MULTIDEX_MAIN_DEX_LIST_STATEMENT : String.valueOf(currentContent) + NL + MULTIDEX_MAIN_DEX_LIST_STATEMENT;
            MultiDexManager.write(propertiesFile, newContent);
        }
    }

    private static void removeMultiStatements(File propertiesFile) throws IOException {
        String contentWithoutMultiDexStatement = null;
        contentWithoutMultiDexStatement = MultiDexManager.read(propertiesFile, true);
        MultiDexManager.write(propertiesFile, contentWithoutMultiDexStatement);
    }

    private static void copyMainDexListFile(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        URL mainDexListURL = MultiDexManager.getMultiDexKeepFileURL();
        if (mainDexListURL != null) {
            InputStream is = null;
            try {
                is = mainDexListURL.openStream();
                IFile destFile = project.getFile(MULTIDEX_MAIN_DEX_LIST_FILENAME);
                destFile.create(is, 0, (IProgressMonitor)subMonitor);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private static URL getMultiDexKeepFileURL() {
        Bundle bundle = AndroidPlugin.getDefault().getBundle();
        URL fileURL = bundle.getEntry(MULTIDEX_MAIN_DEX_LIST_PATH);
        return fileURL;
    }

    public static boolean isMultiDexEnabled(IProject project) {
        ProjectProperties projectProperties = MultiDexManager.getProjectProperties(project);
        if (projectProperties == null) {
            return false;
        }
        String multiDexEnabled = projectProperties.getProperty(MULTIDEX_ENABLED_PROPERTY);
        if (multiDexEnabled == null) {
            return false;
        }
        return Boolean.parseBoolean(multiDexEnabled);
    }

    public static File getMainDexListFile(IProject project) {
        ProjectProperties projectProperties = MultiDexManager.getProjectProperties(project);
        if (projectProperties == null) {
            return null;
        }
        String mainDexListLocation = projectProperties.getProperty(MULTIDEX_MAIN_DEX_LIST_PROPERTY);
        if (mainDexListLocation == null) {
            return null;
        }
        return project.getFile(mainDexListLocation).getLocation().toFile();
    }

    private static ProjectProperties getProjectProperties(IProject project) {
        String projectLocation = project.getLocation().toOSString();
        ProjectProperties properties = ProjectProperties.load((String)projectLocation, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.LEGACY_DEFAULT);
        if (properties == null) {
            properties = ProjectProperties.load((String)projectLocation, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
        }
        return properties;
    }
}

