/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements;

import java.io.File;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.wizards.project.NewAndroidProjectMainPage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LocationGroup
extends Composite {
    private final AndroidProject project;
    private final NewAndroidProjectMainPage page;
    private String lastSourcePathValue = null;

    public LocationGroup(Composite parent, AndroidProject project, NewAndroidProjectMainPage page) {
        super(parent, 16);
        this.project = project;
        this.page = page;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(768));
        this.createControl(this);
    }

    private void createControl(Composite parent) {
        final Button createNewProjectRadio = new Button((Composite)this, 16);
        createNewProjectRadio.setText(AndroidNLS.UI_LocationGroup_NewProjectRadioLabel);
        createNewProjectRadio.setSelection(true);
        final Button createSampleRadio = new Button((Composite)this, 16);
        createSampleRadio.setText(AndroidNLS.UI_LocationGroup_NewFromSampleRadioLabel);
        createSampleRadio.setSelection(false);
        final Button existing_project_radio = new Button((Composite)this, 16);
        existing_project_radio.setText(AndroidNLS.UI_LocationGroup_NewFromExistentProjectRadioLabel);
        existing_project_radio.setSelection(false);
        final Button useDefaultLocation = new Button((Composite)this, 32);
        useDefaultLocation.setText(AndroidNLS.UI_LocationGroup_UseDefaultLocationCheckLabel);
        useDefaultLocation.setSelection(true);
        Composite location_group = new Composite((Composite)this, 0);
        location_group.setLayout((Layout)new GridLayout(4, false));
        location_group.setLayoutData((Object)new GridData(1808));
        location_group.setFont(parent.getFont());
        Label locationLabel = new Label(location_group, 0);
        locationLabel.setText(AndroidNLS.UI_LocationGroup_LocationLabel);
        final Text projectPath = new Text(location_group, 2048);
        GridData data = new GridData(4, 1, true, false, 2, 1);
        projectPath.setLayoutData((Object)data);
        projectPath.setFont(parent.getFont());
        projectPath.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        projectPath.setEnabled(false);
        projectPath.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (projectPath.isEnabled()) {
                    LocationGroup.this.project.setLocation(projectPath.getText());
                    LocationGroup.this.notifyListeners(1546, new Event());
                }
            }
        });
        final Button browseButton = new Button(location_group, 8);
        browseButton.setText(AndroidNLS.UI_General_BrowseButtonLabel);
        browseButton.setEnabled(false);
        this.page.setButtonLayoutData(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String existing_dir = LocationGroup.this.project.getLocation();
                if (!(existing_dir == null || existing_dir.length() != 0 && new File(existing_dir).exists())) {
                    existing_dir = null;
                }
                DirectoryDialog dd = new DirectoryDialog(projectPath.getShell());
                dd.setMessage(AndroidNLS.UI_LocationGroup_BrowseDialogMessage);
                dd.setFilterPath(existing_dir);
                String customLocation = dd.open();
                if (customLocation != null) {
                    projectPath.setText(customLocation);
                    if (existing_project_radio.getSelection() && customLocation.length() > 0) {
                        LocationGroup.this.setLastSourcePath(customLocation);
                    }
                }
            }
        });
        SelectionAdapter location_listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean fromSample;
                boolean existentProject;
                boolean isNewProject = createNewProjectRadio.getSelection();
                if (isNewProject ^ (existentProject = existing_project_radio.getSelection()) ^ (fromSample = createSampleRadio.getSelection())) {
                    String path;
                    boolean useDefault = useDefaultLocation.getSelection();
                    useDefaultLocation.setEnabled(!existentProject);
                    if (existentProject) {
                        path = LocationGroup.this.getLastSourcePath();
                        useDefaultLocation.setSelection(false);
                        useDefault = false;
                    } else {
                        path = useDefault ? LocationGroup.this.project.getDefaultLocation() : LocationGroup.this.project.getLocation();
                    }
                    boolean enablePath = !isNewProject && !fromSample || !useDefault;
                    projectPath.setEnabled(enablePath);
                    browseButton.setEnabled(enablePath);
                    LocationGroup.this.project.setSourceType(isNewProject ? AndroidProject.SourceTypes.NEW : (existentProject ? AndroidProject.SourceTypes.EXISTING : AndroidProject.SourceTypes.SAMPLE));
                    LocationGroup.this.project.setUseDefaultLocation(useDefault);
                    if (enablePath && (path == null || path.length() == 0)) {
                        projectPath.setText("");
                        projectPath.setFocus();
                    } else {
                        projectPath.setText(path);
                    }
                    LocationGroup.this.notifyListeners(1546, new Event());
                } else {
                    AndmoreLogger.error(LocationGroup.class, (String)"Ilegal State with New Project radio buttons.");
                }
            }
        };
        createNewProjectRadio.addSelectionListener((SelectionListener)location_listener);
        existing_project_radio.addSelectionListener((SelectionListener)location_listener);
        useDefaultLocation.addSelectionListener((SelectionListener)location_listener);
    }

    public String getLastSourcePath() {
        return this.lastSourcePathValue;
    }

    public void setLastSourcePath(String path) {
        this.lastSourcePathValue = path;
    }
}

