/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements;

import java.io.File;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.wizards.widget.NewAndroidWidgetProjectMainPage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class WidgetLocationGroup
extends Composite {
    private final AndroidProject project;
    private final NewAndroidWidgetProjectMainPage page;
    private String lastSourcePathValue = null;

    public WidgetLocationGroup(Composite parent, AndroidProject project, NewAndroidWidgetProjectMainPage page) {
        super(parent, 16);
        this.project = project;
        this.page = page;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(768));
        this.createControl(this);
    }

    private void createControl(Composite parent) {
        final Button useDefaultLocation = new Button((Composite)this, 32);
        useDefaultLocation.setText(AndroidNLS.UI_LocationGroup_UseDefaultLocationCheckLabel);
        useDefaultLocation.setSelection(true);
        Composite location_group = new Composite((Composite)this, 0);
        location_group.setLayout((Layout)new GridLayout(4, false));
        location_group.setLayoutData((Object)new GridData(1808));
        location_group.setFont(parent.getFont());
        Label locationLabel = new Label(location_group, 0);
        locationLabel.setText(AndroidNLS.UI_LocationGroup_LocationLabel);
        final Text projectPath = new Text(location_group, 2048);
        GridData data = new GridData(4, 1, true, false, 2, 1);
        projectPath.setLayoutData((Object)data);
        projectPath.setFont(parent.getFont());
        projectPath.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        projectPath.setEnabled(false);
        projectPath.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (projectPath.isEnabled()) {
                    WidgetLocationGroup.this.project.setLocation(projectPath.getText());
                    WidgetLocationGroup.this.notifyListeners(1546, new Event());
                }
            }
        });
        final Button browseButton = new Button(location_group, 8);
        browseButton.setText(AndroidNLS.UI_General_BrowseButtonLabel);
        browseButton.setEnabled(false);
        this.page.setButtonLayoutData(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String existing_dir = WidgetLocationGroup.this.project.getLocation();
                if (!(existing_dir == null || existing_dir.length() != 0 && new File(existing_dir).exists())) {
                    existing_dir = null;
                }
                DirectoryDialog dd = new DirectoryDialog(projectPath.getShell());
                dd.setMessage(AndroidNLS.UI_LocationGroup_BrowseDialogMessage);
                dd.setFilterPath(existing_dir);
                String customLocation = dd.open();
                if (customLocation != null) {
                    projectPath.setText(customLocation);
                }
            }
        });
        SelectionAdapter location_listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefault = useDefaultLocation.getSelection();
                String path = useDefault ? WidgetLocationGroup.this.project.getDefaultLocation() : WidgetLocationGroup.this.project.getLocation();
                boolean enablePath = !useDefault;
                projectPath.setEnabled(enablePath);
                browseButton.setEnabled(enablePath);
                WidgetLocationGroup.this.project.setUseDefaultLocation(useDefault);
                if (enablePath && (path == null || path.length() == 0)) {
                    projectPath.setText("");
                    projectPath.setFocus();
                } else {
                    projectPath.setText(path);
                }
                WidgetLocationGroup.this.notifyListeners(1546, new Event());
            }
        };
        useDefaultLocation.addSelectionListener((SelectionListener)location_listener);
    }

    public String getLastSourcePath() {
        return this.lastSourcePathValue;
    }

    public void setLastSourcePath(String path) {
        this.lastSourcePathValue = path;
    }
}

