/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements.sorting;

import java.text.Collator;
import java.util.Comparator;
import org.eclipse.swt.widgets.TableItem;

public class TableItemStringComparator
implements Comparator<TableItem> {
    int columnIndex = 0;
    SortDirection sortDirection = SortDirection.ASCENDING;

    public TableItemStringComparator(int columnIndex, SortDirection sortDirection) {
        this.columnIndex = columnIndex;
        this.sortDirection = sortDirection;
    }

    @Override
    public int compare(TableItem first, TableItem second) {
        TableItem firstItem = first;
        TableItem secondItem = second;
        String firstString = firstItem.getText(this.columnIndex);
        String secondString = secondItem.getText(this.columnIndex);
        return Collator.getInstance().compare(firstString, secondString) * this.sortDirection.getSortDirectionIntValue();
    }

    public static enum SortDirection {
        ASCENDING(1),
        DESCENDING(-1);

        int sortDirection = 1;

        private SortDirection(int sortDirection) {
            this.sortDirection = sortDirection;
        }

        public int getSortDirectionIntValue() {
            return this.sortDirection;
        }
    }
}

