/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.mat;

import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.wizards.elements.sorting.TableItemSortStringSetActionListener;
import org.eclipse.andmore.android.wizards.mat.DumpHPROFTable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class DumpHPROFWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "Dump HPROF page";
    private DumpHPROFTable appsTable;
    private final String serialNumber;
    private static final String helpContextId = "org.eclipse.andmore.android.dump_hprof";

    public DumpHPROFWizardPage(String serialNumber) {
        super(PAGE_NAME);
        this.serialNumber = serialNumber;
        this.setTitle(AndroidNLS.DumpHprofPage_PageTitle);
        this.setDescription(AndroidNLS.DumpHprofPage_PageDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite mainComposite = new Composite(parent, 4);
        mainComposite.setLayout((Layout)new GridLayout());
        this.appsTable = new DumpHPROFTable(mainComposite, 67588, AndroidNLS.DumpHPROFWizardPage__Message_LoadingRunningApplications, this);
        this.appsTable.setTableHeaderVisible(true);
        GridData layoutData = new GridData(4, 4, true, true);
        this.appsTable.setLayoutData(layoutData);
        TableColumn appNameColumn = this.appsTable.addTableColumn(0x1000000);
        appNameColumn.setText(AndroidNLS.DumpHprofPage_ColumnAppName);
        appNameColumn.setWidth(this.convertWidthInCharsToPixels(70));
        appNameColumn.addSelectionListener((SelectionListener)new TableItemSortStringSetActionListener());
        this.appsTable.setTableLinesVisible(false);
        this.appsTable.addTableSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DumpHPROFWizardPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.appsTable.populateTableAsynchronously(this.serialNumber);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, helpContextId);
        this.validatePage();
        this.setControl((Control)mainComposite);
    }

    private void validatePage() {
        this.setPageComplete(this.appsTable.getTable().getSelection().length > 0);
    }

    public String getSelectedApp() {
        String selectedApp = null;
        if (this.appsTable.getTableSelectionCont() == 1) {
            selectedApp = this.appsTable.getTableSelection()[0].getText(0);
        }
        return selectedApp;
    }
}

