/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.monkey;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.monkey.options.MonkeyOptionsMgt;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.andmore.android.wizards.monkey.AbstractPropertiesComposite;
import org.eclipse.andmore.android.wizards.monkey.MonkeyOptionsComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MonkeyConfigurationOtherCmdsTab
extends AbstractLaunchConfigurationTab {
    private MonkeyOptionsComposite monkeyOptionsComposite;
    private final AbstractPropertiesComposite.PropertyCompositeChangeListener compositeChangeListener = new AbstractPropertiesComposite.PropertyCompositeChangeListener(){

        @Override
        public void compositeChanged(AbstractPropertiesComposite.PropertyCompositeChangeEvent e) {
            String errorMessage = MonkeyConfigurationOtherCmdsTab.this.monkeyOptionsComposite.getErrorMessage();
            if (errorMessage != null) {
                MonkeyConfigurationOtherCmdsTab.this.setErrorMessage(errorMessage);
                MonkeyConfigurationOtherCmdsTab.this.updateLaunchConfigurationDialog();
            } else {
                MonkeyConfigurationOtherCmdsTab.this.setErrorMessage(null);
                MonkeyConfigurationOtherCmdsTab.this.updateLaunchConfigurationDialog();
            }
        }
    };

    public void createControl(Composite parent) {
        this.setErrorMessage(null);
        this.setMessage(AndroidNLS.UI_MonkeyWizardOptionsPage_PageMessage);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginTop = 5;
        mainLayout.marginWidth = 5;
        mainLayout.marginHeight = 5;
        this.monkeyOptionsComposite = new MonkeyOptionsComposite(parent, NativeUIUtils.getDefaultCommandLine());
        AbstractPropertiesComposite.addCompositeChangeListener(this.compositeChangeListener);
        this.monkeyOptionsComposite.setLayout((Layout)mainLayout);
        this.setControl((Control)this.monkeyOptionsComposite);
    }

    public String getName() {
        return AndroidNLS.UI_MonkeyComposite_TabOtherCmdName;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String otherCmds = "";
        try {
            otherCmds = configuration.getAttribute("org.eclipse.andmore.android.monkey.otherCmds", "-v");
            this.monkeyOptionsComposite.reloadValues(otherCmds);
        }
        catch (CoreException e) {
            AndmoreLogger.error(MonkeyConfigurationOtherCmdsTab.class, (String)("Failed to initialize Monkey Launch Configuration Other Cmds:" + e.getMessage()));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.andmore.android.monkey.otherCmds", MonkeyOptionsMgt.getParamList());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_COMMON_TAB");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean isValid;
        String errorMessage = this.monkeyOptionsComposite.getErrorMessage();
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
            isValid = false;
        } else {
            this.setErrorMessage(null);
            isValid = true;
        }
        return isValid;
    }

    public void dispose() {
        AbstractPropertiesComposite.removeCompositeChangeListener(this.compositeChangeListener);
        super.dispose();
    }
}

