/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.project;

import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.obfuscate.ObfuscatorManager;
import org.eclipse.andmore.android.wizards.project.NewAndroidProjectMainPage;
import org.eclipse.andmore.android.wizards.project.SampleSelectionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

public class NewAndroidProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    private static final String WIZARD_BANNER = "icons/wizban/newprjwiz.png";
    protected static final String NATIVE_PAGE_NAME = "native_page";
    protected static final String SAMPLE_PAGE_NAME = AndroidNLS.UI_SampleSelectionPage_TitleSourcePage;
    private final AndroidProject project = new AndroidProject();
    private WizardPage nativePage = null;
    private NewAndroidProjectMainPage mainPage = null;
    private Class<?> nativePageClass = null;
    private Object classInstance = null;

    public boolean canFinish() {
        boolean canFinish;
        boolean bl = canFinish = this.project.getStatus().getSeverity() != 4 && !this.project.needMoreInformation();
        if (this.nativePage != null && !this.nativePage.isPageComplete() && this.project.isAddingNativeSupport()) {
            canFinish = false;
        }
        return canFinish;
    }

    public boolean performFinish() {
        DoSave doSave = new DoSave();
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)doSave);
        }
        catch (Exception e) {
            String errMsg = NLS.bind((String)AndroidNLS.EXC_NewAndroidProjectWizard_AnErrorHasOccurredWhenCreatingTheProject, (Object)e.getLocalizedMessage());
            AndmoreLogger.error(NewAndroidProjectWizard.class, (String)errMsg, (Throwable)e);
            EclipseUtils.showErrorDialog((String)AndroidNLS.UI_GenericErrorDialogTitle, (String)errMsg, null);
        }
        boolean success = doSave.isSaved();
        if (success) {
            try {
                AndmoreLogger.collectUsageData((String)"created", (String)"application_management", (String)this.project.getSourceType().name().toLowerCase(), (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
            }
            catch (Throwable throwable) {}
        }
        return success;
    }

    public boolean performCancel() {
        try {
            this.project.finalize();
        }
        catch (Throwable e) {
            AndmoreLogger.error(NewAndroidProjectWizard.class, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return super.performCancel();
    }

    public void addPages() {
        this.classInstance = null;
        try {
            Bundle seqBundle = Platform.getBundle((String)"org.eclipse.sequoyah.android.cdt.build.ui");
            if (seqBundle != null) {
                this.nativePageClass = seqBundle.loadClass("org.eclipse.sequoyah.android.cdt.internal.build.ui.AddNativeProjectPage");
                Class<Boolean> bClass = Boolean.TYPE;
                Class[] paramTypes = new Class[]{bClass};
                Constructor<?> cs = this.nativePageClass.getConstructor(paramTypes);
                this.classInstance = cs.newInstance(true);
                this.nativePage = (WizardPage)this.classInstance;
            }
        }
        catch (Exception e) {
            AndmoreLogger.error(NewAndroidProjectWizard.class, (String)e.getMessage(), (Throwable)e);
        }
        if (this.nativePage != null) {
            this.mainPage = new NewAndroidProjectMainPage(this.project, true);
            this.addPage((IWizardPage)this.mainPage);
            this.addPage((IWizardPage)this.nativePage);
        } else {
            this.mainPage = new NewAndroidProjectMainPage(this.project, false);
            this.addPage((IWizardPage)this.mainPage);
        }
        this.addPage((IWizardPage)new SampleSelectionPage(this.project));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(AndroidNLS.UI_NewAndroidProjectWizard_TitleNewProjectWizard);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(AndroidPlugin.getImageDescriptor(WIZARD_BANNER));
    }

    private class DoSave
    implements IRunnableWithProgress {
        private static final String OPHONE_JAR = "oms.jar";
        private static final String OPHONESDK_PROMPT_KEY = "OphoneSDK";
        private boolean saved = false;

        private DoSave() {
        }

        public boolean isSaved() {
            return this.saved;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
            subMonitor.beginTask(AndroidNLS.NewAndroidProjectWizard_Message_CreatingAndroidProject, 10);
            boolean autoBuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
            IWorkspaceDescription wsd = ResourcesPlugin.getWorkspace().getDescription();
            wsd.setAutoBuilding(false);
            try {
                ResourcesPlugin.getWorkspace().setDescription(wsd);
            }
            catch (CoreException e) {
                AndmoreLogger.error(NewAndroidProjectWizard.class, (String)("Error cleaning workspace after project creation: " + e.getMessage()));
            }
            subMonitor.worked(1);
            this.saved = NewAndroidProjectWizard.this.project.save(NewAndroidProjectWizard.this.getContainer(), (IProgressMonitor)subMonitor);
            NewAndroidProjectWizard.this.updatePerspective();
            IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(NewAndroidProjectWizard.this.project.getName());
            this.addOphoneSDK(newProject, (IProgressMonitor)subMonitor);
            try {
                newProject.build(15, (IProgressMonitor)subMonitor);
            }
            catch (Exception e1) {
                AndmoreLogger.error(NewAndroidProjectWizard.class, (String)("Sleep error when cleaning workspace after project creation: " + e1.getMessage()));
            }
            subMonitor.worked(3);
            wsd.setAutoBuilding(autoBuild);
            try {
                ResourcesPlugin.getWorkspace().setDescription(wsd);
            }
            catch (CoreException e) {
                AndmoreLogger.error(NewAndroidProjectWizard.class, (String)("Error cleaning workspace after project creation: " + e.getMessage()));
            }
            subMonitor.worked(1);
            if (NewAndroidProjectWizard.this.nativePage != null && NewAndroidProjectWizard.this.project.isAddingNativeSupport() && this.saved) {
                try {
                    Class<IWorkbenchWindow> workbenchClass = IWorkbenchWindow.class;
                    Class<IProject> projectClass = IProject.class;
                    Class<IProgressMonitor> progressMonitorClass = IProgressMonitor.class;
                    IProject createdProject = ResourcesPlugin.getWorkspace().getRoot().getProject(NewAndroidProjectWizard.this.project.getName());
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    QualifiedName libQN = new QualifiedName("org.eclipse.andmore.android", "liblocation");
                    Method getLibraryName = NewAndroidProjectWizard.this.nativePageClass.getMethod("getLibraryName", null);
                    getLibraryName.setAccessible(true);
                    Object returnValue = getLibraryName.invoke(NewAndroidProjectWizard.this.classInstance, null);
                    createdProject.setPersistentProperty(libQN, returnValue.toString());
                    subMonitor.worked(1);
                    Object[] performFinishMethodArguments = new Object[]{window, createdProject, subMonitor.newChild(4)};
                    Class[] performFinishMethodParameterTypes = new Class[]{workbenchClass, projectClass, progressMonitorClass};
                    Method performFinish = NewAndroidProjectWizard.this.nativePageClass.getMethod("performFinish", performFinishMethodParameterTypes);
                    performFinish.setAccessible(true);
                    returnValue = performFinish.invoke(NewAndroidProjectWizard.this.classInstance, performFinishMethodArguments);
                    this.saved = this.saved && (Boolean)returnValue != false;
                }
                catch (Exception e) {
                    this.saved = false;
                    AndmoreLogger.error(NewAndroidProjectWizard.class, (String)e.getMessage(), (Throwable)e);
                    throw new InvocationTargetException(e);
                }
            }
            try {
                if (NewAndroidProjectWizard.this.project.needToObfuscate()) {
                    ObfuscatorManager.obfuscate(newProject, (IProgressMonitor)subMonitor.newChild(10));
                }
                newProject.refreshLocal(2, (IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                AndmoreLogger.error(NewAndroidProjectWizard.class, (String)e.getMessage(), (Throwable)e);
                throw new InvocationTargetException(e);
            }
        }

        private void addOphoneSDK(IProject p, IProgressMonitor monitor) {
            IJavaProject javaProject;
            boolean addClasspath;
            IAndroidTarget sdkTarget = NewAndroidProjectWizard.this.project.getSdkTarget();
            File platformLocation = new File(sdkTarget.getLocation());
            File[] listFiles = platformLocation.listFiles();
            boolean found = false;
            int i = 0;
            File file = null;
            while (!found && i < listFiles.length) {
                file = listFiles[i];
                if (file.getName().equals(OPHONE_JAR)) {
                    found = true;
                }
                ++i;
            }
            if (found && (addClasspath = DialogWithToggleUtils.showQuestion((String)OPHONESDK_PROMPT_KEY, (String)AndroidNLS.NewAndroidProjectWizard_OPhonePromptTitle, (String)AndroidNLS.NewAndroidProjectWizard_OPhonePromptMessage)) && (javaProject = JavaCore.create((IProject)p)) != null && javaProject.exists()) {
                try {
                    javaProject.open(monitor);
                    IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
                    IClasspathEntry[] newClasspath = new IClasspathEntry[rawClasspath.length + 1];
                    System.arraycopy(rawClasspath, 0, newClasspath, 0, rawClasspath.length);
                    newClasspath[newClasspath.length - 1] = JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), null, null);
                    javaProject.setRawClasspath(newClasspath, monitor);
                }
                catch (JavaModelException e) {
                    AndmoreLogger.error(NewAndroidProjectWizard.class, (String)("Error while setting up the oms.jar on the project classpath: " + e.getMessage()));
                }
            }
        }
    }
}

