/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.andmore.gltrace.GLEnum;
import org.eclipse.andmore.gltrace.GLProtoBuf;
import org.eclipse.andmore.gltrace.GlTracePlugin;
import org.eclipse.andmore.gltrace.TraceFileInfo;
import org.eclipse.andmore.gltrace.TraceFileReader;
import org.eclipse.andmore.gltrace.format.GLAPISpec;
import org.eclipse.andmore.gltrace.format.GLMessageFormatter;
import org.eclipse.andmore.gltrace.model.GLCall;
import org.eclipse.andmore.gltrace.model.GLFrame;
import org.eclipse.andmore.gltrace.model.GLTrace;
import org.eclipse.andmore.gltrace.state.transforms.StateTransformFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class TraceFileParserTask
implements IRunnableWithProgress {
    private static final TraceFileReader sReader = new TraceFileReader();
    private static final GLMessageFormatter sGLMessageFormatter = new GLMessageFormatter(GLAPISpec.getSpecs());
    private String mTraceFilePath;
    private RandomAccessFile mFile;
    private List<GLCall> mGLCalls;
    private Set<Integer> mGLContextIds;
    private GLTrace mTrace;

    public TraceFileParserTask(String path) {
        try {
            this.mFile = new RandomAccessFile(path, "r");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        this.mTraceFilePath = path;
        this.mGLCalls = new ArrayList<GLCall>();
        this.mGLContextIds = new TreeSet<Integer>();
    }

    private void addMessage(int index, long traceFileOffset, GLProtoBuf.GLMessage msg, long startTime) {
        String formattedMsg;
        try {
            formattedMsg = sGLMessageFormatter.formatGLMessage(msg);
        }
        catch (Exception exception) {
            formattedMsg = String.format("%s()", msg.getFunction().toString());
        }
        GLCall c = new GLCall(index, startTime, traceFileOffset, formattedMsg, msg.getFunction(), msg.hasFb(), msg.getContextId(), msg.getDuration(), msg.getThreadtime());
        this.addProperties(c, msg);
        try {
            c.setStateTransformations(StateTransformFactory.getTransformsFor(msg));
        }
        catch (Exception e) {
            c.setStateTransformationCreationError(e.getMessage());
            GlTracePlugin.getDefault().logMessage("Error while creating transformations for " + c.toString() + ":");
            GlTracePlugin.getDefault().logMessage(e.getMessage());
        }
        this.mGLCalls.add(c);
        this.mGLContextIds.add(c.getContextId());
    }

    private void addProperties(GLCall c, GLProtoBuf.GLMessage msg) {
        switch (msg.getFunction()) {
            case glPushGroupMarkerEXT: {
                c.addProperty(0, msg.getArgs(1).getCharValue(0).toStringUtf8());
                break;
            }
            case glVertexAttribPointerData: {
                c.addProperty(1, msg.getArgs(1).getIntValue(0));
                c.addProperty(2, (Object)GLEnum.valueOf(msg.getArgs(2).getIntValue(0)));
                c.addProperty(3, msg.getArgs(5).getRawBytes(0).toByteArray());
                break;
            }
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long fileLength;
        try {
            fileLength = this.mFile.length();
        }
        catch (IOException iOException) {
            fileLength = 0L;
        }
        monitor.beginTask("Parsing OpenGL Trace File", fileLength > 0L ? 100 : -1);
        List<GLFrame> glFrames = null;
        try {
            try {
                GLProtoBuf.GLMessage msg = null;
                int msgCount = 0;
                long filePointer = this.mFile.getFilePointer();
                int percentParsed = 0;
                long minTraceStartTime = Long.MAX_VALUE;
                while ((msg = sReader.getMessageAtOffset(this.mFile, -1L)) != null) {
                    if (minTraceStartTime > msg.getStartTime()) {
                        minTraceStartTime = msg.getStartTime();
                    }
                    this.addMessage(msgCount, filePointer, msg, msg.getStartTime() - minTraceStartTime);
                    filePointer = this.mFile.getFilePointer();
                    ++msgCount;
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    if (fileLength <= 0L) continue;
                    int percentParsedNow = (int)(filePointer * 100L / fileLength);
                    monitor.worked(percentParsedNow - percentParsed);
                    percentParsed = percentParsedNow;
                }
                if (this.mGLContextIds.size() > 1) {
                    Collections.sort(this.mGLCalls, new Comparator<GLCall>(){

                        @Override
                        public int compare(GLCall c1, GLCall c2) {
                            long diff = c1.getStartTime() - c2.getStartTime();
                            if (diff == 0L) {
                                return 0;
                            }
                            if (diff > 0L) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    int i = 0;
                    while (i < this.mGLCalls.size()) {
                        this.mGLCalls.get(i).setIndex(i);
                        ++i;
                    }
                }
                glFrames = this.createFrames(this.mGLCalls);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.mFile.close();
            }
            catch (IOException iOException) {}
            monitor.done();
            throw throwable;
        }
        try {
            this.mFile.close();
        }
        catch (IOException iOException) {}
        monitor.done();
        File f = new File(this.mTraceFilePath);
        TraceFileInfo fileInfo = new TraceFileInfo(this.mTraceFilePath, f.length(), f.lastModified());
        this.mTrace = new GLTrace(fileInfo, glFrames, this.mGLCalls, new ArrayList<Integer>(this.mGLContextIds));
    }

    private List<GLFrame> createFrames(List<GLCall> calls) {
        ArrayList<GLFrame> glFrames = new ArrayList<GLFrame>();
        int startCallIndex = 0;
        int frameIndex = 0;
        int i = 0;
        while (i < calls.size()) {
            GLCall c = calls.get(i);
            if (c.getFunction() == GLProtoBuf.GLMessage.Function.eglSwapBuffers) {
                glFrames.add(new GLFrame(frameIndex, startCallIndex, i + 1));
                startCallIndex = i + 1;
                ++frameIndex;
            }
            ++i;
        }
        if (startCallIndex != this.mGLCalls.size()) {
            glFrames.add(new GLFrame(frameIndex, startCallIndex, this.mGLCalls.size()));
        }
        return glFrames;
    }

    public GLTrace getTrace() {
        return this.mTrace;
    }
}

