/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.editors;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.gltrace.GlTracePlugin;
import org.eclipse.andmore.gltrace.editors.GLCallGroups;
import org.eclipse.andmore.gltrace.editors.GLFunctionTraceViewer;
import org.eclipse.andmore.gltrace.editors.StateContentProvider;
import org.eclipse.andmore.gltrace.editors.StateLabelProvider;
import org.eclipse.andmore.gltrace.model.GLCall;
import org.eclipse.andmore.gltrace.model.GLTrace;
import org.eclipse.andmore.gltrace.state.GLState;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.state.StatePrettyPrinter;
import org.eclipse.andmore.gltrace.state.transforms.IStateTransform;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class StateViewPage
extends Page
implements ISelectionListener,
ISelectionProvider {
    public static final String ID = "org.eclipse.andmore.gltrace.views.GLState";
    private static String sLastUsedPath;
    private static final ILock sGlStateLock;
    private GLTrace mTrace;
    private List<GLCall> mGLCalls;
    private IGLProperty mState;
    private int mCurrentStateIndex;
    private String[] TREE_PROPERTIES = new String[]{"Name", "Value"};
    private TreeViewer mTreeViewer;
    private StateLabelProvider mLabelProvider;

    static {
        sGlStateLock = Job.getJobManager().newLock();
    }

    public StateViewPage(GLTrace trace) {
        this.setInput(trace);
    }

    public void setInput(GLTrace trace) {
        this.mTrace = trace;
        this.mGLCalls = trace != null ? trace.getGLCalls() : null;
        this.mState = GLState.createDefaultState();
        this.mCurrentStateIndex = -1;
        if (this.mTreeViewer != null) {
            this.mTreeViewer.setInput((Object)this.mState);
            this.mTreeViewer.refresh();
        }
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 0x10000300);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        TreeColumn col1 = new TreeColumn(tree, 16384);
        col1.setText(this.TREE_PROPERTIES[0]);
        col1.setWidth(200);
        TreeColumn col2 = new TreeColumn(tree, 16384);
        col2.setText(this.TREE_PROPERTIES[1]);
        col2.setWidth(200);
        this.mTreeViewer = new TreeViewer(tree);
        this.mTreeViewer.setContentProvider((IContentProvider)new StateContentProvider());
        this.mLabelProvider = new StateLabelProvider();
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)this.mLabelProvider);
        this.mTreeViewer.setInput((Object)this.mState);
        this.mTreeViewer.refresh();
        IToolBarManager manager = this.getSite().getActionBars().getToolBarManager();
        manager.add((IAction)new Action("Save to File", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT")){

            public void run() {
                StateViewPage.this.saveCurrentState();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentState() {
        String path;
        Shell shell = this.mTreeViewer.getTree().getShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setFilterExtensions(new String[]{"*.txt"});
        if (sLastUsedPath != null) {
            fd.setFilterPath(sLastUsedPath);
        }
        if ((path = fd.open()) == null) {
            return;
        }
        File f = new File(path);
        sLastUsedPath = f.getParent();
        StatePrettyPrinter pp = new StatePrettyPrinter();
        ILock iLock = sGlStateLock;
        synchronized (iLock) {
            this.mState.prettyPrint(pp);
        }
        try {
            Files.write((CharSequence)pp.toString(), (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)shell, (String)"Export GL State", (String)"Unexpected error while writing GL state to file.", (IStatus)new Status(4, "org.eclipse.andmore.gldebugger", e.toString()));
        }
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof GLFunctionTraceViewer)) {
            return;
        }
        if (((GLFunctionTraceViewer)part).getTrace() != this.mTrace) {
            return;
        }
        if (!(selection instanceof TreeSelection)) {
            return;
        }
        GLCall selectedCall = null;
        Object data = ((TreeSelection)selection).getFirstElement();
        if (data instanceof GLCallGroups.GLCallNode) {
            selectedCall = ((GLCallGroups.GLCallNode)data).getCall();
        }
        if (selectedCall == null) {
            return;
        }
        final int selectedCallIndex = selectedCall.getIndex();
        Job job = new Job("Updating GL State"){

            protected IStatus run(IProgressMonitor monitor) {
                Set changedProperties = null;
                try {
                    try {
                        sGlStateLock.acquire();
                        changedProperties = StateViewPage.this.updateState(StateViewPage.this.mCurrentStateIndex, selectedCallIndex);
                        StateViewPage.this.mCurrentStateIndex = selectedCallIndex;
                    }
                    catch (Exception e) {
                        GlTracePlugin.getDefault().logMessage("Unexpected error while updating GL State.");
                        GlTracePlugin.getDefault().logMessage(e.getMessage());
                        Status status = new Status(4, "org.eclipse.andmore.gldebugger", "Unexpected error while updating GL State.", (Throwable)e);
                        sGlStateLock.release();
                        return status;
                    }
                }
                finally {
                    sGlStateLock.release();
                }
                StateViewPage.this.mLabelProvider.setChangedProperties(changedProperties);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!StateViewPage.this.mTreeViewer.getTree().isDisposed()) {
                            StateViewPage.this.mTreeViewer.refresh();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public Control getControl() {
        if (this.mTreeViewer == null) {
            return null;
        }
        return this.mTreeViewer.getControl();
    }

    public void setFocus() {
    }

    private Set<IGLProperty> updateState(int fromIndex, int toIndex) {
        assert (fromIndex >= -1 && fromIndex < this.mGLCalls.size());
        assert (toIndex >= 0 && toIndex < this.mGLCalls.size());
        if (fromIndex < toIndex) {
            return this.applyTransformations(fromIndex, toIndex);
        }
        if (fromIndex > toIndex) {
            return this.revertTransformations(fromIndex, toIndex);
        }
        return Collections.emptySet();
    }

    private Set<IGLProperty> applyTransformations(int fromIndex, int toIndex) {
        int setSizeHint = 3 * (toIndex - fromIndex) + 10;
        HashSet<IGLProperty> changedProperties = new HashSet<IGLProperty>(setSizeHint);
        int i = fromIndex + 1;
        while (i <= toIndex) {
            GLCall call = this.mGLCalls.get(i);
            for (IStateTransform f : call.getStateTransformations()) {
                try {
                    f.apply(this.mState);
                    IGLProperty changedProperty = f.getChangedProperty(this.mState);
                    if (changedProperty == null) continue;
                    changedProperties.addAll(this.getHierarchy(changedProperty));
                }
                catch (Exception e) {
                    GlTracePlugin.getDefault().logMessage("Error applying transformations for " + call);
                    GlTracePlugin.getDefault().logMessage(e.toString());
                }
            }
            ++i;
        }
        return changedProperties;
    }

    private Set<IGLProperty> revertTransformations(int fromIndex, int toIndex) {
        int setSizeHint = 3 * (fromIndex - toIndex) + 10;
        HashSet<IGLProperty> changedProperties = new HashSet<IGLProperty>(setSizeHint);
        int i = fromIndex;
        while (i > toIndex) {
            List<IStateTransform> transforms = this.mGLCalls.get(i).getStateTransformations();
            int j = transforms.size() - 1;
            while (j >= 0) {
                IStateTransform f = transforms.get(j);
                f.revert(this.mState);
                IGLProperty changedProperty = f.getChangedProperty(this.mState);
                if (changedProperty != null) {
                    changedProperties.addAll(this.getHierarchy(changedProperty));
                }
                --j;
            }
            --i;
        }
        return changedProperties;
    }

    private List<IGLProperty> getHierarchy(IGLProperty changedProperty) {
        ArrayList<IGLProperty> changedProperties = new ArrayList<IGLProperty>(5);
        changedProperties.add(changedProperty);
        IGLProperty prop = changedProperty;
        while ((prop = prop.getParent()) != null) {
            changedProperties.add(prop);
        }
        return changedProperties;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mTreeViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.mTreeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mTreeViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.mTreeViewer.setSelection(selection);
    }
}

