/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import org.eclipse.andmore.Messages;
import org.eclipse.core.resources.IProject;

public class AndroidPrintStream
extends PrintStream {
    private IProject mProject;
    private String mPrefix;

    public AndroidPrintStream(IProject project, String prefix, OutputStream stream) {
        super(stream);
        this.mProject = project;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    @Override
    public void println(String message) {
        String tag = AndroidPrintStream.getMessageTag(this.mProject != null ? this.mProject.getName() : null);
        this.print(tag);
        this.print(" ");
        if (this.mPrefix != null) {
            this.print(this.mPrefix);
            this.print(" ");
        }
        super.println(message);
    }

    public static String getMessageTag(String tag) {
        Calendar c = Calendar.getInstance();
        if (tag == null) {
            return String.format(Messages.Console_Date_Tag, c);
        }
        return String.format(Messages.Console_Data_Project_Tag, c, tag);
    }
}

