/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.SegmentType;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.common.layout.BaseLayoutRule;
import org.eclipse.andmore.common.layout.ResizeState;

public class AbsoluteLayoutRule
extends BaseLayoutRule {
    public List<String> getSelectionHint(INode parentNode, INode childNode) {
        ArrayList<String> infos = new ArrayList<String>(2);
        infos.add("AbsoluteLayout is deprecated.");
        infos.add("Use other layouts instead.");
        return infos;
    }

    public DropFeedback onDropEnter(INode targetNode, Object targetView, final IDragElement[] elements) {
        if (elements.length == 0) {
            return null;
        }
        DropFeedback df = new DropFeedback(null, new IFeedbackPainter(){

            public void paint(IGraphics gc, INode node, DropFeedback feedback) {
                AbsoluteLayoutRule.this.drawFeedback(gc, node, elements, feedback);
            }
        });
        df.errorMessage = "AbsoluteLayout is deprecated.";
        return df;
    }

    void drawFeedback(IGraphics gc, INode targetNode, IDragElement[] elements, DropFeedback feedback) {
        Rect b = targetNode.getBounds();
        if (!b.isValid()) {
            return;
        }
        gc.useStyle(DrawingStyle.DROP_RECIPIENT);
        gc.drawRect(b);
        Point p = (Point)feedback.userData;
        if (p == null) {
            return;
        }
        int x = p.x;
        int y = p.y;
        Rect be = elements[0].getBounds();
        if (be.isValid()) {
            int offsetX = x - be.x + (feedback.dragBounds != null ? feedback.dragBounds.x : 0);
            int offsetY = y - be.y + (feedback.dragBounds != null ? feedback.dragBounds.y : 0);
            gc.useStyle(DrawingStyle.DROP_PREVIEW);
            IDragElement[] iDragElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IDragElement element = iDragElementArray[n2];
                this.drawElement(gc, element, offsetX, offsetY);
                ++n2;
            }
        } else {
            gc.useStyle(DrawingStyle.GUIDELINE);
            gc.drawLine(x, b.y, x, b.y + b.h);
            gc.drawLine(b.x, y, b.x + b.w, y);
            gc.useStyle(DrawingStyle.DROP_PREVIEW);
            gc.drawLine(x, y, b.x + b.w, y);
            gc.drawLine(x, y, x, b.y + b.h);
        }
    }

    public DropFeedback onDropMove(INode targetNode, IDragElement[] elements, DropFeedback feedback, Point p) {
        feedback.userData = p;
        feedback.requestPaint = true;
        return feedback;
    }

    public void onDropLeave(INode targetNode, IDragElement[] elements, DropFeedback feedback) {
    }

    public void onDropped(final INode targetNode, final IDragElement[] elements, final DropFeedback feedback, final Point p) {
        final Rect b = targetNode.getBounds();
        if (!b.isValid()) {
            return;
        }
        final Map<String, Pair<String, String>> idMap = AbsoluteLayoutRule.getDropIdMap(targetNode, elements, feedback.isCopy || !feedback.sameCanvas);
        targetNode.editXml("Add elements to AbsoluteLayout", new INodeHandler(){

            public void handle(INode node) {
                boolean first = true;
                Point offset = null;
                IDragElement[] iDragElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    double scale;
                    IDragElement element = iDragElementArray[n2];
                    String fqcn = element.getFqcn();
                    Rect be = element.getBounds();
                    INode newChild = targetNode.appendChild(fqcn);
                    AbsoluteLayoutRule.addAttributes(newChild, element, idMap, DEFAULT_ATTR_FILTER);
                    int deltaX = feedback.dragBounds != null ? feedback.dragBounds.x : 0;
                    int deltaY = feedback.dragBounds != null ? feedback.dragBounds.y : 0;
                    int x = p.x - b.x + deltaX;
                    int y = p.y - b.y + deltaY;
                    if (first) {
                        first = false;
                        if (be.isValid()) {
                            offset = new Point(x - be.x, y - be.y);
                        }
                    } else if (offset != null && be.isValid()) {
                        x = offset.x + be.x;
                        y = offset.y + be.y;
                    } else {
                        x += 10;
                        y += be.isValid() ? be.h : 10;
                    }
                    if ((scale = feedback.dipScale) != 1.0) {
                        x = (int)((double)x * scale);
                        y = (int)((double)y * scale);
                    }
                    newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_x", String.format("%ddp", x));
                    newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_y", String.format("%ddp", y));
                    AbsoluteLayoutRule.addInnerElements(newChild, element, idMap);
                    ++n2;
                }
            }
        });
    }

    @Override
    protected void setNewSizeBounds(ResizeState resizeState, INode node, INode layout, Rect previousBounds, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        super.setNewSizeBounds(resizeState, node, layout, previousBounds, newBounds, horizontalEdge, verticalEdge);
        if (verticalEdge != null && newBounds.x != previousBounds.x) {
            node.setAttribute("http://schemas.android.com/apk/res/android", "layout_x", String.format("%ddp", this.mRulesEngine.pxToDp(newBounds.x - node.getParent().getBounds().x)));
        }
        if (horizontalEdge != null && newBounds.y != previousBounds.y) {
            node.setAttribute("http://schemas.android.com/apk/res/android", "layout_y", String.format("%ddp", this.mRulesEngine.pxToDp(newBounds.y - node.getParent().getBounds().y)));
        }
    }

    @Override
    protected String getResizeUpdateMessage(ResizeState resizeState, INode child, INode parent, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge) {
        Rect parentBounds = parent.getBounds();
        if (horizontalEdge == SegmentType.BOTTOM && verticalEdge == SegmentType.RIGHT) {
            return super.getResizeUpdateMessage(resizeState, child, parent, newBounds, horizontalEdge, verticalEdge);
        }
        return String.format("x=%d, y=%d\nwidth=%s, height=%s", this.mRulesEngine.pxToDp(newBounds.x - parentBounds.x), this.mRulesEngine.pxToDp(newBounds.y - parentBounds.y), resizeState.getWidthAttribute(), resizeState.getHeightAttribute());
    }
}

