/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.relative;

import com.android.ide.common.api.INode;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.common.layout.BaseViewRule;
import org.eclipse.andmore.common.layout.relative.ConstraintType;

public class DeletionHandler {
    private final INode mLayout;
    private final INode[] mChildren;
    private final List<INode> mDeleted;
    private final Set<String> mDeletedIds;
    private final Map<String, INode> mNodeMap;
    private final List<INode> mMoved;

    public DeletionHandler(List<INode> deleted, List<INode> moved, INode layout) {
        this.mDeleted = deleted;
        this.mMoved = moved;
        this.mLayout = layout;
        this.mChildren = this.mLayout.getChildren();
        this.mNodeMap = Maps.newHashMapWithExpectedSize((int)this.mChildren.length);
        INode[] iNodeArray = this.mChildren;
        int n = this.mChildren.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            String id = child.getStringAttr("http://schemas.android.com/apk/res/android", "id");
            if (id != null) {
                this.mNodeMap.put(BaseViewRule.stripIdPrefix(id), child);
            }
            ++n2;
        }
        this.mDeletedIds = Sets.newHashSetWithExpectedSize((int)this.mDeleted.size());
        for (INode node : this.mDeleted) {
            String id = node.getStringAttr("http://schemas.android.com/apk/res/android", "id");
            if (id == null) continue;
            this.mDeletedIds.add(BaseViewRule.stripIdPrefix(id));
        }
        for (INode node : this.mMoved) {
            String id = node.getStringAttr("http://schemas.android.com/apk/res/android", "id");
            if (id == null) continue;
            this.mDeletedIds.remove(BaseViewRule.stripIdPrefix(id));
        }
    }

    private static String getId(INode.IAttribute attribute) {
        if (attribute.getName().startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attribute.getUri()) && !attribute.getName().startsWith("layout_margin")) {
            String id = attribute.getValue();
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    public void updateConstraints() {
        if (this.mChildren.length == this.mDeleted.size()) {
            return;
        }
        INode[] iNodeArray = this.mChildren;
        int n = this.mChildren.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            if (!this.mDeleted.contains(child)) {
                INode.IAttribute[] iAttributeArray = child.getLiveAttributes();
                int n3 = iAttributeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    INode.IAttribute attribute = iAttributeArray[n4];
                    String id = DeletionHandler.getId(attribute);
                    if (id != null && this.mDeletedIds.contains(id)) {
                        ConstraintType type;
                        String name = attribute.getName();
                        child.setAttribute("http://schemas.android.com/apk/res/android", name, null);
                        INode deleted = this.mNodeMap.get(id);
                        if (deleted != null && (type = ConstraintType.fromAttribute(name)) != null) {
                            this.transfer(deleted, child, type, 0);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void transfer(INode deleted, INode target, ConstraintType targetType, int depth) {
        if (depth == 20) {
            return;
        }
        assert (this.mDeleted.contains(deleted));
        INode.IAttribute[] iAttributeArray = deleted.getLiveAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintType transfer;
            INode.IAttribute attribute = iAttributeArray[n2];
            String name = attribute.getName();
            ConstraintType type = ConstraintType.fromAttribute(name);
            if (type != null && (transfer = DeletionHandler.getCompatibleConstraint(type, targetType)) != null) {
                String id = DeletionHandler.getId(attribute);
                if (id != null) {
                    if (this.mDeletedIds.contains(id)) {
                        INode nextDeleted = this.mNodeMap.get(id);
                        if (nextDeleted != null) {
                            this.transfer(nextDeleted, target, targetType, depth + 1);
                        }
                    } else {
                        target.setAttribute("http://schemas.android.com/apk/res/android", transfer.name, attribute.getValue());
                    }
                } else {
                    target.setAttribute("http://schemas.android.com/apk/res/android", name, attribute.getValue());
                }
            }
            ++n2;
        }
    }

    private static ConstraintType getCompatibleConstraint(ConstraintType first, ConstraintType second) {
        if (first == second) {
            return first;
        }
        switch (second) {
            case ALIGN_LEFT: 
            case LAYOUT_RIGHT_OF: {
                switch (first) {
                    case ALIGN_LEFT: 
                    case LAYOUT_LEFT_OF: 
                    case LAYOUT_CENTER_HORIZONTAL: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case ALIGN_RIGHT: 
            case LAYOUT_LEFT_OF: {
                switch (first) {
                    case ALIGN_RIGHT: 
                    case LAYOUT_LEFT_OF: 
                    case LAYOUT_CENTER_HORIZONTAL: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case LAYOUT_BELOW: 
            case ALIGN_TOP: 
            case ALIGN_BASELINE: {
                switch (first) {
                    case LAYOUT_BELOW: 
                    case ALIGN_TOP: 
                    case ALIGN_BASELINE: 
                    case LAYOUT_CENTER_VERTICAL: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
            case LAYOUT_ABOVE: 
            case ALIGN_BOTTOM: {
                switch (first) {
                    case LAYOUT_ABOVE: 
                    case ALIGN_BOTTOM: 
                    case ALIGN_BASELINE: 
                    case LAYOUT_CENTER_VERTICAL: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

