/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.relative;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.MarginType;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.Segment;
import com.android.ide.common.api.SegmentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.common.layout.BaseLayoutRule;
import org.eclipse.andmore.common.layout.relative.ConstraintType;
import org.eclipse.andmore.common.layout.relative.DependencyGraph;
import org.eclipse.andmore.common.layout.relative.Match;

public class GuidelineHandler {
    protected DependencyGraph mDependencyGraph;
    public INode layout;
    protected Collection<INode> mDraggedNodes;
    protected Rect mBounds;
    protected boolean mMoveLeft;
    protected boolean mMoveRight;
    protected boolean mMoveTop;
    protected boolean mMoveBottom;
    protected boolean mSnap = true;
    protected Set<INode> mHorizontalDeps;
    protected Set<INode> mVerticalDeps;
    protected List<DependencyGraph.Constraint> mHorizontalCycle;
    protected List<DependencyGraph.Constraint> mVerticalCycle;
    protected List<Segment> mHorizontalEdges;
    protected List<Segment> mVerticalEdges;
    protected List<Segment> mCenterVertEdges;
    protected List<Segment> mCenterHorizEdges;
    protected List<Match> mHorizontalSuggestions;
    protected List<Match> mVerticalSuggestions;
    protected Match mCurrentLeftMatch;
    protected Match mCurrentTopMatch;
    protected Match mCurrentRightMatch;
    protected Match mCurrentBottomMatch;
    protected int mTopMargin;
    protected int mBottomMargin;
    protected int mLeftMargin;
    protected int mRightMargin;
    protected IClientRulesEngine mRulesEngine;

    GuidelineHandler(INode layout, IClientRulesEngine rulesEngine) {
        this.layout = layout;
        this.mRulesEngine = rulesEngine;
        this.mHorizontalEdges = new ArrayList<Segment>();
        this.mVerticalEdges = new ArrayList<Segment>();
        this.mCenterVertEdges = new ArrayList<Segment>();
        this.mCenterHorizEdges = new ArrayList<Segment>();
        this.mDependencyGraph = new DependencyGraph(layout);
    }

    public boolean haveSuggestions() {
        return this.mCurrentLeftMatch != null || this.mCurrentTopMatch != null || this.mCurrentRightMatch != null || this.mCurrentBottomMatch != null;
    }

    protected Match pickBestMatch(List<Match> matches) {
        int alternatives = matches.size();
        if (alternatives == 0) {
            return null;
        }
        if (alternatives == 1) {
            Match match = matches.get(0);
            return match;
        }
        assert (alternatives > 1);
        Collections.sort(matches, new MatchComparator());
        return matches.get(0);
    }

    private boolean checkCycle(DropFeedback feedback, Match match, boolean vertical) {
        if (match != null && match.cycle) {
            for (INode node : this.mDraggedNodes) {
                INode from = match.edge.node;
                assert (match.with.node == null || match.with.node == node);
                INode to = node;
                List<DependencyGraph.Constraint> path = this.mDependencyGraph.getPathTo(from, to, vertical);
                if (path == null) continue;
                if (vertical) {
                    this.mVerticalCycle = path;
                } else {
                    this.mHorizontalCycle = path;
                }
                String desc = DependencyGraph.Constraint.describePath(path, match.type.name, match.edge.id);
                feedback.errorMessage = "Constraint creates a cycle: " + desc;
                return true;
            }
        }
        return false;
    }

    public void checkCycles(DropFeedback feedback) {
        feedback.errorMessage = null;
        this.mHorizontalCycle = null;
        this.mVerticalCycle = null;
        if (!this.checkCycle(feedback, this.mCurrentTopMatch, true)) {
            this.checkCycle(feedback, this.mCurrentBottomMatch, true);
        }
        if (!this.checkCycle(feedback, this.mCurrentLeftMatch, false)) {
            this.checkCycle(feedback, this.mCurrentRightMatch, false);
        }
    }

    protected void addBounds(INode node, String id, boolean addHorizontal, boolean addVertical) {
        Rect b = node.getBounds();
        Margins margins = node.getMargins();
        if (addHorizontal) {
            if (margins.top != 0) {
                this.mHorizontalEdges.add(new Segment(b.y, b.x, b.x2(), node, id, SegmentType.TOP, MarginType.WITHOUT_MARGIN));
                this.mHorizontalEdges.add(new Segment(b.y - margins.top, b.x, b.x2(), node, id, SegmentType.TOP, MarginType.WITH_MARGIN));
            } else {
                this.mHorizontalEdges.add(new Segment(b.y, b.x, b.x2(), node, id, SegmentType.TOP, MarginType.NO_MARGIN));
            }
            if (margins.bottom != 0) {
                this.mHorizontalEdges.add(new Segment(b.y2(), b.x, b.x2(), node, id, SegmentType.BOTTOM, MarginType.WITHOUT_MARGIN));
                this.mHorizontalEdges.add(new Segment(b.y2() + margins.bottom, b.x, b.x2(), node, id, SegmentType.BOTTOM, MarginType.WITH_MARGIN));
            } else {
                this.mHorizontalEdges.add(new Segment(b.y2(), b.x, b.x2(), node, id, SegmentType.BOTTOM, MarginType.NO_MARGIN));
            }
        }
        if (addVertical) {
            if (margins.left != 0) {
                this.mVerticalEdges.add(new Segment(b.x, b.y, b.y2(), node, id, SegmentType.LEFT, MarginType.WITHOUT_MARGIN));
                this.mVerticalEdges.add(new Segment(b.x - margins.left, b.y, b.y2(), node, id, SegmentType.LEFT, MarginType.WITH_MARGIN));
            } else {
                this.mVerticalEdges.add(new Segment(b.x, b.y, b.y2(), node, id, SegmentType.LEFT, MarginType.NO_MARGIN));
            }
            if (margins.right != 0) {
                this.mVerticalEdges.add(new Segment(b.x2(), b.y, b.y2(), node, id, SegmentType.RIGHT, MarginType.WITHOUT_MARGIN));
                this.mVerticalEdges.add(new Segment(b.x2() + margins.right, b.y, b.y2(), node, id, SegmentType.RIGHT, MarginType.WITH_MARGIN));
            } else {
                this.mVerticalEdges.add(new Segment(b.x2(), b.y, b.y2(), node, id, SegmentType.RIGHT, MarginType.NO_MARGIN));
            }
        }
    }

    protected void addCenter(INode node, String id, boolean addHorizontal, boolean addVertical) {
        Rect b = node.getBounds();
        if (addHorizontal) {
            this.mCenterHorizEdges.add(new Segment(b.centerY(), b.x, b.x2(), node, id, SegmentType.CENTER_HORIZONTAL, MarginType.NO_MARGIN));
        }
        if (addVertical) {
            this.mCenterVertEdges.add(new Segment(b.centerX(), b.y, b.y2(), node, id, SegmentType.CENTER_VERTICAL, MarginType.NO_MARGIN));
        }
    }

    protected int addBaseLine(INode node, String id) {
        int baselineY = node.getBaseline();
        if (baselineY != -1) {
            Rect b = node.getBounds();
            this.mHorizontalEdges.add(new Segment(b.y + baselineY, b.x, b.x2(), node, id, SegmentType.BASELINE, MarginType.NO_MARGIN));
        }
        return baselineY;
    }

    protected void snapVertical(Segment vEdge, int x, Rect newBounds) {
        newBounds.x = x;
    }

    protected void snapHorizontal(Segment hEdge, int y, Rect newBounds) {
        newBounds.y = y;
    }

    protected boolean isEdgeTypeCompatible(SegmentType edge, SegmentType dragged, int delta) {
        if (Math.abs(delta) > BaseLayoutRule.getMaxMatchDistance() && (dragged == SegmentType.LEFT || dragged == SegmentType.TOP ? delta > 0 : delta < 0)) {
            return false;
        }
        switch (edge) {
            case TOP: 
            case BOTTOM: {
                return dragged == SegmentType.TOP || dragged == SegmentType.BOTTOM;
            }
            case LEFT: 
            case RIGHT: {
                return dragged == SegmentType.LEFT || dragged == SegmentType.RIGHT;
            }
            case BASELINE: 
            case CENTER_VERTICAL: 
            case CENTER_HORIZONTAL: {
                return dragged == edge && Math.abs(delta) < BaseLayoutRule.getMaxMatchDistance();
            }
        }
        assert (false) : edge;
        return false;
    }

    protected List<Match> findClosest(Segment draggedEdge, List<Segment> edges) {
        ArrayList<Match> closest = new ArrayList<Match>();
        this.addClosest(draggedEdge, edges, closest);
        return closest;
    }

    protected void addClosest(Segment draggedEdge, List<Segment> edges, List<Match> closest) {
        int at = draggedEdge.at;
        int closestDelta = closest.size() > 0 ? closest.get((int)0).delta : Integer.MAX_VALUE;
        int closestDistance = Math.abs(closestDelta);
        for (Segment edge : edges) {
            boolean withParent;
            ConstraintType type;
            assert (draggedEdge.edgeType.isHorizontal() == edge.edgeType.isHorizontal());
            int delta = edge.at - at;
            int distance = Math.abs(delta);
            if (distance > closestDistance || !this.isEdgeTypeCompatible(edge.edgeType, draggedEdge.edgeType, delta) || (type = ConstraintType.forMatch(withParent = edge.node == this.layout, draggedEdge.edgeType, edge.edgeType)) == null || type.relativeToMargin && edge.marginType == MarginType.WITHOUT_MARGIN || !type.relativeToMargin && edge.marginType == MarginType.WITH_MARGIN) continue;
            Match match = new Match(this, edge, draggedEdge, type, delta);
            if (distance < closestDistance) {
                closest.clear();
                closestDistance = distance;
                closestDelta = delta;
            } else if (delta * closestDelta < 0) continue;
            closest.add(match);
        }
    }

    protected void clearSuggestions() {
        this.mVerticalSuggestions = null;
        this.mHorizontalSuggestions = null;
        this.mCurrentRightMatch = null;
        this.mCurrentLeftMatch = null;
        this.mCurrentBottomMatch = null;
        this.mCurrentTopMatch = null;
    }

    public void applyConstraints(INode n) {
        String centerBoth = n.getStringAttr("http://schemas.android.com/apk/res/android", "layout_centerInParent");
        if (centerBoth != null && centerBoth.equals("true")) {
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerInParent", null);
            if (this.mCurrentTopMatch == null && this.mCurrentBottomMatch == null) {
                n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerVertical", "true");
            }
            if (this.mCurrentLeftMatch == null && this.mCurrentRightMatch == null) {
                n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", "true");
            }
        }
        if (this.mMoveTop) {
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentTop", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignTop", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_below", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerVertical", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignBaseline", null);
        }
        if (this.mMoveBottom) {
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentBottom", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignBottom", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_above", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerVertical", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignBaseline", null);
        }
        if (this.mMoveLeft) {
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentLeft", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignLeft", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_toRightOf", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", null);
        }
        if (this.mMoveRight) {
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentRight", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignRight", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_toLeftOf", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", null);
        }
        if (this.mMoveTop && this.mCurrentTopMatch != null) {
            this.applyConstraint(n, this.mCurrentTopMatch.getConstraint(true));
            if (this.mCurrentTopMatch.type == ConstraintType.ALIGN_BASELINE) {
                String c = this.mCurrentTopMatch.getConstraint(true);
                c = c.replace("layout_alignBaseline", "layout_alignBottom");
                this.applyConstraint(n, c);
            }
        }
        if (this.mMoveBottom && this.mCurrentBottomMatch != null) {
            this.applyConstraint(n, this.mCurrentBottomMatch.getConstraint(true));
        }
        if (this.mMoveLeft && this.mCurrentLeftMatch != null) {
            this.applyConstraint(n, this.mCurrentLeftMatch.getConstraint(true));
        }
        if (this.mMoveRight && this.mCurrentRightMatch != null) {
            this.applyConstraint(n, this.mCurrentRightMatch.getConstraint(true));
        }
        if (this.mMoveLeft) {
            this.applyMargin(n, "layout_marginLeft", this.mLeftMargin);
        }
        if (this.mMoveRight) {
            this.applyMargin(n, "layout_marginRight", this.mRightMargin);
        }
        if (this.mMoveTop) {
            this.applyMargin(n, "layout_marginTop", this.mTopMargin);
        }
        if (this.mMoveBottom) {
            this.applyMargin(n, "layout_marginBottom", this.mBottomMargin);
        }
    }

    private void applyConstraint(INode n, String constraint) {
        assert (constraint.contains("=")) : constraint;
        String name = constraint.substring(0, constraint.indexOf(61));
        String value = constraint.substring(constraint.indexOf(61) + 1);
        n.setAttribute("http://schemas.android.com/apk/res/android", name, value);
    }

    private void applyMargin(INode n, String marginAttribute, int margin) {
        if (margin > 0) {
            int dp = this.mRulesEngine.pxToDp(margin);
            n.setAttribute("http://schemas.android.com/apk/res/android", marginAttribute, String.format("%ddp", dp));
        } else if (n.getStringAttr("http://schemas.android.com/apk/res/android", marginAttribute) != null) {
            n.setAttribute("http://schemas.android.com/apk/res/android", marginAttribute, null);
        }
    }

    private void removeRelativeParams(INode node) {
        ConstraintType[] constraintTypeArray = ConstraintType.values();
        int n = constraintTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintType type = constraintTypeArray[n2];
            node.setAttribute("http://schemas.android.com/apk/res/android", type.name, null);
            ++n2;
        }
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
    }

    public void attachPrevious(INode previous, INode node) {
        this.removeRelativeParams(node);
        String id = previous.getStringAttr("http://schemas.android.com/apk/res/android", "id");
        if (id == null) {
            return;
        }
        if (this.mCurrentTopMatch != null || this.mCurrentBottomMatch != null) {
            node.setAttribute("http://schemas.android.com/apk/res/android", this.mCurrentTopMatch != null ? "layout_below" : "layout_above", id);
            if (this.mCurrentLeftMatch != null) {
                this.applyConstraint(node, this.mCurrentLeftMatch.getConstraint(true));
                this.applyMargin(node, "layout_marginLeft", this.mLeftMargin);
            } else if (this.mCurrentRightMatch != null) {
                this.applyConstraint(node, this.mCurrentRightMatch.getConstraint(true));
                this.applyMargin(node, "layout_marginRight", this.mRightMargin);
            }
        } else if (this.mCurrentLeftMatch != null || this.mCurrentRightMatch != null) {
            node.setAttribute("http://schemas.android.com/apk/res/android", this.mCurrentLeftMatch != null ? "layout_toRightOf" : "layout_toLeftOf", id);
            if (this.mCurrentTopMatch != null) {
                this.applyConstraint(node, this.mCurrentTopMatch.getConstraint(true));
                this.applyMargin(node, "layout_marginTop", this.mTopMargin);
            } else if (this.mCurrentBottomMatch != null) {
                this.applyConstraint(node, this.mCurrentBottomMatch.getConstraint(true));
                this.applyMargin(node, "layout_marginBottom", this.mBottomMargin);
            }
        } else {
            return;
        }
    }

    public void removeCycles() {
        if (this.mHorizontalCycle != null) {
            this.removeCycles(this.mHorizontalDeps);
        }
        if (this.mVerticalCycle != null) {
            this.removeCycles(this.mVerticalDeps);
        }
    }

    private void removeCycles(Set<INode> deps) {
        for (INode node : this.mDraggedNodes) {
            DependencyGraph.ViewData view = this.mDependencyGraph.getView(node);
            if (view == null) continue;
            for (DependencyGraph.Constraint constraint : view.dependedOnBy) {
                constraint.from.node.setAttribute("http://schemas.android.com/apk/res/android", constraint.type.name, null);
            }
        }
    }

    public IClientRulesEngine getRulesEngine() {
        return this.mRulesEngine;
    }

    private final class MatchComparator
    implements Comparator<Match> {
        private MatchComparator() {
        }

        @Override
        public int compare(Match m1, Match m2) {
            int edgeType2;
            int orientation2;
            int baseline2;
            int distance2;
            int distance1;
            int cycle2;
            int cycle1;
            int parent2;
            int parent1 = m1.edge.node == GuidelineHandler.this.layout ? -1 : 1;
            int n = parent2 = m2.edge.node == GuidelineHandler.this.layout ? -1 : 1;
            if (m1.edge.edgeType == SegmentType.CENTER_HORIZONTAL || m1.edge.edgeType == SegmentType.CENTER_VERTICAL) {
                parent1 = 2;
            }
            if (m2.edge.edgeType == SegmentType.CENTER_HORIZONTAL || m2.edge.edgeType == SegmentType.CENTER_VERTICAL) {
                parent2 = 2;
            }
            if (parent1 != parent2) {
                return parent1 - parent2;
            }
            if (m1.edge.edgeType.isHorizontal()) {
                cycle1 = GuidelineHandler.this.mHorizontalDeps.contains(m1.edge.node) ? 1 : -1;
                int n2 = cycle2 = GuidelineHandler.this.mHorizontalDeps.contains(m2.edge.node) ? 1 : -1;
                if (cycle1 != cycle2) {
                    return cycle1 - cycle2;
                }
            } else {
                cycle1 = GuidelineHandler.this.mVerticalDeps.contains(m1.edge.node) ? 1 : -1;
                int n3 = cycle2 = GuidelineHandler.this.mVerticalDeps.contains(m2.edge.node) ? 1 : -1;
                if (cycle1 != cycle2) {
                    return cycle1 - cycle2;
                }
            }
            if ((distance1 = m1.edge.to <= m1.with.from ? m1.with.from - m1.edge.to : (m1.edge.from >= m1.with.to ? m1.edge.from - m1.with.to : 0)) != (distance2 = m2.edge.to <= m2.with.from ? m2.with.from - m2.edge.to : (m2.edge.from >= m2.with.to ? m2.edge.from - m2.with.to : 0))) {
                return distance1 - distance2;
            }
            int baseline1 = m1.edge.edgeType == SegmentType.BASELINE ? -1 : 1;
            int n4 = baseline2 = m2.edge.edgeType == SegmentType.BASELINE ? -1 : 1;
            if (baseline1 != baseline2) {
                return baseline1 - baseline2;
            }
            int orientation1 = m1.with.edgeType == SegmentType.LEFT || m1.with.edgeType == SegmentType.TOP ? -1 : 1;
            int n5 = orientation2 = m2.with.edgeType == SegmentType.LEFT || m2.with.edgeType == SegmentType.TOP ? -1 : 1;
            if (orientation1 != orientation2) {
                return orientation1 - orientation2;
            }
            int edgeType1 = m1.edge.edgeType != m1.with.edgeType ? -1 : 1;
            int n6 = edgeType2 = m2.edge.edgeType != m2.with.edgeType ? -1 : 1;
            if (edgeType1 != edgeType2) {
                return edgeType1 - edgeType2;
            }
            return 0;
        }
    }
}

