/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build;

import com.android.sdklib.build.RenderScriptChecker;
import java.io.IOException;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.SourceChangeHandler;
import org.eclipse.core.resources.IFile;

public class RsSourceChangeHandler
implements SourceChangeHandler {
    private final RenderScriptChecker mChecker;
    private boolean mIsCheckerLoaded = false;
    private boolean mMustCompile = false;

    public RsSourceChangeHandler(RenderScriptChecker checker) {
        this.mChecker = checker;
    }

    @Override
    public boolean handleGeneratedFile(IFile file, int kind) {
        if (this.mMustCompile) {
            return false;
        }
        if (!this.mIsCheckerLoaded) {
            try {
                this.mChecker.loadDependencies();
            }
            catch (IOException e) {
                AndmoreAndroidPlugin.log(e, "Failed to read dependency files", new Object[0]);
                this.mMustCompile = true;
                return false;
            }
        }
        Set oldOutputs = this.mChecker.getOldOutputs();
        this.mMustCompile = oldOutputs.contains(file.getLocation().toFile());
        return this.mMustCompile;
    }

    @Override
    public void handleSourceFile(IFile file, int kind) {
        if (this.mMustCompile) {
            return;
        }
        String ext = file.getFileExtension();
        if ("rs".equals(ext) || "fs".equals(ext) || "rsh".equals(ext)) {
            this.mMustCompile = true;
        }
    }

    public boolean mustCompile() {
        return this.mMustCompile;
    }

    public RenderScriptChecker getChecker() {
        return this.mChecker;
    }

    public void prepareFullBuild() {
        this.mMustCompile = true;
    }
}

