/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.descriptors;

import com.android.ide.common.api.IAttributeInfo;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.common.resources.platform.AttributeInfo;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.BooleanAttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.FlagAttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ITextAttributeCreator;
import org.eclipse.andmore.internal.editors.descriptors.ListAttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ReferenceAttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.TextAttributeDescriptor;
import org.eclipse.andmore.internal.editors.uimodel.UiDocumentNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.graphics.Image;

public final class DescriptorsUtils {
    private static final String DEFAULT_WIDGET_PREFIX = "widget";
    private static final int JAVADOC_BREAK_LENGTH = 60;
    public static final String MANIFEST_SDK_URL = "/reference/android/R.styleable.html#";
    public static final String IMAGE_KEY = "image";
    private static final String CODE = "$code";
    private static final String LINK = "$link";
    private static final String ELEM = "$elem";
    private static final String BREAK = "$break";

    public static void appendAttributes(List<AttributeDescriptor> attributes, String elementXmlName, String nsUri, AttributeInfo[] infos, Set<String> requiredAttributes, Map<String, ITextAttributeCreator> overrides) {
        AttributeInfo[] attributeInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            String attr_name;
            AttributeInfo info = attributeInfoArray[n2];
            boolean required = false;
            if (requiredAttributes != null && (requiredAttributes.contains("*/" + (attr_name = info.getName())) || requiredAttributes.contains(String.valueOf(elementXmlName) + "/" + attr_name))) {
                required = true;
            }
            DescriptorsUtils.appendAttribute(attributes, elementXmlName, nsUri, info, required, overrides);
            ++n2;
        }
    }

    public static void appendAttribute(List<AttributeDescriptor> attributes, String elementXmlName, String nsUri, AttributeInfo info, boolean required, Map<String, ITextAttributeCreator> overrides) {
        TextAttributeDescriptor attr = null;
        String xmlLocalName = info.getName();
        EnumSet<IAttributeInfo.Format> formats_set = info.getFormats();
        int flen = formats_set.size();
        if (flen > 0) {
            if (overrides != null) {
                for (Map.Entry<String, ITextAttributeCreator> entry : overrides.entrySet()) {
                    ITextAttributeCreator override;
                    boolean ok_element;
                    String key = entry.getKey();
                    String[] elements = key.split("/");
                    String overrideAttrLocalName = null;
                    if (elements.length < 1) continue;
                    if (elements.length == 1) {
                        overrideAttrLocalName = elements[0];
                        elements = null;
                    } else {
                        overrideAttrLocalName = elements[elements.length - 1];
                        elements = elements[0].split(",");
                    }
                    if (overrideAttrLocalName == null || !overrideAttrLocalName.equals(xmlLocalName)) continue;
                    boolean bl = ok_element = elements != null && elements.length < 1;
                    if (!ok_element && elements != null) {
                        String[] stringArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String element = stringArray[n2];
                            if (element.equals("*") || element.equals(elementXmlName)) {
                                ok_element = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!ok_element || (override = entry.getValue()) == null) continue;
                    attr = override.create(xmlLocalName, nsUri, info);
                }
            }
            if (attr == null) {
                if (formats_set.contains(IAttributeInfo.Format.REFERENCE)) {
                    attr = new ReferenceAttributeDescriptor(xmlLocalName, nsUri, info);
                } else if (formats_set.contains(IAttributeInfo.Format.ENUM)) {
                    attr = new ListAttributeDescriptor(xmlLocalName, nsUri, info);
                } else if (formats_set.contains(IAttributeInfo.Format.FLAG)) {
                    attr = new FlagAttributeDescriptor(xmlLocalName, nsUri, info);
                } else if (formats_set.contains(IAttributeInfo.Format.BOOLEAN)) {
                    attr = new BooleanAttributeDescriptor(xmlLocalName, nsUri, info);
                } else if (formats_set.contains(IAttributeInfo.Format.STRING)) {
                    attr = new ReferenceAttributeDescriptor(ResourceType.STRING, xmlLocalName, nsUri, info);
                }
            }
        }
        if (attr == null) {
            attr = new TextAttributeDescriptor(xmlLocalName, nsUri, info);
        }
        if (required) {
            attr.setRequired(true);
        }
        attributes.add(attr);
    }

    public static boolean containsAttribute(ArrayList<AttributeDescriptor> attributes, String nsUri, AttributeInfo info) {
        String xmlLocalName = info.getName();
        for (AttributeDescriptor desc : attributes) {
            if (!desc.getXmlLocalName().equals(xmlLocalName) || !nsUri.equals(desc.getNamespaceUri()) && (nsUri == null || !nsUri.equals(desc.getNamespaceUri()))) continue;
            return true;
        }
        return false;
    }

    public static String prettyAttributeUiName(String name) {
        if (name.length() < 1) {
            return name;
        }
        StringBuilder buf = new StringBuilder(2 * name.length());
        char c = name.charAt(0);
        buf.append(Character.toUpperCase(c));
        int len = name.length();
        int i = 1;
        while (i < len) {
            c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append(' ');
                if (c >= 'X' && c <= 'Z' && (i == len - 1 || i < len - 1 && Character.isUpperCase(name.charAt(i + 1)))) {
                    buf.append(c);
                } else {
                    buf.append(Character.toLowerCase(c));
                }
            } else if (c == '_') {
                buf.append(' ');
            } else {
                buf.append(c);
            }
            ++i;
        }
        name = buf.toString();
        name = DescriptorsUtils.replaceAcronyms(name);
        return name;
    }

    public static String capitalize(String name) {
        if (name.isEmpty()) {
            return name;
        }
        StringBuilder buf = new StringBuilder(2 * name.length());
        char c = name.charAt(0);
        buf.append(Character.toUpperCase(c));
        int len = name.length();
        int i = 1;
        while (i < len) {
            c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append(' ');
                buf.append(c);
            } else if (c == '_') {
                buf.append(' ');
                if (i < len - 1 && Character.isLowerCase(name.charAt(i + 1))) {
                    buf.append(Character.toUpperCase(name.charAt(i + 1)));
                    ++i;
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        name = buf.toString();
        name = DescriptorsUtils.replaceAcronyms(name);
        return name;
    }

    private static String replaceAcronyms(String name) {
        if (name.contains("sdk") || name.contains("Sdk")) {
            name = name.replaceAll("(?<=^| )[sS]dk(?=$| )", "SDK");
        }
        if (name.contains("uri") || name.contains("Uri")) {
            name = name.replaceAll("(?<=^| )[uU]ri(?=$| )", "URI");
        }
        if (name.contains("ime") || name.contains("Ime")) {
            name = name.replaceAll("(?<=^| )[iI]me(?=$| )", "IME");
        }
        if (name.contains("vm") || name.contains("Vm")) {
            name = name.replaceAll("(?<=^| )[vV]m(?=$| )", "VM");
        }
        if (name.contains("ui") || name.contains("Ui")) {
            name = name.replaceAll("(?<=^| )[uU]i(?=$| )", "UI");
        }
        return name;
    }

    public static String formatTooltip(String javadoc) {
        ArrayList<String> spans = DescriptorsUtils.scanJavadoc(javadoc);
        StringBuilder sb = new StringBuilder();
        boolean needBreak = false;
        int n = spans.size();
        int i = 0;
        while (i < n) {
            String s = spans.get(i);
            if (CODE.equals(s)) {
                if ((s = spans.get(++i)) != null) {
                    sb.append('\"').append(s).append('\"');
                }
            } else if (LINK.equals(s)) {
                String base = spans.get(++i);
                String anchor = spans.get(++i);
                String text = spans.get(++i);
                if (base != null) {
                    base = base.trim();
                }
                if (anchor != null) {
                    anchor = anchor.trim();
                }
                if (text != null) {
                    text = text.trim();
                }
                if (text == null || text.length() == 0) {
                    text = anchor;
                }
                if (base != null && base.length() > 0 && (text == null || text.length() == 0)) {
                    text = base;
                }
                if (text != null) {
                    sb.append(text);
                }
            } else if (ELEM.equals(s)) {
                if ((s = spans.get(++i)) != null) {
                    sb.append(s);
                }
            } else if (BREAK.equals(s)) {
                needBreak = true;
            } else if (s != null) {
                if (needBreak && s.trim().length() > 0) {
                    sb.append('\n');
                }
                sb.append(s);
                needBreak = false;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String formatFormText(String javadoc, ElementDescriptor elementDescriptor, String androidDocBaseUrl) {
        ArrayList<String> spans = DescriptorsUtils.scanJavadoc(javadoc);
        String fullSdkUrl = String.valueOf(androidDocBaseUrl) + MANIFEST_SDK_URL;
        String sdkUrl = elementDescriptor.getSdkUrl();
        if (sdkUrl != null && sdkUrl.startsWith(MANIFEST_SDK_URL)) {
            fullSdkUrl = String.valueOf(androidDocBaseUrl) + sdkUrl;
        }
        StringBuilder sb = new StringBuilder();
        Image icon = elementDescriptor.getCustomizedIcon();
        if (icon != null) {
            sb.append("<form><li style=\"image\" value=\"image\">");
        } else {
            sb.append("<form><p>");
        }
        int n = spans.size();
        int i = 0;
        while (i < n) {
            String s = spans.get(i);
            if (CODE.equals(s)) {
                s = spans.get(++i);
                if (elementDescriptor.getXmlName().equals(s) && fullSdkUrl != null) {
                    sb.append("<a href=\"");
                    sb.append(fullSdkUrl);
                    sb.append("\">");
                    sb.append(s);
                    sb.append("</a>");
                } else if (s != null) {
                    sb.append('\"').append(s).append('\"');
                }
            } else if (LINK.equals(s)) {
                String base = spans.get(++i);
                String anchor = spans.get(++i);
                String text = spans.get(++i);
                if (base != null) {
                    base = base.trim();
                }
                if (anchor != null) {
                    anchor = anchor.trim();
                }
                if (text != null) {
                    text = text.trim();
                }
                if (text == null || text.length() == 0) {
                    text = anchor;
                }
                if ((base == null || base.length() == 0) && fullSdkUrl != null) {
                    base = fullSdkUrl;
                }
                String url = null;
                if (base != null && base.length() > 0) {
                    if (base.startsWith("http")) {
                        url = base;
                        if (anchor != null && anchor.length() > 0) {
                            int pos = url.lastIndexOf(35);
                            if (pos < 0) {
                                url = String.valueOf(url) + "#";
                            } else if (pos < url.length() - 1) {
                                url = url.substring(0, pos + 1);
                            }
                            url = String.valueOf(url) + anchor;
                        }
                    } else if (text == null || text.length() == 0) {
                        text = base;
                    }
                }
                if (url != null && text != null) {
                    sb.append("<a href=\"");
                    sb.append(url);
                    sb.append("\">");
                    sb.append(text);
                    sb.append("</a>");
                } else if (text != null) {
                    sb.append("<b>").append(text).append("</b>");
                }
            } else if (ELEM.equals(s)) {
                s = spans.get(++i);
                if (sdkUrl != null && s != null) {
                    sb.append("<a href=\"");
                    sb.append(sdkUrl);
                    sb.append("\">");
                    sb.append(s);
                    sb.append("</a>");
                } else if (s != null) {
                    sb.append("<b>").append(s).append("</b>");
                }
            } else if (!BREAK.equals(s) && s != null) {
                sb.append(s);
            }
            ++i;
        }
        if (icon != null) {
            sb.append("</li></form>");
        } else {
            sb.append("</p></form>");
        }
        return sb.toString();
    }

    private static ArrayList<String> scanJavadoc(String javadoc) {
        ArrayList<String> spans = new ArrayList<String>();
        if (javadoc != null) {
            javadoc = javadoc.replaceAll("[ \t\f\r\n]+", " ");
        }
        Pattern p_link = Pattern.compile("\\{@link\\s+([^#\\}\\s]*)(?:#([^\\s\\}]*))?(?:\\s*([^\\}]*))?\\}(.*)");
        Pattern p_code = Pattern.compile("<code>(.+?)</code>(.*)");
        Pattern p_elem = Pattern.compile("@([\\w -]+)@(.*)");
        Pattern p_break = Pattern.compile("@@(.*)");
        Pattern p_open = Pattern.compile("([@<\\{])(.*)");
        Pattern p_text = Pattern.compile("([^@<\\{]+)(.*)");
        int currentLength = 0;
        String text = null;
        while (javadoc != null && javadoc.length() > 0) {
            String s = null;
            Matcher m = p_code.matcher(javadoc);
            if (m.matches()) {
                spans.add(CODE);
                text = DescriptorsUtils.cleanupJavadocHtml(m.group(1));
                spans.add(text);
                javadoc = m.group(2);
                if (text != null) {
                    currentLength += text.length();
                }
            } else {
                m = p_link.matcher(javadoc);
                if (m.matches()) {
                    spans.add(LINK);
                    spans.add(m.group(1));
                    spans.add(m.group(2));
                    text = DescriptorsUtils.cleanupJavadocHtml(m.group(3));
                    spans.add(text);
                    javadoc = m.group(4);
                    if (text != null) {
                        currentLength += text.length();
                    }
                } else {
                    m = p_elem.matcher(javadoc);
                    if (m.matches()) {
                        spans.add(ELEM);
                        text = DescriptorsUtils.cleanupJavadocHtml(m.group(1));
                        spans.add(text);
                        javadoc = m.group(2);
                        if (text != null) {
                            currentLength += text.length() - 2;
                        }
                    } else {
                        m = p_break.matcher(javadoc);
                        if (m.matches()) {
                            spans.add(BREAK);
                            currentLength = 0;
                            javadoc = m.group(1);
                        } else {
                            m = p_open.matcher(javadoc);
                            if (m.matches()) {
                                s = m.group(1);
                                javadoc = m.group(2);
                            } else {
                                m = p_text.matcher(javadoc);
                                if (m.matches()) {
                                    s = m.group(1);
                                    javadoc = m.group(2);
                                } else {
                                    s = javadoc;
                                    javadoc = null;
                                }
                            }
                        }
                    }
                }
            }
            if (s == null || s.length() <= 0) continue;
            s = DescriptorsUtils.cleanupJavadocHtml(s);
            if (currentLength >= 60) {
                spans.add(BREAK);
                currentLength = 0;
            }
            while (currentLength + s.length() > 60) {
                int pos = s.indexOf(32, 60 - currentLength);
                if (pos <= 0) break;
                spans.add(s.substring(0, pos + 1));
                spans.add(BREAK);
                currentLength = 0;
                s = s.substring(pos + 1);
            }
            spans.add(s);
            currentLength += s.length();
        }
        return spans;
    }

    private static String cleanupJavadocHtml(String s) {
        if (s != null) {
            s = s.replaceAll("&lt;", "\"");
            s = s.replaceAll("&gt;", "\"");
            s = s.replaceAll("<[^>]+>", "");
        }
        return s;
    }

    public static String getBasename(String fqcn) {
        String name = fqcn;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(lastDot + 1);
        }
        return name;
    }

    public static void setDefaultLayoutAttributes(UiElementNode node, boolean updateLayout) {
        String id;
        UiElementNode previous;
        UiElementNode parent;
        String freeId;
        boolean setSize;
        ElementDescriptor descriptor = node.getDescriptor();
        String name = descriptor.getXmlLocalName();
        if (name.equals("requestFocus")) {
            return;
        }
        boolean bl = setSize = !node.getUiParent().getDescriptor().getXmlName().equals("GridLayout");
        if (setSize) {
            boolean fill = descriptor.hasChildren() && node.getUiParent() instanceof UiDocumentNode;
            node.setAttributeValue("layout_width", "http://schemas.android.com/apk/res/android", fill ? "fill_parent" : "wrap_content", false);
            node.setAttributeValue("layout_height", "http://schemas.android.com/apk/res/android", fill ? "fill_parent" : "wrap_content", false);
        }
        if (DescriptorsUtils.needsDefaultId(node.getDescriptor()) && (freeId = DescriptorsUtils.getFreeWidgetId(node)) != null) {
            node.setAttributeValue("id", "http://schemas.android.com/apk/res/android", freeId, false);
        }
        if (descriptor.definesAttribute("http://schemas.android.com/apk/res/android", "text") && !descriptor.getXmlLocalName().equals("EditText")) {
            String type = DescriptorsUtils.getBasename(descriptor.getUiName());
            node.setAttributeValue("text", "http://schemas.android.com/apk/res/android", type, false);
        }
        if (updateLayout && (parent = node.getUiParent()) != null && parent.getDescriptor().getXmlLocalName().equals("RelativeLayout") && (previous = node.getUiPreviousSibling()) != null && (id = previous.getAttributeValue("id")) != null && id.length() > 0) {
            id = id.replace("@+", "@");
            node.setAttributeValue("layout_below", "http://schemas.android.com/apk/res/android", id, false);
        }
    }

    public static boolean needsDefaultId(ElementDescriptor descriptor) {
        String tag = descriptor.getXmlLocalName();
        return !tag.endsWith("Layout") && !tag.equals("include") && !tag.equals("merge") && !tag.equals("Space") && (!tag.endsWith("Space") || tag.length() <= "Space".length() || tag.charAt(tag.length() - "Space".length()) != '.');
    }

    public static String getFreeWidgetId(UiElementNode uiNode) {
        String name = DescriptorsUtils.getBasename(uiNode.getDescriptor().getXmlLocalName());
        return DescriptorsUtils.getFreeWidgetId(uiNode.getUiRoot(), name);
    }

    public static String getFreeWidgetId(UiElementNode uiRoot, String name) {
        if ("TabWidget".equals(name)) {
            return "@android:id/tabs";
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = name;
        return "@+id/" + DescriptorsUtils.getFreeWidgetId(uiRoot, objectArray);
    }

    private static String getFreeWidgetId(UiElementNode uiRoot, Object[] params) {
        String id;
        HashSet<String> map = (HashSet<String>)params[3];
        if (map == null) {
            params[3] = map = new HashSet<String>();
        }
        int num = params[1] == null ? 0 : (Integer)params[1];
        String generated = (String)params[2];
        String prefix = (String)params[0];
        if (generated == null) {
            int pos = prefix.indexOf(46);
            if (pos >= 0) {
                prefix = prefix.substring(pos + 1);
            }
            if ((pos = prefix.indexOf(36)) >= 0) {
                prefix = prefix.substring(pos + 1);
            }
            prefix = (prefix = prefix.replaceAll("[^a-zA-Z]", "")).length() == 0 ? DEFAULT_WIDGET_PREFIX : String.valueOf(Character.toLowerCase(prefix.charAt(0))) + prefix.substring(1);
            while (map.contains((generated = String.format("%1$s%2$d", prefix, ++num)).toLowerCase(Locale.US))) {
            }
            params[0] = prefix;
            params[1] = num;
            params[2] = generated;
        }
        if ((id = uiRoot.getAttributeValue("id")) != null) {
            id = id.replace("@+id/", "");
            if (map.add((id = id.replace("@id/", "")).toLowerCase(Locale.US)) && map.contains(generated.toLowerCase(Locale.US))) {
                while (map.contains((generated = String.format("%1$s%2$d", prefix, ++num)).toLowerCase(Locale.US))) {
                }
                params[1] = num;
                params[2] = generated;
            }
        }
        for (UiElementNode uiChild : uiRoot.getUiChildren()) {
            DescriptorsUtils.getFreeWidgetId(uiChild, params);
        }
        return (String)params[2];
    }

    public static boolean canInsertChildren(ElementDescriptor descriptor, Object viewObject) {
        if (descriptor.hasChildren()) {
            if (viewObject != null) {
                Class<?> clz = viewObject.getClass();
                while (clz != null) {
                    if (clz.getName().equals("android.widget.AdapterView")) {
                        return false;
                    }
                    clz = clz.getSuperclass();
                }
            } else {
                String viewName = descriptor.getXmlLocalName();
                if (viewName.equals("ListView") || viewName.equals("ExpandableListView") || viewName.equals("Gallery") || viewName.equals("GridView")) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

