/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.descriptors;

import com.android.ide.common.api.IAttributeInfo;
import com.android.sdklib.IAndroidTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.common.resources.platform.AttributeInfo;
import org.eclipse.andmore.common.resources.platform.DeclareStyleableInfo;
import org.eclipse.andmore.common.resources.platform.ViewClassInfo;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.descriptors.DocumentDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.IDescriptorProvider;
import org.eclipse.andmore.internal.editors.descriptors.TextAttributeDescriptor;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.manifest.descriptors.ClassAttributeDescriptor;

public final class LayoutDescriptors
implements IDescriptorProvider {
    private DocumentDescriptor mRootDescriptor = new DocumentDescriptor("layout_doc", null);
    private List<ViewElementDescriptor> mLayoutDescriptors = Collections.emptyList();
    private List<ViewElementDescriptor> mROLayoutDescriptors;
    private List<ViewElementDescriptor> mViewDescriptors = Collections.emptyList();
    private List<ViewElementDescriptor> mROViewDescriptors;
    private ViewElementDescriptor mBaseViewDescriptor;
    private Map<String, ViewElementDescriptor> mFqcnToDescriptor = new HashMap<String, ViewElementDescriptor>(80);

    @Override
    public DocumentDescriptor getDescriptor() {
        return this.mRootDescriptor;
    }

    public List<ViewElementDescriptor> getLayoutDescriptors() {
        return this.mROLayoutDescriptors;
    }

    public List<ViewElementDescriptor> getViewDescriptors() {
        return this.mROViewDescriptors;
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return this.mRootDescriptor.getChildren();
    }

    public ViewElementDescriptor getBaseViewDescriptor() {
        if (this.mBaseViewDescriptor == null) {
            this.mBaseViewDescriptor = this.findDescriptorByClass("android.view.View");
        }
        return this.mBaseViewDescriptor;
    }

    public synchronized void updateDescriptors(ViewClassInfo[] views, ViewClassInfo[] layouts, Map<String, DeclareStyleableInfo> styleMap, IAndroidTarget target) {
        Object desc;
        int n;
        HashMap<ViewClassInfo, ViewElementDescriptor> infoDescMap = new HashMap<ViewClassInfo, ViewElementDescriptor>();
        ArrayList<ViewElementDescriptor> newViews = new ArrayList<ViewElementDescriptor>(40);
        if (views != null) {
            ViewClassInfo[] viewClassInfoArray = views;
            n = views.length;
            int n2 = 0;
            while (n2 < n) {
                ViewClassInfo info = viewClassInfoArray[n2];
                desc = this.convertView(info, infoDescMap);
                newViews.add((ViewElementDescriptor)desc);
                this.mFqcnToDescriptor.put(((ViewElementDescriptor)desc).getFullClassName(), (ViewElementDescriptor)desc);
                ++n2;
            }
        }
        this.insertInclude(newViews);
        ArrayList<ViewElementDescriptor> newLayouts = new ArrayList<ViewElementDescriptor>(30);
        if (layouts != null) {
            desc = layouts;
            int n3 = layouts.length;
            n = 0;
            while (n < n3) {
                ViewClassInfo info = desc[n];
                ViewElementDescriptor desc2 = this.convertView(info, infoDescMap);
                newLayouts.add(desc2);
                this.mFqcnToDescriptor.put(desc2.getFullClassName(), desc2);
                ++n;
            }
        }
        AttributeDescriptor[] frameLayoutAttrs = this.findViewLayoutAttributes("android.widget.FrameLayout");
        if (target.getVersion().getApiLevel() >= 4) {
            ViewElementDescriptor fragmentTag = this.createFragment(frameLayoutAttrs, styleMap);
            newViews.add(fragmentTag);
        }
        ArrayList<ElementDescriptor> newDescriptors = new ArrayList<ElementDescriptor>(80);
        newDescriptors.addAll(newLayouts);
        newDescriptors.addAll(newViews);
        ViewElementDescriptor viewTag = this.createViewTag(frameLayoutAttrs);
        newViews.add(viewTag);
        newDescriptors.add(viewTag);
        ViewElementDescriptor requestFocus = this.createRequestFocus();
        newViews.add(requestFocus);
        newDescriptors.add(requestFocus);
        for (ViewElementDescriptor layoutDesc : newLayouts) {
            layoutDesc.setChildren(newDescriptors);
        }
        ViewElementDescriptor gestureView = this.findDescriptorByClass("android.gesture.GestureOverlayView");
        if (gestureView != null) {
            gestureView.setChildren(newDescriptors);
            gestureView.setLayoutAttributes(frameLayoutAttrs);
        }
        this.fixSuperClasses(infoDescMap);
        ViewElementDescriptor mergeTag = this.createMerge(frameLayoutAttrs);
        mergeTag.setChildren(newDescriptors);
        newDescriptors.add(mergeTag);
        newLayouts.add(mergeTag);
        Collections.sort(newViews);
        Collections.sort(newLayouts);
        this.mViewDescriptors = newViews;
        this.mLayoutDescriptors = newLayouts;
        this.mRootDescriptor.setChildren(newDescriptors);
        this.mBaseViewDescriptor = null;
        this.mROLayoutDescriptors = Collections.unmodifiableList(this.mLayoutDescriptors);
        this.mROViewDescriptors = Collections.unmodifiableList(this.mViewDescriptors);
    }

    private ViewElementDescriptor convertView(ViewClassInfo info, HashMap<ViewClassInfo, ViewElementDescriptor> infoDescMap) {
        String xmlName;
        String uiName = xmlName = info.getShortClassName();
        String fqcn = info.getFullClassName();
        if (ViewElementDescriptor.viewNeedsPackage(fqcn)) {
            xmlName = fqcn;
        }
        String tooltip = info.getJavaDoc();
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>(120);
        AttributeInfo styleInfo = new AttributeInfo("style", IAttributeInfo.Format.REFERENCE_SET);
        styleInfo.setJavaDoc("A reference to a custom style");
        DescriptorsUtils.appendAttribute(attributes, "style", null, styleInfo, false, null);
        styleInfo.setDefinedBy("android.view.View");
        DescriptorsUtils.appendAttributes(attributes, null, "http://schemas.android.com/apk/res/android", info.getAttributes(), null, null);
        ArrayList<String> attributeSources = new ArrayList<String>();
        if (info.getAttributes() != null && info.getAttributes().length > 0) {
            attributeSources.add(fqcn);
        }
        ViewClassInfo link = info.getSuperClass();
        while (link != null) {
            AttributeInfo[] attrList = link.getAttributes();
            if (attrList.length > 0) {
                attributeSources.add(link.getFullClassName());
                DescriptorsUtils.appendAttributes(attributes, null, "http://schemas.android.com/apk/res/android", attrList, null, null);
            }
            link = link.getSuperClass();
        }
        ArrayList<AttributeDescriptor> layoutAttributes = new ArrayList<AttributeDescriptor>();
        ViewClassInfo.LayoutParamsInfo layoutParams = info.getLayoutData();
        while (layoutParams != null) {
            AttributeInfo[] attributeInfoArray = layoutParams.getAttributes();
            int n = attributeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeInfo attrInfo = attributeInfoArray[n2];
                if (!DescriptorsUtils.containsAttribute(layoutAttributes, "http://schemas.android.com/apk/res/android", attrInfo)) {
                    DescriptorsUtils.appendAttribute(layoutAttributes, null, "http://schemas.android.com/apk/res/android", attrInfo, false, null);
                }
                ++n2;
            }
            layoutParams = layoutParams.getSuperClass();
        }
        ViewElementDescriptor desc = new ViewElementDescriptor(xmlName, uiName, fqcn, tooltip, null, attributes.toArray(new AttributeDescriptor[attributes.size()]), layoutAttributes.toArray(new AttributeDescriptor[layoutAttributes.size()]), null, false);
        desc.setAttributeSources(Collections.unmodifiableList(attributeSources));
        infoDescMap.put(info, desc);
        return desc;
    }

    private void insertInclude(List<ViewElementDescriptor> knownViews) {
        AttributeDescriptor[] viewLayoutAttribs;
        String xmlName = "include";
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
        AttributeDescriptor[] viewAttributes = null;
        ViewElementDescriptor viewDesc = this.findDescriptorByClass("android.view.View");
        if (viewDesc != null) {
            viewAttributes = viewDesc.getAttributes();
            attributes = new ArrayList(viewAttributes.length + 1);
            viewLayoutAttribs = viewDesc.getLayoutAttributes();
        } else {
            viewLayoutAttribs = new AttributeDescriptor[]{};
        }
        DescriptorsUtils.appendAttribute(attributes, null, null, new AttributeInfo("layout", IAttributeInfo.Format.REFERENCE_SET), true, null);
        if (viewAttributes != null) {
            AttributeDescriptor[] attributeDescriptorArray = viewAttributes;
            int n = viewAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeDescriptor descriptor = attributeDescriptorArray[n2];
                attributes.add(descriptor);
                ++n2;
            }
        }
        ViewElementDescriptor desc = new ViewElementDescriptor(xmlName, xmlName, "include", "Lets you statically include XML layouts inside other XML layouts.", null, attributes.toArray(new AttributeDescriptor[attributes.size()]), viewLayoutAttribs, null, false);
        knownViews.add(desc);
    }

    private ViewElementDescriptor createMerge(AttributeDescriptor[] viewLayoutAttribs) {
        String xmlName = "merge";
        ViewElementDescriptor desc = new ViewElementDescriptor(xmlName, xmlName, "merge", "A root tag useful for XML layouts inflated using a ViewStub.", null, null, viewLayoutAttribs, null, false);
        return desc;
    }

    private ViewElementDescriptor createFragment(AttributeDescriptor[] viewLayoutAttribs, Map<String, DeclareStyleableInfo> styleMap) {
        ViewElementDescriptor descriptor;
        String xmlName = "fragment";
        DeclareStyleableInfo style = styleMap.get("Fragment");
        String fragmentTooltip = "A Fragment is a piece of an application's user interface or behavior that can be placed in an Activity";
        String sdkUrl = "http://developer.android.com/guide/topics/fundamentals/fragments.html";
        TextAttributeDescriptor classAttribute = new ClassAttributeDescriptor(null, "class", null, new AttributeInfo("class", IAttributeInfo.Format.STRING_SET), true).setTooltip("Supply the name of the fragment class to instantiate");
        if (style != null) {
            descriptor = new ViewElementDescriptor("fragment", "fragment", "fragment", fragmentTooltip, sdkUrl, null, viewLayoutAttribs, null, false);
            ArrayList<AttributeDescriptor> descs = new ArrayList<AttributeDescriptor>();
            descs.add(classAttribute);
            DescriptorsUtils.appendAttributes(descs, null, "http://schemas.android.com/apk/res/android", style.getAttributes(), null, null);
            descriptor.setAttributes(descs.toArray(new AttributeDescriptor[descs.size()]));
        } else {
            descriptor = new ViewElementDescriptor(xmlName, xmlName, xmlName, fragmentTooltip, sdkUrl, new AttributeDescriptor[]{new ClassAttributeDescriptor(null, "name", "http://schemas.android.com/apk/res/android", new AttributeInfo("name", IAttributeInfo.Format.STRING_SET), true).setTooltip("Supply the name of the fragment class to instantiate"), classAttribute, new ClassAttributeDescriptor(null, "tag", "http://schemas.android.com/apk/res/android", new AttributeInfo("tag", IAttributeInfo.Format.STRING_SET), true).setTooltip("Supply a tag for the top-level view containing a String")}, viewLayoutAttribs, null, false);
        }
        return descriptor;
    }

    private ViewElementDescriptor createViewTag(AttributeDescriptor[] viewLayoutAttribs) {
        String xmlName = "view";
        TextAttributeDescriptor classAttribute = new ClassAttributeDescriptor("android.view.View", "class", null, new AttributeInfo("class", IAttributeInfo.Format.STRING_SET), true).setTooltip("Supply the name of the view class to instantiate");
        ViewElementDescriptor desc = new ViewElementDescriptor(xmlName, xmlName, xmlName, "A view tag whose class attribute names the class to be instantiated", null, new AttributeDescriptor[]{classAttribute}, viewLayoutAttribs, null, false);
        return desc;
    }

    private ViewElementDescriptor createRequestFocus() {
        String xmlName = "requestFocus";
        return new ViewElementDescriptor(xmlName, xmlName, xmlName, "Requests focus for the parent element or one of its descendants", null, null, null, null, false);
    }

    private AttributeDescriptor[] findViewLayoutAttributes(String viewFqcn) {
        ViewElementDescriptor viewDesc = this.findDescriptorByClass(viewFqcn);
        if (viewDesc != null) {
            return viewDesc.getLayoutAttributes();
        }
        return null;
    }

    private void fixSuperClasses(Map<ViewClassInfo, ViewElementDescriptor> infoDescMap) {
        for (Map.Entry<ViewClassInfo, ViewElementDescriptor> entry : infoDescMap.entrySet()) {
            ViewClassInfo info = entry.getKey();
            ViewElementDescriptor desc = entry.getValue();
            ViewClassInfo sup = info.getSuperClass();
            if (sup == null) continue;
            ViewElementDescriptor supDesc = infoDescMap.get(sup);
            while (supDesc == null && sup != null) {
                if ((sup = sup.getSuperClass()) == null) continue;
                supDesc = infoDescMap.get(sup);
            }
            if (supDesc == null) continue;
            desc.setSuperClass(supDesc);
        }
    }

    public ViewElementDescriptor findDescriptorByClass(String fqcn) {
        return this.mFqcnToDescriptor.get(fqcn);
    }

    public ViewElementDescriptor findDescriptorByTag(String tag) {
        for (ViewElementDescriptor descriptor : this.mLayoutDescriptors) {
            if (!tag.equals(descriptor.getXmlLocalName())) continue;
            return descriptor;
        }
        return null;
    }

    public Collection<String> getAllViewClassNames() {
        return this.mFqcnToDescriptor.keySet();
    }
}

