/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import org.eclipse.andmore.internal.editors.layout.gle2.CanvasTransform;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.Overlay;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtDrawingStyle;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class EmptyViewsOverlay
extends Overlay {
    private final ViewHierarchy mViewHierarchy;
    private Color mBorderColor;
    private CanvasTransform mVScale;
    private CanvasTransform mHScale;

    public EmptyViewsOverlay(ViewHierarchy viewHierarchy, CanvasTransform hScale, CanvasTransform vScale) {
        this.mViewHierarchy = viewHierarchy;
        this.mHScale = hScale;
        this.mVScale = vScale;
    }

    @Override
    public void create(Device device) {
        this.mBorderColor = new Color(device, SwtDrawingStyle.EMPTY.getStrokeColor());
    }

    @Override
    public void dispose() {
        if (this.mBorderColor != null) {
            this.mBorderColor.dispose();
            this.mBorderColor = null;
        }
    }

    @Override
    public void paint(GC gc) {
        gc.setForeground(this.mBorderColor);
        gc.setLineDash(null);
        gc.setLineStyle(SwtDrawingStyle.EMPTY.getLineStyle());
        int oldAlpha = gc.getAlpha();
        gc.setAlpha(SwtDrawingStyle.EMPTY.getStrokeAlpha());
        gc.setLineWidth(SwtDrawingStyle.EMPTY.getLineWidth());
        for (CanvasViewInfo info : this.mViewHierarchy.getInvisibleViews()) {
            Rectangle r = info.getAbsRect();
            int x = this.mHScale.translate(r.x);
            int y = this.mVScale.translate(r.y);
            int w = this.mHScale.scale(r.width);
            int h = this.mVScale.scale(r.height);
            gc.drawRectangle(x, y, w + 1, h + 1);
        }
        gc.setAlpha(oldAlpha);
    }
}

