/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.Rect;
import com.android.utils.SdkUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ImageUtils {
    public static final int SHADOW_SIZE = 20;
    public static final int SMALL_SHADOW_SIZE = 10;
    private static BufferedImage sShadowBottomLeft;
    private static BufferedImage sShadowBottom;
    private static BufferedImage sShadowBottomRight;
    private static BufferedImage sShadowRight;
    private static BufferedImage sShadowTopRight;
    private static BufferedImage sShadow2BottomLeft;
    private static BufferedImage sShadow2Bottom;
    private static BufferedImage sShadow2BottomRight;
    private static BufferedImage sShadow2Right;
    private static BufferedImage sShadow2TopRight;

    public static boolean containsDarkPixels(BufferedImage image) {
        int y = 0;
        int height = image.getHeight();
        while (y < height) {
            int x = 0;
            int width = image.getWidth();
            while (x < width) {
                int b;
                int g;
                int r;
                long brightness;
                int pixel = image.getRGB(x, y);
                if ((pixel & 0xFF000000) != 0 && (brightness = (299L * (long)(r = (pixel & 0xFF0000) >> 16) + (long)(587 * (g = (pixel & 0xFF00) >> 8)) + (long)(114 * (b = pixel & 0xFF))) / 1000L) < 128L) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }

    public static int getBrightness(int rgb) {
        if ((rgb & 0xFFFFFF) != 0) {
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            return (int)((299L * (long)r + (long)(587 * g) + (long)(114 * b)) / 1000L);
        }
        return 0;
    }

    public static RGB intToRgb(int rgb) {
        return new RGB((rgb & 0xFF0000) >>> 16, (rgb & 0xFF00) >>> 8, rgb & 0xFF);
    }

    public static int rgbToInt(RGB rgb, int alpha) {
        return alpha << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue;
    }

    public static BufferedImage cropBlank(BufferedImage image, Rect initialCrop) {
        return ImageUtils.cropBlank(image, initialCrop, image.getType());
    }

    public static BufferedImage cropBlank(BufferedImage image, Rect initialCrop, int imageType) {
        CropFilter filter = new CropFilter(){

            @Override
            public boolean crop(BufferedImage bufferedImage, int x, int y) {
                int rgb = bufferedImage.getRGB(x, y);
                return (rgb & 0xFF000000) == 0;
            }
        };
        return ImageUtils.crop(image, filter, initialCrop, imageType);
    }

    public static BufferedImage cropColor(BufferedImage image, int blankArgb, Rect initialCrop) {
        return ImageUtils.cropColor(image, blankArgb, initialCrop, image.getType());
    }

    public static BufferedImage cropColor(BufferedImage image, final int blankArgb, Rect initialCrop, int imageType) {
        CropFilter filter = new CropFilter(){

            @Override
            public boolean crop(BufferedImage bufferedImage, int x, int y) {
                return blankArgb == bufferedImage.getRGB(x, y);
            }
        };
        return ImageUtils.crop(image, filter, initialCrop, imageType);
    }

    /*
     * Unable to fully structure code
     */
    private static BufferedImage crop(BufferedImage image, CropFilter filter, Rect initialCrop, int imageType) {
        if (image == null) {
            return null;
        }
        if (initialCrop != null) {
            x1 = initialCrop.x;
            y1 = initialCrop.y;
            x2 = initialCrop.x + initialCrop.w;
            y2 = initialCrop.y + initialCrop.h;
        } else {
            x1 = 0;
            y1 = 0;
            x2 = image.getWidth();
            y2 = image.getHeight();
        }
        if (x1 != x2 && y1 != y2) ** GOTO lbl21
        return null;
lbl-1000:
        // 1 sources

        {
            x = x1;
            while (x < x2) {
                if (!filter.crop(image, x, y1)) break block0;
                ++x;
            }
            ++y1;
lbl21:
            // 2 sources

            ** while (y1 < y2)
        }
lbl22:
        // 2 sources

        if (y1 != image.getHeight()) ** GOTO lbl30
        return null;
lbl-1000:
        // 1 sources

        {
            y = y1;
            while (y < y2) {
                if (!filter.crop(image, x1, y)) break block2;
                ++y;
            }
            ++x1;
lbl30:
            // 2 sources

            ** while (x1 < x2)
        }
lbl31:
        // 3 sources

        block4: while (x2 > x1) {
            y = y1;
            while (y < y2) {
                if (!filter.crop(image, x2 - 1, y)) break block4;
                ++y;
            }
            --x2;
        }
        block6: while (y2 > y1) {
            x = x1;
            while (x < x2) {
                if (!filter.crop(image, x, y2 - 1)) break block6;
                ++x;
            }
            --y2;
        }
        if (x1 == 0 && y1 == 0 && x2 == image.getWidth() && y2 == image.getHeight()) {
            return image;
        }
        if (x1 == x2 || y1 == y2) {
            return null;
        }
        width = x2 - x1;
        height = y2 - y1;
        if (imageType == -1) {
            imageType = image.getType();
        }
        if (imageType == 0) {
            imageType = 2;
        }
        cropped = new BufferedImage(width, height, imageType);
        g = cropped.getGraphics();
        g.drawImage(image, 0, 0, width, height, x1, y1, x2, y2, null);
        g.dispose();
        return cropped;
    }

    public static BufferedImage createDropShadow(BufferedImage source, int shadowSize, float shadowOpacity, int shadowRgb) {
        int a;
        int aSum;
        BufferedImage image = new BufferedImage(source.getWidth() + shadowSize * 2, source.getHeight() + shadowSize * 2, 2);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(source, null, shadowSize, shadowSize);
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = shadowSize - 1 >> 1;
        int right = shadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        shadowRgb &= 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        int historyIdx = 0;
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = shadowOpacity / (float)shadowSize;
        int y = 0;
        int bufferOffset = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < shadowSize) {
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++x;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        int x = 0;
        bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < shadowSize) {
                aHistory[y2] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
        g2.drawImage(source, null, 0, 0);
        g2.dispose();
        return image;
    }

    public static BufferedImage createRectangularDropShadow(BufferedImage source) {
        int type = source.getType();
        if (type == 0) {
            type = 2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = new BufferedImage(width + 20, height + 20, type);
        Graphics g = image.getGraphics();
        g.drawImage(source, 0, 0, width, height, null);
        ImageUtils.drawRectangleShadow(image, 0, 0, width, height);
        g.dispose();
        return image;
    }

    public static final void drawRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics gc = image.getGraphics();
        try {
            ImageUtils.drawRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    public static final void drawSmallRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics gc = image.getGraphics();
        try {
            ImageUtils.drawSmallRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    public static final void drawRectangleShadow(Graphics gc, int x, int y, int width, int height) {
        if (sShadowBottomLeft == null) {
            sShadowBottomLeft = ImageUtils.readImage("shadow-bl.png");
            sShadowBottom = ImageUtils.readImage("shadow-b.png");
            sShadowBottomRight = ImageUtils.readImage("shadow-br.png");
            sShadowRight = ImageUtils.readImage("shadow-r.png");
            sShadowTopRight = ImageUtils.readImage("shadow-tr.png");
            assert (sShadowBottomLeft != null);
            assert (sShadowBottomRight.getWidth() == 20);
            assert (sShadowBottomRight.getHeight() == 20);
        }
        int blWidth = sShadowBottomLeft.getWidth();
        int trHeight = sShadowTopRight.getHeight();
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        gc.drawImage(sShadowBottomLeft, x, y + height, null);
        gc.drawImage(sShadowBottomRight, x + width, y + height, null);
        gc.drawImage(sShadowTopRight, x + width, y, null);
        gc.drawImage(sShadowBottom, x + sShadowBottomLeft.getWidth(), y + height, x + width, y + height + sShadowBottom.getHeight(), 0, 0, sShadowBottom.getWidth(), sShadowBottom.getHeight(), null);
        gc.drawImage(sShadowRight, x + width, y + sShadowTopRight.getHeight(), x + width + sShadowRight.getWidth(), y + height, 0, 0, sShadowRight.getWidth(), sShadowRight.getHeight(), null);
    }

    public static final void drawSmallRectangleShadow(Graphics gc, int x, int y, int width, int height) {
        if (sShadow2BottomLeft == null) {
            sShadow2BottomLeft = ImageUtils.readImage("shadow2-bl.png");
            sShadow2Bottom = ImageUtils.readImage("shadow2-b.png");
            sShadow2BottomRight = ImageUtils.readImage("shadow2-br.png");
            sShadow2Right = ImageUtils.readImage("shadow2-r.png");
            sShadow2TopRight = ImageUtils.readImage("shadow2-tr.png");
            assert (sShadow2BottomLeft != null);
            assert (sShadow2TopRight != null);
            assert (sShadow2BottomRight.getWidth() == 10);
            assert (sShadow2BottomRight.getHeight() == 10);
        }
        int blWidth = sShadow2BottomLeft.getWidth();
        int trHeight = sShadow2TopRight.getHeight();
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        gc.drawImage(sShadow2BottomLeft, x, y + height, null);
        gc.drawImage(sShadow2BottomRight, x + width, y + height, null);
        gc.drawImage(sShadow2TopRight, x + width, y, null);
        gc.drawImage(sShadow2Bottom, x + sShadow2BottomLeft.getWidth(), y + height, x + width, y + height + sShadow2Bottom.getHeight(), 0, 0, sShadow2Bottom.getWidth(), sShadow2Bottom.getHeight(), null);
        gc.drawImage(sShadow2Right, x + width, y + sShadow2TopRight.getHeight(), x + width + sShadow2Right.getWidth(), y + height, 0, 0, sShadow2Right.getWidth(), sShadow2Right.getHeight(), null);
    }

    /*
     * Loose catch block
     */
    public static BufferedImage readImage(String name) {
        InputStream stream = ImageUtils.class.getResourceAsStream("/icons/" + name);
        if (stream != null) {
            BufferedImage bufferedImage = ImageIO.read(stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return bufferedImage;
            catch (IOException e) {
                try {
                    AndmoreAndroidPlugin.log(e, "Could not read %1$s", name);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static Rectangle getBoundingRectangle(List<Rectangle> items) {
        Iterator<Rectangle> iterator = items.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Rectangle bounds = iterator.next();
        Rectangle union = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        while (iterator.hasNext()) {
            union.add(iterator.next());
        }
        return union;
    }

    public static BufferedImage subImage(BufferedImage source, int x1, int y1, int x2, int y2) {
        int width = x2 - x1;
        int height = y2 - y1;
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage sub = new BufferedImage(width, height, imageType);
        Graphics g = sub.getGraphics();
        g.drawImage(source, 0, 0, width, height, x1, y1, x2, y2, null);
        g.dispose();
        return sub;
    }

    public static int getColor(String value) {
        if (value != null) {
            if (!value.startsWith("#")) {
                throw new NumberFormatException(String.format("Color value '%s' must start with #", value));
            }
            if ((value = value.substring(1)).length() > 8) {
                throw new NumberFormatException(String.format("Color value '%s' is too long. Format is either#AARRGGBB, #RRGGBB, #RGB, or #ARGB", value));
            }
            if (value.length() == 3) {
                char[] color = new char[8];
                color[1] = 70;
                color[0] = 70;
                color[2] = color[3] = value.charAt(0);
                color[4] = color[5] = value.charAt(1);
                color[6] = color[7] = value.charAt(2);
                value = new String(color);
            } else if (value.length() == 4) {
                char[] color = new char[8];
                color[0] = color[1] = value.charAt(0);
                color[2] = color[3] = value.charAt(1);
                color[4] = color[5] = value.charAt(2);
                color[6] = color[7] = value.charAt(3);
                value = new String(color);
            } else if (value.length() == 6) {
                value = "FF" + value;
            }
            return (int)Long.parseLong(value, 16);
        }
        throw new NumberFormatException();
    }

    public static BufferedImage scale(BufferedImage source, double xScale, double yScale) {
        return ImageUtils.scale(source, xScale, yScale, 0, 0);
    }

    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        if (xScale > 0.5 && yScale > 0.5) {
            BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
            Graphics2D g2 = scaled.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(0, true));
            g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
            g2.dispose();
            return scaled;
        }
        int iterations = 0;
        int nearestWidth = destWidth;
        int nearestHeight = destHeight;
        while (nearestWidth < sourceWidth / 2) {
            nearestWidth *= 2;
            nearestHeight *= 2;
            ++iterations;
        }
        if (iterations == 0) {
            nearestWidth += rightMargin;
            nearestHeight += bottomMargin;
        }
        BufferedImage scaled = new BufferedImage(nearestWidth, nearestHeight, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(source, 0, 0, nearestWidth, nearestHeight, 0, 0, sourceWidth, sourceHeight, null);
        g2.dispose();
        sourceWidth = nearestWidth;
        sourceHeight = nearestHeight;
        source = scaled;
        int iteration = iterations - 1;
        while (iteration >= 0) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            scaled = iteration == 0 ? new BufferedImage(halfWidth + rightMargin, halfHeight + bottomMargin, imageType) : new BufferedImage(halfWidth, halfHeight, imageType);
            g2 = scaled.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(source, 0, 0, halfWidth, halfHeight, 0, 0, sourceWidth, sourceHeight, null);
            g2.dispose();
            sourceWidth = halfWidth;
            sourceHeight = halfHeight;
            source = scaled;
            --iterations;
            --iteration;
        }
        return scaled;
    }

    public static boolean hasImageExtension(String path) {
        return SdkUtils.endsWithIgnoreCase((String)path, (String)".png") || SdkUtils.endsWithIgnoreCase((String)path, (String)".9.png") || SdkUtils.endsWithIgnoreCase((String)path, (String)".gif") || SdkUtils.endsWithIgnoreCase((String)path, (String)".jpg") || SdkUtils.endsWithIgnoreCase((String)path, (String)".bmp");
    }

    public static BufferedImage createColoredImage(int width, int height, RGB color) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics g = image.getGraphics();
        g.setColor(new Color(color.red, color.green, color.blue));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.dispose();
        return image;
    }

    private static interface CropFilter {
        public boolean crop(BufferedImage var1, int var2, int var3);
    }
}

