/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.SdkConstants;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Point;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.RenderSession;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationDescription;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasTransform;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.ClipboardSupport;
import org.eclipse.andmore.internal.editors.layout.gle2.ControlPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.DynamicContextMenu;
import org.eclipse.andmore.internal.editors.layout.gle2.EmptyViewsOverlay;
import org.eclipse.andmore.internal.editors.layout.gle2.ExportScreenshotAction;
import org.eclipse.andmore.internal.editors.layout.gle2.GCWrapper;
import org.eclipse.andmore.internal.editors.layout.gle2.GestureManager;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.HoverOverlay;
import org.eclipse.andmore.internal.editors.layout.gle2.ImageOverlay;
import org.eclipse.andmore.internal.editors.layout.gle2.IncludeFinder;
import org.eclipse.andmore.internal.editors.layout.gle2.IncludeOverlay;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutActionBar;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutWindowCoordinator;
import org.eclipse.andmore.internal.editors.layout.gle2.LintOverlay;
import org.eclipse.andmore.internal.editors.layout.gle2.LintTooltipManager;
import org.eclipse.andmore.internal.editors.layout.gle2.OutlineOverlay;
import org.eclipse.andmore.internal.editors.layout.gle2.OutlinePage;
import org.eclipse.andmore.internal.editors.layout.gle2.PlayAnimationMenu;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderPreview;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderPreviewManager;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionOverlay;
import org.eclipse.andmore.internal.editors.layout.gle2.ShowWithinMenu;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleXmlTransfer;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.andmore.internal.editors.layout.gre.NodeFactory;
import org.eclipse.andmore.internal.editors.layout.gre.RulesEngine;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiDocumentNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.lint.LintEditAction;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.Node;

public class LayoutCanvas
extends Canvas {
    private static final QualifiedName NAME_ZOOM = new QualifiedName("org.eclipse.andmore", "zoom");
    private static final boolean DEBUG = false;
    static final String PREFIX_CANVAS_ACTION = "canvas_action_";
    private final LayoutEditorDelegate mEditorDelegate;
    private RulesEngine mRulesEngine;
    private GCWrapper mGCWrapper;
    private Font mFont;
    private CanvasViewInfo mHoverViewInfo;
    private boolean mShowOutline;
    private boolean mShowInvisible;
    private DropTarget mDropTarget;
    private final NodeFactory mNodeFactory = new NodeFactory(this);
    private final CanvasTransform mVScale;
    private final CanvasTransform mHScale;
    private DragSource mDragSource;
    private OutlinePage mOutlinePage;
    private Action mDeleteAction;
    private Action mSelectAllAction;
    private Action mPasteAction;
    private Action mCutAction;
    private Action mCopyAction;
    private IAction mUndoAction;
    private IAction mRedoAction;
    private MenuManager mMenuManager;
    private final ViewHierarchy mViewHierarchy = new ViewHierarchy(this);
    private final SelectionManager mSelectionManager = new SelectionManager(this);
    private OutlineOverlay mOutlineOverlay;
    private EmptyViewsOverlay mEmptyOverlay;
    private HoverOverlay mHoverOverlay;
    private LintOverlay mLintOverlay;
    private SelectionOverlay mSelectionOverlay;
    private ImageOverlay mImageOverlay;
    private IncludeOverlay mIncludeOverlay;
    private final RenderPreviewManager mPreviewManager;
    private final GestureManager mGestureManager = new GestureManager(this);
    private boolean mZoomFitNextImage;
    private ClipboardSupport mClipboardSupport;
    private LintTooltipManager mLintTooltipManager;
    private Color mBackgroundColor;
    private Runnable mZoomCheck = new Runnable(){
        private Boolean mWasZoomed;

        @Override
        public void run() {
            Boolean zoomed;
            LayoutWindowCoordinator coordinator;
            if (LayoutCanvas.this.isDisposed()) {
                return;
            }
            IEditorSite editorSite = LayoutCanvas.this.getEditorDelegate().getEditor().getEditorSite();
            IWorkbenchWindow window = editorSite.getWorkbenchWindow();
            if (window != null && (coordinator = LayoutWindowCoordinator.get(window, false)) != null && this.mWasZoomed != (zoomed = Boolean.valueOf(coordinator.isEditorMaximized()))) {
                LayoutActionBar actionBar;
                if (this.mWasZoomed != null && (actionBar = LayoutCanvas.this.getGraphicalEditor().getLayoutActionBar()).isZoomingAllowed()) {
                    LayoutCanvas.this.setFitScale(true, true);
                }
                this.mWasZoomed = zoomed;
            }
        }
    };
    private RenderPreview mPreview;

    public LayoutCanvas(LayoutEditorDelegate editorDelegate, RulesEngine rulesEngine, Composite parent, int style) {
        super(parent, style | 0x20000000 | 0x200 | 0x100);
        IFile file;
        this.mEditorDelegate = editorDelegate;
        this.mRulesEngine = rulesEngine;
        this.mBackgroundColor = new Color((Device)parent.getDisplay(), 150, 150, 150);
        this.setBackground(this.mBackgroundColor);
        this.mClipboardSupport = new ClipboardSupport(this, parent);
        this.mHScale = new CanvasTransform(this, this.getHorizontalBar());
        this.mVScale = new CanvasTransform(this, this.getVerticalBar());
        this.mPreviewManager = new RenderPreviewManager(this);
        IFile iFile = file = editorDelegate != null ? editorDelegate.getEditor().getInputFile() : null;
        if (file != null) {
            String zoom = AndmoreAndroidPlugin.getFileProperty(file, NAME_ZOOM);
            if (zoom != null) {
                try {
                    double initialScale = Double.parseDouble(zoom);
                    if (initialScale > 0.1) {
                        this.mHScale.setScale(initialScale);
                        this.mVScale.setScale(initialScale);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.mZoomFitNextImage = true;
            }
        }
        this.mGCWrapper = new GCWrapper(this.mHScale, this.mVScale);
        Display display = this.getDisplay();
        this.mFont = display.getSystemFont();
        this.mHoverOverlay = new HoverOverlay(this, this.mHScale, this.mVScale);
        this.mHoverOverlay.create((Device)display);
        this.mSelectionOverlay = new SelectionOverlay(this);
        this.mSelectionOverlay.create((Device)display);
        this.mImageOverlay = new ImageOverlay(this, this.mHScale, this.mVScale);
        this.mIncludeOverlay = new IncludeOverlay(this);
        this.mImageOverlay.create((Device)display);
        this.mLintOverlay = new LintOverlay(this);
        this.mLintOverlay.create((Device)display);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                LayoutCanvas.this.onPaint(e);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
                LayoutWindowCoordinator coordinator = null;
                IEditorSite editorSite = LayoutCanvas.this.getEditorDelegate().getEditor().getEditorSite();
                IWorkbenchWindow window = editorSite.getWorkbenchWindow();
                if (window != null && (coordinator = LayoutWindowCoordinator.get(window, false)) != null) {
                    coordinator.syncMaximizedState(editorSite.getPage());
                }
                LayoutCanvas.this.updateScrollBars();
                if (coordinator != null) {
                    LayoutCanvas.this.mZoomCheck.run();
                } else {
                    LayoutCanvas.this.getDisplay().asyncExec(LayoutCanvas.this.mZoomCheck);
                }
            }
        });
        this.mDropTarget = LayoutCanvas.createDropTarget((Control)this);
        this.mDragSource = LayoutCanvas.createDragSource((Control)this);
        this.mGestureManager.registerListeners(this.mDragSource, this.mDropTarget);
        if (this.mEditorDelegate == null) {
            return;
        }
        this.setupGlobalActionHandlers();
        this.createContextMenu();
        if (editorDelegate != null) {
            this.mOutlinePage = editorDelegate.getGraphicalOutline();
        }
        this.mLintTooltipManager = new LintTooltipManager(this);
        this.mLintTooltipManager.register();
    }

    void updateScrollBars() {
        Rectangle clientArea = this.getClientArea();
        Image image = this.mImageOverlay.getImage();
        if (image != null) {
            org.eclipse.swt.graphics.Point size;
            Shell shell;
            ImageData imageData = image.getImageData();
            int clientWidth = clientArea.width;
            int clientHeight = clientArea.height;
            int imageWidth = imageData.width;
            int imageHeight = imageData.height;
            int fullWidth = imageWidth;
            int fullHeight = imageHeight;
            if (this.mPreviewManager.hasPreviews()) {
                fullHeight = Math.max(fullHeight, (int)((double)this.mPreviewManager.getHeight() / this.mHScale.getScale()));
            }
            if (clientWidth == 0) {
                clientWidth = imageWidth;
                shell = this.getShell();
                if (shell != null) {
                    size = shell.getSize();
                    if (size.x > 0) {
                        clientWidth = size.x * 70 / 100;
                    }
                }
            }
            if (clientHeight == 0) {
                clientHeight = imageHeight;
                shell = this.getShell();
                if (shell != null) {
                    size = shell.getSize();
                    if (size.y > 0) {
                        clientWidth = size.y * 80 / 100;
                    }
                }
            }
            this.mHScale.setSize(imageWidth, fullWidth, clientWidth);
            this.mVScale.setSize(imageHeight, fullHeight, clientHeight);
        }
    }

    void handleKeyPressed(KeyEvent e) {
        if (e.keyCode == 8) {
            this.mDeleteAction.run();
        } else if (e.keyCode == 27) {
            this.mSelectionManager.selectParent();
        } else if (e.keyCode == DynamicContextMenu.DEFAULT_ACTION_KEY) {
            this.mSelectionManager.performDefaultAction();
        } else if (e.keyCode == 114) {
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                if ((e.stateMask & (SWT.MOD1 | SWT.MOD3)) == (SWT.MOD1 | SWT.MOD3)) {
                    this.mSelectionManager.performRename();
                }
            } else if ((e.stateMask & (SWT.MOD2 | SWT.MOD3)) == (SWT.MOD2 | SWT.MOD3)) {
                this.mSelectionManager.performRename();
            }
        } else {
            char c = e.character;
            LayoutActionBar actionBar = this.getGraphicalEditor().getLayoutActionBar();
            if (c == '1' && actionBar.isZoomingAllowed()) {
                this.setScale(1.0, true);
            } else if (c == '0' && actionBar.isZoomingAllowed()) {
                this.setFitScale(true, true);
            } else if (e.keyCode == 48 && (e.stateMask & SWT.MOD2) != 0 && actionBar.isZoomingAllowed()) {
                this.setFitScale(false, true);
            } else if ((c == '+' || c == '=') && actionBar.isZoomingAllowed()) {
                if ((e.stateMask & SWT.MOD1) != 0) {
                    this.mPreviewManager.zoomIn();
                } else {
                    actionBar.rescale(1);
                }
            } else if (c == '-' && actionBar.isZoomingAllowed()) {
                if ((e.stateMask & SWT.MOD1) != 0) {
                    this.mPreviewManager.zoomOut();
                } else {
                    actionBar.rescale(-1);
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.mGestureManager.unregisterListeners(this.mDragSource, this.mDropTarget);
        if (this.mLintTooltipManager != null) {
            this.mLintTooltipManager.unregister();
            this.mLintTooltipManager = null;
        }
        if (this.mDropTarget != null) {
            this.mDropTarget.dispose();
            this.mDropTarget = null;
        }
        if (this.mRulesEngine != null) {
            this.mRulesEngine.dispose();
            this.mRulesEngine = null;
        }
        if (this.mDragSource != null) {
            this.mDragSource.dispose();
            this.mDragSource = null;
        }
        if (this.mClipboardSupport != null) {
            this.mClipboardSupport.dispose();
            this.mClipboardSupport = null;
        }
        if (this.mGCWrapper != null) {
            this.mGCWrapper.dispose();
            this.mGCWrapper = null;
        }
        if (this.mOutlineOverlay != null) {
            this.mOutlineOverlay.dispose();
            this.mOutlineOverlay = null;
        }
        if (this.mEmptyOverlay != null) {
            this.mEmptyOverlay.dispose();
            this.mEmptyOverlay = null;
        }
        if (this.mHoverOverlay != null) {
            this.mHoverOverlay.dispose();
            this.mHoverOverlay = null;
        }
        if (this.mSelectionOverlay != null) {
            this.mSelectionOverlay.dispose();
            this.mSelectionOverlay = null;
        }
        if (this.mImageOverlay != null) {
            this.mImageOverlay.dispose();
            this.mImageOverlay = null;
        }
        if (this.mIncludeOverlay != null) {
            this.mIncludeOverlay.dispose();
            this.mIncludeOverlay = null;
        }
        if (this.mLintOverlay != null) {
            this.mLintOverlay.dispose();
            this.mLintOverlay = null;
        }
        if (this.mBackgroundColor != null) {
            this.mBackgroundColor.dispose();
            this.mBackgroundColor = null;
        }
        this.mPreviewManager.disposePreviews();
        this.mViewHierarchy.dispose();
    }

    public RenderPreviewManager getPreviewManager() {
        return this.mPreviewManager;
    }

    RulesEngine getRulesEngine() {
        return this.mRulesEngine;
    }

    void setRulesEngine(RulesEngine rulesEngine) {
        this.mRulesEngine = rulesEngine;
    }

    public NodeFactory getNodeFactory() {
        return this.mNodeFactory;
    }

    GCWrapper getGcWrapper() {
        return this.mGCWrapper;
    }

    public LayoutEditorDelegate getEditorDelegate() {
        return this.mEditorDelegate;
    }

    ImageOverlay getImageOverlay() {
        return this.mImageOverlay;
    }

    SelectionOverlay getSelectionOverlay() {
        return this.mSelectionOverlay;
    }

    GestureManager getGestureManager() {
        return this.mGestureManager;
    }

    HoverOverlay getHoverOverlay() {
        return this.mHoverOverlay;
    }

    CanvasTransform getHorizontalTransform() {
        return this.mHScale;
    }

    CanvasTransform getVerticalTransform() {
        return this.mVScale;
    }

    public OutlinePage getOutlinePage() {
        return this.mOutlinePage;
    }

    public SelectionManager getSelectionManager() {
        return this.mSelectionManager;
    }

    public ViewHierarchy getViewHierarchy() {
        return this.mViewHierarchy;
    }

    public ClipboardSupport getClipboardSupport() {
        return this.mClipboardSupport;
    }

    Action getSelectAllAction() {
        return this.mSelectAllAction;
    }

    GraphicalEditorPart getGraphicalEditor() {
        return this.mEditorDelegate.getGraphicalEditor();
    }

    void setSession(RenderSession session, Set<UiElementNode> explodedNodes, boolean layoutlib5) {
        this.clearHover();
        this.mViewHierarchy.setSession(session, explodedNodes, layoutlib5);
        if (this.mViewHierarchy.isValid() && session != null) {
            Image image = this.mImageOverlay.setImage(session.getImage(), session.isAlphaChannelImage());
            this.mOutlinePage.setModel(this.mViewHierarchy.getRoot());
            this.getGraphicalEditor().setModel(this.mViewHierarchy.getRoot());
            if (image != null) {
                this.updateScrollBars();
                if (this.mZoomFitNextImage) {
                    this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!LayoutCanvas.this.isDisposed()) {
                                LayoutCanvas.this.ensureZoomed();
                            }
                        }
                    });
                }
                this.syncPreviewMode();
            }
        }
        this.redraw();
    }

    void ensureZoomed() {
        if (this.mZoomFitNextImage && this.getClientArea().height > 0) {
            this.mZoomFitNextImage = false;
            LayoutActionBar actionBar = this.getGraphicalEditor().getLayoutActionBar();
            if (actionBar.isZoomingAllowed()) {
                this.setFitScale(true, true);
            }
        }
    }

    void setShowOutline(boolean newState) {
        this.mShowOutline = newState;
        this.redraw();
    }

    public double getScale() {
        return this.mHScale.getScale();
    }

    void setScale(double scale, boolean redraw) {
        if (scale <= 0.0) {
            scale = 1.0;
        }
        if (scale == this.getScale()) {
            return;
        }
        this.mHScale.setScale(scale);
        this.mVScale.setScale(scale);
        if (redraw) {
            this.redraw();
        }
        String zoomValue = Math.abs(scale - 1.0) < 1.0E-4 ? null : Double.toString(scale);
        IFile file = this.mEditorDelegate.getEditor().getInputFile();
        if (file != null) {
            AndmoreAndroidPlugin.setFileProperty(file, NAME_ZOOM, zoomValue);
        }
    }

    public void setFitScale(boolean onlyZoomOut, boolean allowZoomIn) {
        ImageOverlay imageOverlay = this.getImageOverlay();
        if (imageOverlay == null) {
            return;
        }
        Image image = imageOverlay.getImage();
        if (image != null) {
            Rectangle canvasSize = this.getClientArea();
            int canvasWidth = canvasSize.width;
            int canvasHeight = canvasSize.height;
            boolean hasPreviews = this.mPreviewManager.hasPreviews();
            if (hasPreviews) {
                canvasWidth = 2 * canvasWidth / 3;
            } else {
                canvasWidth -= 4;
                canvasHeight -= 4;
            }
            ImageData imageData = image.getImageData();
            int sceneWidth = imageData.width;
            int sceneHeight = imageData.height;
            if ((double)sceneWidth == 0.0 || (double)sceneHeight == 0.0) {
                return;
            }
            if (imageOverlay.getShowDropShadow()) {
                sceneWidth += 40;
                sceneHeight += 40;
            }
            int hDelta = canvasWidth - sceneWidth;
            int hMargin = 0;
            if (hDelta > 50) {
                hMargin = 25;
            } else if (hDelta > 0) {
                hMargin = hDelta / 2;
            }
            int vDelta = canvasHeight - sceneHeight;
            int vMargin = 0;
            if (vDelta > 50) {
                vMargin = 25;
            } else if (vDelta > 0) {
                vMargin = vDelta / 2;
            }
            double hScale = (double)(canvasWidth - 2 * hMargin) / (double)sceneWidth;
            double vScale = (double)(canvasHeight - 2 * vMargin) / (double)sceneHeight;
            double scale = Math.min(hScale, vScale);
            if (onlyZoomOut) {
                scale = Math.min(1.0, scale);
            }
            if (!allowZoomIn && scale > this.getScale()) {
                return;
            }
            this.setScale(scale, true);
        }
    }

    Point layoutToControlPoint(int canvasX, int canvasY) {
        int x = this.mHScale.translate(canvasX);
        int y = this.mVScale.translate(canvasY);
        return new Point(x, y);
    }

    IAction getAction(String actionId) {
        String prefix = PREFIX_CANVAS_ACTION;
        if (this.mMenuManager == null || actionId == null || !actionId.startsWith(prefix)) {
            return null;
        }
        actionId = actionId.substring(prefix.length());
        IContributionItem[] iContributionItemArray = this.mMenuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contrib = iContributionItemArray[n2];
            if (contrib instanceof ActionContributionItem && actionId.equals(contrib.getId())) {
                return ((ActionContributionItem)contrib).getAction();
            }
            ++n2;
        }
        return null;
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        gc.setFont(this.mFont);
        this.mGCWrapper.setGC(gc);
        try {
            if (!this.mImageOverlay.isHiding()) {
                this.mImageOverlay.paint(gc);
            }
            this.mPreviewManager.paint(gc);
            if (this.mShowOutline) {
                if (this.mOutlineOverlay == null) {
                    this.mOutlineOverlay = new OutlineOverlay(this.mViewHierarchy, this.mHScale, this.mVScale);
                    this.mOutlineOverlay.create((Device)this.getDisplay());
                }
                if (!this.mOutlineOverlay.isHiding()) {
                    this.mOutlineOverlay.paint(gc);
                }
            }
            if (this.mShowInvisible) {
                if (this.mEmptyOverlay == null) {
                    this.mEmptyOverlay = new EmptyViewsOverlay(this.mViewHierarchy, this.mHScale, this.mVScale);
                    this.mEmptyOverlay.create((Device)this.getDisplay());
                }
                if (!this.mEmptyOverlay.isHiding()) {
                    this.mEmptyOverlay.paint(gc);
                }
            }
            if (!this.mHoverOverlay.isHiding()) {
                this.mHoverOverlay.paint(gc);
            }
            if (!this.mLintOverlay.isHiding()) {
                this.mLintOverlay.paint(gc);
            }
            if (!this.mIncludeOverlay.isHiding()) {
                this.mIncludeOverlay.paint(gc);
            }
            if (!this.mSelectionOverlay.isHiding()) {
                this.mSelectionOverlay.paint(this.mSelectionManager, this.mGCWrapper, gc, this.mRulesEngine);
            }
            this.mGestureManager.paint(gc);
        }
        finally {
            this.mGCWrapper.setGC(null);
        }
    }

    void showInvisibleViews(boolean show) {
        if (this.mShowInvisible == show) {
            return;
        }
        this.mShowInvisible = show;
        if (show && !this.mViewHierarchy.hasInvisibleParents()) {
            return;
        }
        if (!show && !this.mViewHierarchy.hasExplodedParents()) {
            return;
        }
        this.mEditorDelegate.recomputeLayout();
    }

    public Set<UiElementNode> getNodesToExplode() {
        List<CanvasViewInfo> invisibleParents;
        if (this.mShowInvisible) {
            return this.mViewHierarchy.getInvisibleNodes();
        }
        HashSet<UiViewElementNode> result = null;
        List<SelectionItem> selections = this.mSelectionManager.getSelections();
        if (selections.size() > 0 && (invisibleParents = this.mViewHierarchy.getInvisibleViews()).size() > 0) {
            for (SelectionItem item : selections) {
                UiViewElementNode node;
                CanvasViewInfo viewInfo = item.getViewInfo();
                if (!invisibleParents.contains(viewInfo) || (node = viewInfo.getUiViewNode()) == null) continue;
                if (result == null) {
                    result = new HashSet<UiViewElementNode>();
                }
                result.add(node);
            }
        }
        return result;
    }

    void clearHover() {
        this.mHoverOverlay.clearHover();
    }

    void hover(MouseEvent e) {
        if ((e.stateMask & SWT.BUTTON_MASK) != 0) {
            this.clearHover();
            return;
        }
        LayoutPoint p = ControlPoint.create(this, e).toLayout();
        CanvasViewInfo vi = this.mViewHierarchy.findViewInfoAt(p);
        if (vi != null && (vi.isRoot() || vi.isHidden())) {
            vi = null;
        }
        boolean needsUpdate = vi != this.mHoverViewInfo;
        this.mHoverViewInfo = vi;
        if (vi == null) {
            this.clearHover();
        } else {
            Rectangle r = vi.getSelectionRect();
            this.mHoverOverlay.setHover(r.x, r.y, r.width, r.height);
        }
        if (needsUpdate) {
            this.redraw();
        }
    }

    public void show(CanvasViewInfo vi) {
        String url = vi.getIncludeUrl();
        if (url != null) {
            this.showInclude(url);
        } else {
            this.showXml(vi);
        }
    }

    private void showInclude(String url) {
        IFileStore fileStore;
        GraphicalEditorPart graphicalEditor = this.getGraphicalEditor();
        IPath filePath = graphicalEditor.findResourceFile(url);
        if (filePath == null) {
            return;
        }
        IEditorSite editorSite = graphicalEditor.getEditorSite();
        IWorkbenchPage page = editorSite.getPage();
        page.saveEditor((IEditorPart)this.mEditorDelegate.getEditor(), false);
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IFile xmlFile = null;
        IPath workspacePath = workspace.getLocation();
        if (workspacePath.isPrefixOf(filePath)) {
            IPath relativePath = filePath.makeRelativeTo(workspacePath);
            xmlFile = (IFile)workspace.findMember(relativePath);
        } else if (filePath.isAbsolute()) {
            xmlFile = workspace.getFileForLocation(filePath);
        }
        if (xmlFile != null) {
            IFile leavingFile = graphicalEditor.getEditedFile();
            IncludeFinder.Reference next = IncludeFinder.Reference.create(graphicalEditor.getEditedFile());
            try {
                IEditorPart openAlready = EditorUtility.isOpenInEditor((Object)xmlFile);
                if (openAlready != null) {
                    GraphicalEditorPart gEditor;
                    LayoutEditorDelegate delegate = LayoutEditorDelegate.fromEditor(openAlready);
                    if (delegate != null && (gEditor = delegate.getGraphicalEditor()) != null && gEditor.renderingSupports(Capability.EMBEDDED_LAYOUT)) {
                        gEditor.showIn(next);
                    }
                } else {
                    try {
                        String state = ConfigurationDescription.getDescription(leavingFile);
                        xmlFile.setSessionProperty(GraphicalEditorPart.NAME_INITIAL_STATE, (Object)state);
                    }
                    catch (CoreException coreException) {}
                    if (graphicalEditor.renderingSupports(Capability.EMBEDDED_LAYOUT)) {
                        try {
                            xmlFile.setSessionProperty(GraphicalEditorPart.NAME_INCLUDE, (Object)next);
                        }
                        catch (CoreException coreException) {}
                    }
                }
                EditorUtility.openInEditor((Object)xmlFile, (boolean)true);
                return;
            }
            catch (PartInitException ex) {
                AndmoreAndroidPlugin.log(ex, "Can't open %$1s", url);
            }
        } else if (filePath.isAbsolute() && !(fileStore = EFS.getLocalFileSystem().getStore(filePath)).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                return;
            }
            catch (PartInitException ex) {
                AndmoreAndroidPlugin.log(ex, "Can't open %$1s", url);
            }
        }
        String message = String.format("Could not find resource %1$s", url);
        IStatusLineManager status = editorSite.getActionBars().getStatusLineManager();
        status.setErrorMessage(message);
        this.getDisplay().beep();
    }

    public String getLayoutResourceName() {
        GraphicalEditorPart graphicalEditor = this.getGraphicalEditor();
        return graphicalEditor.getLayoutResourceName();
    }

    private void showXml(CanvasViewInfo vi) {
        boolean found;
        if (vi.isRoot()) {
            return;
        }
        Node xmlNode = vi.getXmlNode();
        if (xmlNode != null && !(found = this.mEditorDelegate.getEditor().show(xmlNode))) {
            this.getDisplay().beep();
        }
    }

    static DragSource createDragSource(Control control) {
        DragSource source = new DragSource(control, 3);
        source.setTransfer(new Transfer[]{TextTransfer.getInstance(), SimpleXmlTransfer.getInstance()});
        return source;
    }

    private static DropTarget createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 19);
        dropTarget.setTransfer(new Transfer[]{SimpleXmlTransfer.getInstance()});
        return dropTarget;
    }

    private void setupGlobalActionHandlers() {
        this.mCutAction = new Action(){

            public void run() {
                LayoutCanvas.this.mClipboardSupport.cutSelectionToClipboard(LayoutCanvas.this.mSelectionManager.getSnapshot());
                LayoutCanvas.this.updateMenuActionState();
            }
        };
        this.copyActionAttributes(this.mCutAction, ActionFactory.CUT);
        this.mCopyAction = new Action(){

            public void run() {
                LayoutCanvas.this.mClipboardSupport.copySelectionToClipboard(LayoutCanvas.this.mSelectionManager.getSnapshot());
                LayoutCanvas.this.updateMenuActionState();
            }
        };
        this.copyActionAttributes(this.mCopyAction, ActionFactory.COPY);
        this.mPasteAction = new Action(){

            public void run() {
                LayoutCanvas.this.mClipboardSupport.pasteSelection(LayoutCanvas.this.mSelectionManager.getSnapshot());
                LayoutCanvas.this.updateMenuActionState();
            }
        };
        this.copyActionAttributes(this.mPasteAction, ActionFactory.PASTE);
        this.mDeleteAction = new Action(){

            public void run() {
                LayoutCanvas.this.mClipboardSupport.deleteSelection(LayoutCanvas.this.getDeleteLabel(), LayoutCanvas.this.mSelectionManager.getSnapshot());
            }
        };
        this.copyActionAttributes(this.mDeleteAction, ActionFactory.DELETE);
        this.mSelectAllAction = new Action(){

            public void run() {
                GraphicalEditorPart graphicalEditor = LayoutCanvas.this.getEditorDelegate().getGraphicalEditor();
                StyledText errorLabel = graphicalEditor.getErrorLabel();
                if (errorLabel.isFocusControl()) {
                    errorLabel.selectAll();
                    return;
                }
                LayoutCanvas.this.mSelectionManager.selectAll();
            }
        };
        this.copyActionAttributes(this.mSelectAllAction, ActionFactory.SELECT_ALL);
    }

    String getCutLabel() {
        return this.mCutAction.getText();
    }

    String getDeleteLabel() {
        return this.mDeleteAction.getText();
    }

    void updateMenuActionState() {
        boolean hasSelection;
        List<SelectionItem> selections = this.getSelectionManager().getSelections();
        boolean bl = hasSelection = !selections.isEmpty();
        if (hasSelection && selections.size() == 1 && selections.get(0).isRoot()) {
            hasSelection = false;
        }
        StyledText errorLabel = this.getGraphicalEditor().getErrorLabel();
        this.mCutAction.setEnabled(hasSelection);
        this.mCopyAction.setEnabled(hasSelection || errorLabel.getSelectionCount() > 0);
        this.mDeleteAction.setEnabled(hasSelection);
        this.mSelectAllAction.setEnabled(true);
        boolean hasSxt = this.mClipboardSupport.hasSxtOnClipboard();
        this.mPasteAction.setEnabled(hasSxt);
    }

    public void updateGlobalActions(IActionBars bars) {
        boolean graphical;
        this.updateMenuActionState();
        StructuredTextEditor editor = this.mEditorDelegate.getEditor().getStructuredTextEditor();
        boolean bl = graphical = this.getEditorDelegate().getEditor().getActivePage() == 0;
        if (graphical) {
            bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.mCutAction);
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.mCopyAction);
            bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.mPasteAction);
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.mDeleteAction);
            bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.mSelectAllAction);
            if (this.mUndoAction == null) {
                IAction undoAction = editor.getAction(ActionFactory.UNDO.getId());
                this.mUndoAction = new LintEditAction(undoAction, this.getEditorDelegate().getEditor());
            }
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.mUndoAction);
            if (this.mRedoAction == null) {
                IAction redoAction = editor.getAction(ActionFactory.REDO.getId());
                this.mRedoAction = new LintEditAction(redoAction, this.getEditorDelegate().getEditor());
            }
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.mRedoAction);
        } else {
            bars.setGlobalActionHandler(ActionFactory.CUT.getId(), editor.getAction(ActionFactory.CUT.getId()));
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), editor.getAction(ActionFactory.COPY.getId()));
            bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), editor.getAction(ActionFactory.PASTE.getId()));
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), editor.getAction(ActionFactory.DELETE.getId()));
            bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), editor.getAction(ActionFactory.SELECT_ALL.getId()));
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), editor.getAction(ActionFactory.UNDO.getId()));
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), editor.getAction(ActionFactory.REDO.getId()));
        }
        bars.updateActionBars();
    }

    private void copyActionAttributes(Action action, ActionFactory factory) {
        ActionFactory.IWorkbenchAction wa = factory.create(this.mEditorDelegate.getEditor().getEditorSite().getWorkbenchWindow());
        action.setId(wa.getId());
        action.setText(wa.getText());
        action.setEnabled(wa.isEnabled());
        action.setDescription(wa.getDescription());
        action.setToolTipText(wa.getToolTipText());
        action.setAccelerator(wa.getAccelerator());
        action.setActionDefinitionId(wa.getActionDefinitionId());
        action.setImageDescriptor(wa.getImageDescriptor());
        action.setHoverImageDescriptor(wa.getHoverImageDescriptor());
        action.setDisabledImageDescriptor(wa.getDisabledImageDescriptor());
        action.setHelpListener(wa.getHelpListener());
    }

    private void createContextMenu() {
        this.mMenuManager = new MenuManager(){

            public boolean isDynamic() {
                return true;
            }
        };
        this.setupStaticMenuActions((IMenuManager)this.mMenuManager);
        new DynamicContextMenu(this.mEditorDelegate, this, this.mMenuManager);
        Menu menu = this.mMenuManager.createContextMenu((Control)this);
        this.setMenu(menu);
        this.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                LayoutCanvas.this.mSelectionManager.menuClick(e);
            }
        });
    }

    private void setupStaticMenuActions(IMenuManager manager) {
        manager.removeAll();
        manager.add((IAction)new SelectionManager.SelectionMenu(this.getGraphicalEditor()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mCutAction);
        manager.add((IAction)this.mCopyAction);
        manager.add((IAction)this.mPasteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mDeleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new PlayAnimationMenu(this));
        manager.add((IAction)new ExportScreenshotAction(this));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ShowWithinMenu(this.mEditorDelegate));
        String showInLabel = IDEWorkbenchMessages.Workbench_showIn;
        MenuManager showInSubMenu = new MenuManager(showInLabel);
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.mEditorDelegate.getEditor().getSite().getWorkbenchWindow()));
        manager.add((IContributionItem)showInSubMenu);
    }

    void delete() {
        this.mDeleteAction.run();
    }

    void createDocumentRoot(final SimpleElement root) {
        String rootFqcn = root.getFqcn();
        final UiDocumentNode uiDoc = this.mEditorDelegate.getUiRootNode();
        if (uiDoc == null || uiDoc.getUiChildren().size() > 0) {
            this.debugPrintf("Failed to create document root for %1$s: document is not empty", rootFqcn);
            return;
        }
        final ViewElementDescriptor viewDesc = this.mEditorDelegate.getFqcnViewDescriptor(rootFqcn);
        if (viewDesc == null) {
            this.debugPrintf("Failed to add document root, unknown FQCN %1$s", rootFqcn);
            return;
        }
        String title = rootFqcn;
        int pos = title.lastIndexOf(46);
        if (pos > 0 && pos < title.length() - 1) {
            title = title.substring(pos + 1);
        }
        title = String.format("Create root %1$s in document", title);
        this.mEditorDelegate.getEditor().wrapUndoEditXmlModel(title, new Runnable(){

            @Override
            public void run() {
                UiElementNode uiNew = uiDoc.appendNewUiChild(viewDesc);
                uiNew.setAttributeValue("android", "http://www.w3.org/2000/xmlns/", "http://schemas.android.com/apk/res/android", true);
                IDragElement.IDragAttribute[] attributes = root.getAttributes();
                if (attributes != null) {
                    IDragElement.IDragAttribute[] iDragAttributeArray = attributes;
                    int n = attributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDragElement.IDragAttribute attribute = iDragAttributeArray[n2];
                        String uri = attribute.getUri();
                        String name = attribute.getName();
                        String value = attribute.getValue();
                        uiNew.setAttributeValue(name, uri, value, false);
                        ++n2;
                    }
                }
                DescriptorsUtils.setDefaultLayoutAttributes(uiNew, false);
                uiNew.createXmlNode();
            }
        });
    }

    public Margins getInsets(String fqcn) {
        return null;
    }

    private void debugPrintf(String message, Object ... params) {
    }

    public void deactivated() {
        if (this.mLintTooltipManager != null) {
            this.mLintTooltipManager.hide();
        }
    }

    public void setPreview(RenderPreview preview) {
        this.mPreview = preview;
    }

    public RenderPreview getPreview() {
        return this.mPreview;
    }

    public void syncPreviewMode() {
        if (this.mImageOverlay != null && this.mImageOverlay.getImage() != null && this.getGraphicalEditor().getConfigurationChooser().getResources() != null && this.mPreviewManager.recomputePreviews(false)) {
            this.mZoomFitNextImage = true;
            this.ensureZoomed();
        }
    }
}

