/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.CustomViewFinder;
import org.eclipse.andmore.internal.editors.layout.gre.PaletteMetadataDescriptor;
import org.eclipse.andmore.internal.editors.layout.gre.ViewMetadataRepository;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoringWizard;
import org.eclipse.andmore.internal.editors.layout.refactoring.WrapInRefactoring;
import org.eclipse.andmore.internal.resources.ResourceNameValidator;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WrapInWizard
extends VisualRefactoringWizard {
    private static final String SEPARATOR_LABEL = "----------------------------------------";

    public WrapInWizard(WrapInRefactoring ref, LayoutEditorDelegate editor) {
        super(ref, editor);
        this.setDefaultPageTitle("Wrap in Container");
    }

    protected void addUserInputPages() {
        WrapInRefactoring ref = (WrapInRefactoring)this.getRefactoring();
        String oldType = ref.getOldType();
        this.addPage((IWizardPage)new InputPage(this.mDelegate.getEditor().getProject(), oldType));
    }

    static List<Pair<String, ViewElementDescriptor>> addLayouts(IProject project, String oldType, Combo combo, Set<String> exclude, boolean addGestureOverlay) {
        Sdk currentSdk;
        ArrayList<Pair<String, ViewElementDescriptor>> classNames = new ArrayList<Pair<String, ViewElementDescriptor>>();
        if (oldType != null && oldType.equals("android.widget.RadioButton")) {
            combo.add("RadioGroup");
            classNames.add(Pair.of((Object)"RadioGroup", null));
            combo.add(SEPARATOR_LABEL);
            classNames.add(Pair.of(null, null));
        }
        Pair<List<String>, List<String>> result = CustomViewFinder.findViews(project, true);
        List customViews = (List)result.getFirst();
        List thirdPartyViews = (List)result.getSecond();
        if (customViews.size() > 0) {
            for (String view : customViews) {
                combo.add(view);
                classNames.add((Pair<String, ViewElementDescriptor>)Pair.of((Object)view, null));
            }
            combo.add(SEPARATOR_LABEL);
            classNames.add((Pair<String, ViewElementDescriptor>)Pair.of(null, null));
        }
        if ((currentSdk = Sdk.getCurrent()) != null) {
            AndroidTargetData targetData;
            IAndroidTarget target = currentSdk.getTarget(project);
            if (target != null && (targetData = currentSdk.getTargetData(target)) != null) {
                String className;
                ViewMetadataRepository repository = ViewMetadataRepository.get();
                List<Pair<String, List<ViewElementDescriptor>>> entries = repository.getPaletteEntries(targetData, false, true);
                List layoutDescriptors = null;
                block1: for (Pair<String, List<ViewElementDescriptor>> pair : entries) {
                    List list = (List)pair.getSecond();
                    for (ViewElementDescriptor d : list) {
                        if (!d.getFullClassName().equals("android.widget.LinearLayout")) continue;
                        layoutDescriptors = list;
                        break block1;
                    }
                }
                if (layoutDescriptors != null) {
                    for (ViewElementDescriptor d : layoutDescriptors) {
                        className = d.getFullClassName();
                        if (exclude != null && exclude.contains(className)) continue;
                        combo.add(d.getUiName());
                        classNames.add((Pair<String, ViewElementDescriptor>)Pair.of((Object)className, (Object)d));
                    }
                    combo.add(SEPARATOR_LABEL);
                    classNames.add(null);
                    if (thirdPartyViews.size() > 0) {
                        for (String view : thirdPartyViews) {
                            combo.add(view);
                            classNames.add((Pair<String, ViewElementDescriptor>)Pair.of((Object)view, null));
                        }
                        combo.add(SEPARATOR_LABEL);
                        classNames.add(null);
                    }
                    if (addGestureOverlay) {
                        combo.add("GestureOverlayView");
                        classNames.add((Pair<String, ViewElementDescriptor>)Pair.of((Object)"android.gesture.GestureOverlayView", null));
                        combo.add(SEPARATOR_LABEL);
                        classNames.add((Pair<String, ViewElementDescriptor>)Pair.of(null, null));
                    }
                }
                layoutDescriptors = targetData.getLayoutDescriptors().getLayoutDescriptors();
                for (ViewElementDescriptor d : layoutDescriptors) {
                    className = d.getFullClassName();
                    if (exclude != null && exclude.contains(className)) continue;
                    combo.add(d.getUiName());
                    classNames.add((Pair<String, ViewElementDescriptor>)Pair.of((Object)className, (Object)d));
                }
            }
        } else {
            combo.add("SDK not initialized");
            classNames.add((Pair<String, ViewElementDescriptor>)Pair.of(null, null));
        }
        return classNames;
    }

    private static class InputPage
    extends VisualRefactoringWizard.VisualRefactoringInputPage {
        private final IProject mProject;
        private final String mOldType;
        private Text mIdText;
        private Combo mTypeCombo;
        private List<Pair<String, ViewElementDescriptor>> mClassNames;

        public InputPage(IProject project, String oldType) {
            super("WrapInInputPage");
            this.mProject = project;
            this.mOldType = oldType;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label typeLabel = new Label(composite, 0);
            typeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            typeLabel.setText("Type of Container:");
            this.mTypeCombo = new Combo(composite, 8);
            this.mTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.mTypeCombo.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            Label idLabel = new Label(composite, 0);
            idLabel.setText("New Layout Id:");
            idLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            this.mIdText = new Text(composite, 2048);
            this.mIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.mIdText.addModifyListener(this.mModifyValidateListener);
            Set<String> exclude = Collections.singleton("include");
            this.mClassNames = WrapInWizard.addLayouts(this.mProject, this.mOldType, this.mTypeCombo, exclude, true);
            this.mTypeCombo.select(0);
            this.setControl((Control)composite);
            this.validatePage();
            this.mTypeCombo.setFocus();
        }

        @Override
        protected boolean validatePage() {
            String type;
            boolean ok = true;
            String id = this.mIdText.getText().trim();
            if (id.length() == 0) {
                this.setErrorMessage("ID required");
                ok = false;
            } else {
                ResourceNameValidator validator = ResourceNameValidator.create(false, this.mProject, ResourceType.ID);
                String message = validator.isValid(id);
                if (message != null) {
                    this.setErrorMessage(message);
                    ok = false;
                }
            }
            int selectionIndex = this.mTypeCombo.getSelectionIndex();
            String string = type = selectionIndex != -1 ? (String)this.mClassNames.get(selectionIndex).getFirst() : null;
            if (type == null) {
                this.setErrorMessage("Select a container type");
                ok = false;
            }
            if (ok) {
                this.setErrorMessage(null);
                WrapInRefactoring refactoring = (WrapInRefactoring)this.getRefactoring();
                refactoring.setId(id);
                refactoring.setType(type);
                ViewElementDescriptor descriptor = (ViewElementDescriptor)this.mClassNames.get(selectionIndex).getSecond();
                if (descriptor instanceof PaletteMetadataDescriptor) {
                    PaletteMetadataDescriptor paletteDescriptor = (PaletteMetadataDescriptor)descriptor;
                    String initializedAttributes = paletteDescriptor.getInitializedAttributes();
                    refactoring.setInitializedAttributes(initializedAttributes);
                } else {
                    refactoring.setInitializedAttributes(null);
                }
            }
            this.setPageComplete(ok);
            return ok;
        }
    }
}

