/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.menu.descriptors;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.common.resources.platform.DeclareStyleableInfo;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.IDescriptorProvider;
import org.eclipse.andmore.internal.editors.descriptors.XmlnsAttributeDescriptor;

public final class MenuDescriptors
implements IDescriptorProvider {
    private ElementDescriptor mDescriptor = null;

    @Override
    public ElementDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return this.mDescriptor.getChildren();
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> styleMap) {
        if (this.mDescriptor == null) {
            this.mDescriptor = this.createElement(styleMap, "menu", "Menu", null, null, null, true);
        }
        ElementDescriptor sub_item = this.createElement(styleMap, "item", "Item", null, null, null, false);
        ElementDescriptor sub_group = this.createElement(styleMap, "group", "Group", null, null, new ElementDescriptor[]{sub_item}, false);
        ElementDescriptor sub_menu = this.createElement(styleMap, "menu", "Sub-Menu", null, null, new ElementDescriptor[]{sub_item, sub_group}, true);
        ElementDescriptor top_item = this.createElement(styleMap, "item", "Item", null, null, new ElementDescriptor[]{sub_menu}, false);
        ElementDescriptor top_group = this.createElement(styleMap, "group", "Group", null, null, new ElementDescriptor[]{top_item}, false);
        XmlnsAttributeDescriptor xmlns = new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
        this.updateElement(this.mDescriptor, styleMap, "Menu", xmlns);
        this.mDescriptor.setChildren(new ElementDescriptor[]{top_item, top_group});
    }

    private ElementDescriptor createElement(Map<String, DeclareStyleableInfo> styleMap, String xmlName, String uiName, String sdkUrl, AttributeDescriptor extraAttribute, ElementDescriptor[] childrenElements, boolean mandatory) {
        ElementDescriptor element = new ElementDescriptor(xmlName, uiName, null, sdkUrl, null, childrenElements, mandatory);
        return this.updateElement(element, styleMap, this.getStyleName(xmlName), extraAttribute);
    }

    private ElementDescriptor updateElement(ElementDescriptor element, Map<String, DeclareStyleableInfo> styleMap, String styleName, AttributeDescriptor extraAttribute) {
        DeclareStyleableInfo style;
        ArrayList<AttributeDescriptor> descs = new ArrayList<AttributeDescriptor>();
        DeclareStyleableInfo declareStyleableInfo = style = styleMap != null ? styleMap.get(styleName) : null;
        if (style != null) {
            DescriptorsUtils.appendAttributes(descs, null, "http://schemas.android.com/apk/res/android", style.getAttributes(), null, null);
            element.setTooltip(style.getJavaDoc());
        }
        if (extraAttribute != null) {
            descs.add(extraAttribute);
        }
        element.setAttributes(descs.toArray(new AttributeDescriptor[descs.size()]));
        return element;
    }

    private String getStyleName(String xmlName) {
        String styleName = AdtUtils.capitalize(xmlName);
        if (!styleName.equals("Menu")) {
            styleName = "Menu" + styleName;
        }
        return styleName;
    }
}

