/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import com.android.ddmlib.IDevice;
import org.eclipse.andmore.internal.launch.AndroidLaunch;
import org.eclipse.andmore.internal.launch.IAndroidLaunchAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public final class DelayedLaunchInfo {
    private IDevice mDevice = null;
    private final IProject mProject;
    private final String mPackageName;
    private final String mDebugPackageName;
    private final IFile mPackageFile;
    private final Boolean mDebuggable;
    private final String mRequiredApiVersionNumber;
    private InstallRetryMode mRetryMode = InstallRetryMode.NEVER;
    private final IAndroidLaunchAction mLaunchAction;
    private final AndroidLaunch mLaunch;
    private final IProgressMonitor mMonitor;
    private boolean mDebugMode;
    private int mAttemptCount = 0;
    private boolean mCancelled = false;

    public DelayedLaunchInfo(IProject project, String packageName, String debugPackageName, IAndroidLaunchAction launchAction, IFile pack, Boolean debuggable, String requiredApiVersionNumber, AndroidLaunch launch, IProgressMonitor monitor) {
        this.mProject = project;
        this.mPackageName = packageName;
        this.mDebugPackageName = debugPackageName;
        this.mPackageFile = pack;
        this.mLaunchAction = launchAction;
        this.mLaunch = launch;
        this.mMonitor = monitor;
        this.mDebuggable = debuggable;
        this.mRequiredApiVersionNumber = requiredApiVersionNumber;
    }

    public IDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(IDevice device) {
        this.mDevice = device;
    }

    public IProject getProject() {
        return this.mProject;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getDebugPackageName() {
        if (this.mDebugPackageName == null) {
            return this.getPackageName();
        }
        return this.mDebugPackageName;
    }

    public IFile getPackageFile() {
        return this.mPackageFile;
    }

    public Boolean getDebuggable() {
        return this.mDebuggable;
    }

    public String getRequiredApiVersionNumber() {
        return this.mRequiredApiVersionNumber;
    }

    public void setRetryMode(InstallRetryMode retryMode) {
        this.mRetryMode = retryMode;
    }

    public InstallRetryMode getRetryMode() {
        return this.mRetryMode;
    }

    public IAndroidLaunchAction getLaunchAction() {
        return this.mLaunchAction;
    }

    public AndroidLaunch getLaunch() {
        return this.mLaunch;
    }

    public IProgressMonitor getMonitor() {
        return this.mMonitor;
    }

    public void setDebugMode(boolean debugMode) {
        this.mDebugMode = debugMode;
    }

    public boolean isDebugMode() {
        return this.mDebugMode;
    }

    public void incrementAttemptCount() {
        ++this.mAttemptCount;
    }

    public int getAttemptCount() {
        return this.mAttemptCount;
    }

    public void setCancelled(boolean cancelled) {
        this.mCancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.mCancelled;
    }

    static enum InstallRetryMode {
        NEVER,
        ALWAYS,
        PROMPT;

    }
}

