/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiDetector;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AddSuppressAttribute
implements ICompletionProposal {
    private final AndroidXmlEditor mEditor;
    private final String mId;
    private final IMarker mMarker;
    private final Element mElement;
    private final String mDescription;
    private final String mTargetApi;

    private AddSuppressAttribute(AndroidXmlEditor editor, String id, IMarker marker, Element element, String description, String targetApi) {
        this.mEditor = editor;
        this.mId = id;
        this.mMarker = marker;
        this.mElement = element;
        this.mDescription = description;
        this.mTargetApi = targetApi;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.mDescription;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Image getImage() {
        return IconFactory.getInstance().getIcon("newannotation");
    }

    public void apply(IDocument document) {
        String value;
        String attribute;
        if (this.mTargetApi != null) {
            attribute = "targetApi";
            value = this.mTargetApi;
        } else {
            attribute = "ignore";
            value = this.mId;
        }
        AdtUtils.setToolsAttribute(this.mEditor, this.mElement, this.mDescription, attribute, value, true, true);
        try {
            this.mMarker.delete();
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, "Could not remove marker", new Object[0]);
        }
    }

    public static List<AddSuppressAttribute> createFixes(AndroidXmlEditor editor, IMarker marker, String id) {
        Pattern pattern;
        Matcher matcher;
        String message;
        Node node;
        String fileName = marker.getResource().getName();
        if (!fileName.endsWith(".xml")) {
            return Collections.emptyList();
        }
        int offset = marker.getAttribute("charStart", -1);
        if (offset == -1) {
            node = DomUtilities.getNode((IDocument)editor.getStructuredDocument(), 0);
            if (node != null) {
                node = node.getOwnerDocument().getDocumentElement();
            }
        } else {
            node = DomUtilities.getNode((IDocument)editor.getStructuredDocument(), offset);
        }
        if (node == null) {
            return Collections.emptyList();
        }
        Document document = node.getOwnerDocument();
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node == null && (node = document.getDocumentElement()) == null) {
            return Collections.emptyList();
        }
        String desc = String.format("Add ignore '%1$s' to element", id);
        Element element = (Element)node;
        ArrayList fixes = Lists.newArrayListWithExpectedSize((int)2);
        fixes.add(new AddSuppressAttribute(editor, id, marker, element, desc, null));
        int api = -1;
        if ((id.equals(ApiDetector.UNSUPPORTED.getId()) || id.equals(ApiDetector.INLINED.getId())) && (message = marker.getAttribute("message", null)) != null && (matcher = (pattern = Pattern.compile("\\s(\\d+)\\s")).matcher(message)).find()) {
            String targetApi;
            api = Integer.parseInt(matcher.group(1));
            String buildCode = SdkVersionInfo.getBuildCode((int)api);
            if (buildCode != null) {
                targetApi = buildCode.toLowerCase(Locale.US);
                fixes.add(new AddSuppressAttribute(editor, id, marker, element, String.format("Add targetApi '%1$s' to element", targetApi), targetApi));
            }
            targetApi = Integer.toString(api);
            fixes.add(new AddSuppressAttribute(editor, id, marker, element, String.format("Add targetApi '%1$s' to element", targetApi), targetApi));
        }
        return fixes;
    }

    public static AddSuppressAttribute createFixForAll(AndroidXmlEditor editor, IMarker marker, String id) {
        String fileName = marker.getResource().getName();
        if (!fileName.endsWith(".xml")) {
            return null;
        }
        Node node = DomUtilities.getNode((IDocument)editor.getStructuredDocument(), 0);
        if (node != null) {
            node = node.getOwnerDocument().getDocumentElement();
            String desc = String.format("Add ignore '%1$s' to element", id);
            Element element = (Element)node;
            return new AddSuppressAttribute(editor, id, marker, element, desc, null);
        }
        return null;
    }
}

