/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.project;

import com.android.ide.common.sdk.LoadStatus;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.build.JarListSanitizer;
import com.android.sdklib.build.RenderScriptProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.AndroidPrintStream;
import org.eclipse.andmore.internal.project.AndroidClasspathContainer;
import org.eclipse.andmore.internal.project.BaseClasspathContainerInitializer;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class LibraryClasspathContainerInitializer
extends BaseClasspathContainerInitializer {
    private static final String ATTR_SRC = "src";
    private static final String ATTR_DOC = "doc";
    private static final String DOT_PROPERTIES = ".properties";

    public static boolean updateProjects(IJavaProject[] androidProjects) {
        try {
            int projectCount = androidProjects.length;
            IClasspathContainer[] libraryContainers = new IClasspathContainer[projectCount];
            IClasspathContainer[] dependencyContainers = new IClasspathContainer[projectCount];
            int i = 0;
            while (i < projectCount) {
                libraryContainers[i] = LibraryClasspathContainerInitializer.allocateLibraryContainer(androidProjects[i]);
                dependencyContainers[i] = LibraryClasspathContainerInitializer.allocateDependencyContainer(androidProjects[i]);
                ++i;
            }
            JavaCore.setClasspathContainer((IPath)new Path("org.eclipse.andmore.LIBRARIES"), (IJavaProject[])androidProjects, (IClasspathContainer[])libraryContainers, (IProgressMonitor)new NullProgressMonitor());
            JavaCore.setClasspathContainer((IPath)new Path("org.eclipse.andmore.DEPENDENCIES"), (IJavaProject[])androidProjects, (IClasspathContainer[])dependencyContainers, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static boolean updateProject(List<ProjectState> projects) {
        ArrayList<IJavaProject> javaProjectList = new ArrayList<IJavaProject>(projects.size());
        for (ProjectState p : projects) {
            IJavaProject javaProject = JavaCore.create((IProject)p.getProject());
            if (javaProject == null) continue;
            javaProjectList.add(javaProject);
        }
        IJavaProject[] javaProjects = javaProjectList.toArray(new IJavaProject[javaProjectList.size()]);
        return LibraryClasspathContainerInitializer.updateProjects(javaProjects);
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        IClasspathContainer dependencies;
        if ("org.eclipse.andmore.LIBRARIES".equals(containerPath.toString())) {
            IClasspathContainer libraries = LibraryClasspathContainerInitializer.allocateLibraryContainer(project);
            if (libraries != null) {
                JavaCore.setClasspathContainer((IPath)new Path("org.eclipse.andmore.LIBRARIES"), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{libraries}, (IProgressMonitor)new NullProgressMonitor());
            }
        } else if ("org.eclipse.andmore.DEPENDENCIES".equals(containerPath.toString()) && (dependencies = LibraryClasspathContainerInitializer.allocateDependencyContainer(project)) != null) {
            JavaCore.setClasspathContainer((IPath)new Path("org.eclipse.andmore.DEPENDENCIES"), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{dependencies}, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static IClasspathContainer allocateLibraryContainer(IJavaProject javaProject) {
        IProject iProject = javaProject.getProject();
        ProjectState state = Sdk.getProjectState(iProject);
        if (state == null) {
            return null;
        }
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        HashSet<File> jarFiles = new HashSet<File>();
        HashSet<IProject> refProjects = new HashSet<IProject>();
        List<IProject> libProjects = state.getFullLibraryProjects();
        for (IProject libProject : libProjects) {
            LibraryClasspathContainerInitializer.getDependencyListFromClasspath(libProject, refProjects, jarFiles, true);
        }
        LibraryClasspathContainerInitializer.processReferencedProjects(iProject, refProjects, jarFiles);
        LibraryClasspathContainerInitializer.getJarListFromLibsFolder(iProject, jarFiles);
        for (IProject p : refProjects) {
            entries.add(JavaCore.newProjectEntry((IPath)p.getFullPath(), (boolean)true));
        }
        entries.addAll(LibraryClasspathContainerInitializer.convertJarsToClasspathEntries(iProject, jarFiles));
        return LibraryClasspathContainerInitializer.allocateContainer(javaProject, entries, (IPath)new Path("org.eclipse.andmore.LIBRARIES"), "Android Private Libraries");
    }

    /*
     * Unable to fully structure code
     */
    private static List<IClasspathEntry> convertJarsToClasspathEntries(IProject iProject, Set<File> jarFiles) {
        entries = new ArrayList<IClasspathEntry>(jarFiles.size());
        sanitizer = new JarListSanitizer(iProject.getFolder("bin").getLocation().toFile(), (PrintStream)new AndroidPrintStream(iProject, null, AndmoreAndroidPlugin.getOutStream()));
        errorMessage = null;
        try {
            sanitizedList = sanitizer.sanitize(jarFiles);
            for (File jarFile : sanitizedList) {
                block28: {
                    if (jarFile instanceof CPEFile) {
                        cpeFile = (CPEFile)jarFile;
                        e = cpeFile.getClasspathEntry();
                        entries.add(JavaCore.newLibraryEntry((IPath)e.getPath(), (IPath)e.getSourceAttachmentPath(), (IPath)e.getSourceAttachmentRootPath(), (IAccessRule[])e.getAccessRules(), (IClasspathAttribute[])e.getExtraAttributes(), (boolean)true));
                        continue;
                    }
                    jarPath = jarFile.getAbsolutePath();
                    sourceAttachmentPath = null;
                    javaDocAttribute = null;
                    jarProperties = new File(String.valueOf(jarPath) + ".properties");
                    if (jarProperties.isFile()) {
                        p = new Properties();
                        is = null;
                        try {
                            is = new FileInputStream(jarProperties);
                            p.load(is);
                            value = p.getProperty("src");
                            if (value != null && (srcPath = LibraryClasspathContainerInitializer.getFile(jarFile, value)).exists()) {
                                sourceAttachmentPath = new Path(srcPath.getAbsolutePath());
                            }
                            if ((value = p.getProperty("doc")) != null && (docPath = LibraryClasspathContainerInitializer.getFile(jarFile, value)).exists()) {
                                try {
                                    javaDocAttribute = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)docPath.toURI().toURL().toString());
                                }
                                catch (MalformedURLException e) {
                                    AndmoreAndroidPlugin.log(e, "Failed to process 'doc' attribute for %s", new Object[]{jarProperties.getAbsolutePath()});
                                }
                            }
                        }
                        catch (FileNotFoundException v0) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException v1) {}
                            }
                            break block28;
                        }
                        catch (IOException e) {
                            try {
                                AndmoreAndroidPlugin.log(e, "Failed to read %s", new Object[]{jarProperties.getAbsolutePath()});
                                ** if (is == null) goto lbl-1000
                            }
                            catch (Throwable var17_20) {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException v3) {}
                                }
                                throw var17_20;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    is.close();
                                }
                                catch (IOException v2) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block28;
                            }
                        }
                        if (is == null) break block28;
                        try {
                            is.close();
                        }
                        catch (IOException v4) {}
                    }
                }
                if (javaDocAttribute != null) {
                    entries.add(JavaCore.newLibraryEntry((IPath)new Path(jarPath), sourceAttachmentPath, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[]{javaDocAttribute}, (boolean)true));
                    continue;
                }
                entries.add(JavaCore.newLibraryEntry((IPath)new Path(jarPath), sourceAttachmentPath, null, (boolean)true));
            }
        }
        catch (JarListSanitizer.DifferentLibException e) {
            errorMessage = e.getMessage();
            AndmoreAndroidPlugin.printErrorToConsole(iProject, (Object[])e.getDetails());
        }
        catch (JarListSanitizer.Sha1Exception e) {
            errorMessage = e.getMessage();
        }
        LibraryClasspathContainerInitializer.processError(iProject, errorMessage, "org.eclipse.andmore.dependencyProblem", true);
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IClasspathContainer allocateDependencyContainer(IJavaProject javaProject) {
        IProject iProject = javaProject.getProject();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        HashSet<File> jarFiles = new HashSet<File>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        AndmoreAndroidPlugin plugin = AndmoreAndroidPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        Object object = Sdk.getLock();
        synchronized (object) {
            boolean sdkIsLoaded = plugin.getSdkLoadStatus() == LoadStatus.LOADED;
            ProjectState state = Sdk.getProjectState(iProject);
            if (state == null) {
                return null;
            }
            if (state.getTarget() != null && state.getTarget().getVersion().getApiLevel() <= 15) {
                File annotationsJar = new File(Sdk.getCurrent().getSdkOsLocation(), "tools" + File.separator + "support" + File.separator + "annotations.jar");
                jarFiles.add(annotationsJar);
            }
            if (state.getRenderScriptSupportMode()) {
                if (!sdkIsLoaded) {
                    return null;
                }
                BuildToolInfo buildToolInfo = state.getBuildToolInfo();
                if (buildToolInfo == null && (buildToolInfo = Sdk.getCurrent().getLatestBuildTool()) == null) {
                    return null;
                }
                File renderScriptSupportJar = RenderScriptProcessor.getSupportJar((String)buildToolInfo.getLocation().getAbsolutePath());
                jarFiles.add(renderScriptSupportJar);
            }
            List<IProject> libProjects = state.getFullLibraryProjects();
            Iterator<IProject> iterator = libProjects.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    entries.addAll(LibraryClasspathContainerInitializer.convertJarsToClasspathEntries(iProject, jarFiles));
                    return LibraryClasspathContainerInitializer.allocateContainer(javaProject, entries, (IPath)new Path("org.eclipse.andmore.DEPENDENCIES"), "Android Dependencies");
                }
                IProject libProject = iterator.next();
                IFolder outputFolder = BaseProjectHelper.getAndroidOutputFolder(libProject);
                if (outputFolder == null) continue;
                IFile jarIFile = outputFolder.getFile(String.valueOf(libProject.getName().toLowerCase()) + ".jar");
                List<IPath> srcs = BaseProjectHelper.getSourceClasspaths(libProject);
                IPath sourceFolder = null;
                for (IPath src : srcs) {
                    IFolder srcFolder = workspaceRoot.getFolder(src);
                    if (srcFolder.isDerived()) continue;
                    sourceFolder = src;
                    break;
                }
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarIFile.getLocation(), sourceFolder, null, (boolean)true);
                entries.add(entry);
            }
        }
    }

    private static IClasspathContainer allocateContainer(IJavaProject javaProject, List<IClasspathEntry> entries, IPath id, String description) {
        if (AndmoreAndroidPlugin.getDefault() == null) {
            return null;
        }
        try {
            IClasspathEntry[] rawClasspath;
            IClasspathEntry[] oldRawClasspath = rawClasspath = javaProject.getRawClasspath();
            boolean foundContainer = false;
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                int kind = entry.getEntryKind();
                if (kind == 5) {
                    String path = entry.getPath().toString();
                    String idString = id.toString();
                    if (idString.equals(path)) {
                        foundContainer = true;
                        break;
                    }
                }
                ++n2;
            }
            if (!foundContainer) {
                rawClasspath = ProjectHelper.addEntryToClasspath(rawClasspath, JavaCore.newContainerEntry((IPath)id, (boolean)true));
            }
            if (rawClasspath != oldRawClasspath) {
                javaProject.setRawClasspath(rawClasspath, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return new AndroidClasspathContainer(entries.toArray(new IClasspathEntry[entries.size()]), id, description, 1);
    }

    private static File getFile(File root, String value) {
        File file = new File(value);
        if (!file.isAbsolute()) {
            file = new File(root.getParentFile(), value);
        }
        return file;
    }

    private static void getJarListFromLibsFolder(IProject project, Set<File> jarFiles) {
        IFolder libsFolder = project.getFolder("libs");
        if (libsFolder.exists()) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = libsFolder.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath location;
                    IResource member = iResourceArray[n2];
                    if (member.getType() == 1 && "jar".equalsIgnoreCase(member.getFileExtension()) && (location = member.getLocation()) != null) {
                        jarFiles.add(location.toFile());
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private static void processReferencedProjects(IProject project, Set<IProject> projects, Set<File> jarFiles) {
        try {
            IProject[] refs;
            IProject[] iProjectArray = refs = project.getReferencedProjects();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (p.hasNature("org.eclipse.jdt.core.javanature") && !p.hasNature("org.eclipse.andmore.AndroidNature")) {
                    LibraryClasspathContainerInitializer.getDependencyListFromClasspath(p, projects, jarFiles, true);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private static void getDependencyListFromClasspath(IProject project, Set<IProject> projects, Set<File> jarFiles, boolean includeJarFiles) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IClasspathEntry[] classpaths = javaProject.readRawClasspath();
        if (classpaths != null) {
            IClasspathEntry[] iClasspathEntryArray = classpaths;
            int n = classpaths.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (!e.getPath().toString().equals("org.eclipse.andmore.DEPENDENCIES") && e.isExported()) {
                    LibraryClasspathContainerInitializer.processCPE(e, javaProject, wsRoot, projects, jarFiles, includeJarFiles);
                }
                ++n2;
            }
        }
    }

    private static void processCPE(IClasspathEntry entry, IJavaProject javaProject, IWorkspaceRoot wsRoot, Set<IProject> projects, Set<File> jarFiles, boolean includeJarFiles) {
        if (entry.getEntryKind() == 4) {
            entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        }
        if (entry.getEntryKind() == 2) {
            IProject refProject = wsRoot.getProject(entry.getPath().lastSegment());
            try {
                if (refProject.hasNature("org.eclipse.jdt.core.javanature") && !refProject.hasNature("org.eclipse.andmore.AndroidNature")) {
                    projects.add(refProject);
                    LibraryClasspathContainerInitializer.getDependencyListFromClasspath(refProject, projects, jarFiles, true);
                }
            }
            catch (CoreException coreException) {}
        } else if (entry.getEntryKind() == 1) {
            if (includeJarFiles) {
                LibraryClasspathContainerInitializer.handleClasspathLibrary(entry, wsRoot, jarFiles);
            }
        } else if (entry.getEntryKind() == 5) {
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                if (container != null && container.getKind() == 1) {
                    IClasspathEntry[] entries;
                    IClasspathEntry[] iClasspathEntryArray = entries = container.getClasspathEntries();
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry cpe = iClasspathEntryArray[n2];
                        LibraryClasspathContainerInitializer.processCPE(cpe, javaProject, wsRoot, projects, jarFiles, includeJarFiles);
                        ++n2;
                    }
                }
            }
            catch (JavaModelException jme) {
                AndmoreAndroidPlugin.log(jme, "Failed to resolve ClasspathContainer: %s", entry.getPath());
            }
        }
    }

    private static void handleClasspathLibrary(IClasspathEntry e, IWorkspaceRoot wsRoot, Set<File> jarFiles) {
        IPath path = e.getPath();
        IResource resource = wsRoot.findMember(path);
        if ("jar".equalsIgnoreCase(path.getFileExtension())) {
            if (resource != null && resource.exists() && resource.getType() == 1) {
                jarFiles.add(new CPEFile(resource.getLocation().toFile(), e));
            } else {
                String osFullPath = path.toOSString();
                CPEFile f = new CPEFile(osFullPath, e);
                if (f.isFile()) {
                    jarFiles.add(f);
                }
            }
        }
    }

    private static final class CPEFile
    extends File {
        private static final long serialVersionUID = 1L;
        private final IClasspathEntry mClasspathEntry;

        public CPEFile(String pathname, IClasspathEntry classpathEntry) {
            super(pathname);
            this.mClasspathEntry = classpathEntry;
        }

        public CPEFile(File file, IClasspathEntry classpathEntry) {
            super(file.getAbsolutePath());
            this.mClasspathEntry = classpathEntry;
        }

        public IClasspathEntry getClasspathEntry() {
            return this.mClasspathEntry;
        }
    }
}

