/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.project;

import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.internal.actions.AddSupportJarAction;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class SupportLibraryHelper {
    private static IProject sCachedProject;

    public static String getTagFor(IProject project, String tag) {
        int minSdk;
        boolean isGridLayout = tag.equals("android.widget.GridLayout");
        boolean isSpace = tag.equals("android.widget.Space");
        if ((isGridLayout || isSpace) && (minSdk = ManifestInfo.get(project).getMinSdkVersion()) < 14) {
            ProjectState state;
            IProject supportProject = SupportLibraryHelper.getSupportProjectV7();
            if (supportProject != null && (state = Sdk.getProjectState(project)) != null) {
                for (ProjectState.LibraryState library : state.getLibraries()) {
                    if (!supportProject.equals((Object)library.getProjectState().getProject())) continue;
                    return isGridLayout ? "android.support.v7.widget.GridLayout" : "android.support.v7.widget.Space";
                }
            }
            String message = String.format("%1$s requires API level 14 or higher, or a compatibility library for older versions.\n\n Do you want to install the compatibility library?", tag);
            MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Warning", null, message, 3, new String[]{"Install", "Cancel"}, 1);
            int answer = dialog.open();
            if (answer == 0) {
                if (supportProject != null ? !AddSupportJarAction.addLibraryDependency(supportProject, project, true) : !AddSupportJarAction.installGridLayoutLibrary(project, true)) {
                    return tag;
                }
                return isGridLayout ? "android.support.v7.widget.GridLayout" : "android.support.v7.widget.Space";
            }
        }
        return tag;
    }

    public static IProject getSupportProjectV7() {
        if (sCachedProject != null) {
            if (sCachedProject.isAccessible()) {
                return sCachedProject;
            }
            sCachedProject = null;
        }
        sCachedProject = SupportLibraryHelper.findSupportProjectV7();
        return sCachedProject;
    }

    private static IProject findSupportProjectV7() {
        IJavaProject[] iJavaProjectArray = AdtUtils.getOpenAndroidProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestInfo manifestInfo;
            IJavaProject javaProject = iJavaProjectArray[n2];
            IProject project = javaProject.getProject();
            ProjectState state = Sdk.getProjectState(project);
            if (state != null && state.isLibrary() && (manifestInfo = ManifestInfo.get(project)).getPackage().equals("android.support.v7.gridlayout")) {
                return project;
            }
            ++n2;
        }
        return null;
    }
}

