/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.newproject;

import com.android.SdkConstants;
import com.android.ide.common.xml.ManifestData;
import com.android.utils.SdkUtils;
import java.io.File;
import java.net.URI;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.project.AndroidManifestHelper;
import org.eclipse.andmore.internal.wizards.newproject.ApplicationInfoPage;
import org.eclipse.andmore.internal.wizards.newproject.NewProjectWizardState;
import org.eclipse.andmore.internal.wizards.newproject.WorkingSetGroup;
import org.eclipse.andmore.internal.wizards.newproject.WorkingSetHelper;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;

public class ProjectNamePage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private final NewProjectWizardState mValues;
    private boolean mIgnore;
    private static String sCustomLocationOsPath = "";
    private static boolean sAutoComputeCustomLocation = true;
    private Text mProjectNameText;
    private Text mLocationText;
    private Button mCreateSampleRadioButton;
    private Button mCreateNewButton;
    private Button mUseDefaultCheckBox;
    private Button mBrowseButton;
    private Label mLocationLabel;
    private WorkingSetGroup mWorkingSetGroup;
    private boolean mCheckedSdkUptodate;

    ProjectNamePage(NewProjectWizardState values) {
        super("projectNamePage");
        this.mValues = values;
        this.setTitle("Create Android Project");
        this.setDescription("Select project name and type of project");
        this.mWorkingSetGroup = new WorkingSetGroup();
        this.setWorkingSets(new IWorkingSet[0]);
    }

    void init(IStructuredSelection selection, IWorkbenchPart activePart) {
        this.setWorkingSets(WorkingSetHelper.getSelectedWorkingSet(selection, activePart));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Project Name:");
        this.mProjectNameText = new Text(container, 2048);
        this.mProjectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mProjectNameText.addModifyListener((ModifyListener)this);
        if (this.mValues.mode != NewProjectWizardState.Mode.TEST) {
            this.mCreateNewButton = new Button(container, 16);
            this.mCreateNewButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
            this.mCreateNewButton.setText("Create new project in workspace");
            this.mCreateNewButton.addSelectionListener((SelectionListener)this);
            this.mCreateSampleRadioButton = new Button(container, 16);
            this.mCreateSampleRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
            this.mCreateSampleRadioButton.setText("Create project from existing sample");
            this.mCreateSampleRadioButton.addSelectionListener((SelectionListener)this);
        }
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.mUseDefaultCheckBox = new Button(container, 32);
        this.mUseDefaultCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.mUseDefaultCheckBox.setText("Use default location");
        this.mUseDefaultCheckBox.addSelectionListener((SelectionListener)this);
        this.mLocationLabel = new Label(container, 0);
        this.mLocationLabel.setText("Location:");
        this.mLocationText = new Text(container, 2048);
        this.mLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mLocationText.addModifyListener((ModifyListener)this);
        this.mBrowseButton = new Button(container, 0);
        this.mBrowseButton.setText("Browse...");
        this.mBrowseButton.addSelectionListener((SelectionListener)this);
        Composite group = this.mWorkingSetGroup.createControl(container);
        group.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.mIgnore = true;
                if (this.mValues.projectName != null) {
                    this.mProjectNameText.setText(this.mValues.projectName);
                    this.mProjectNameText.setFocus();
                }
                if (this.mValues.mode == NewProjectWizardState.Mode.ANY || this.mValues.mode == NewProjectWizardState.Mode.TEST) {
                    if (this.mValues.useExisting) {
                        assert (false);
                    } else if (this.mCreateNewButton != null) {
                        this.mCreateNewButton.setSelection(true);
                    }
                } else if (this.mValues.mode == NewProjectWizardState.Mode.SAMPLE) {
                    this.mCreateSampleRadioButton.setSelection(true);
                }
                if (this.mValues.projectLocation != null) {
                    this.mLocationText.setText(this.mValues.projectLocation.getPath());
                }
                this.mUseDefaultCheckBox.setSelection(this.mValues.useDefaultLocation);
                this.updateLocationState();
            }
            finally {
                this.mIgnore = false;
            }
        }
        this.validatePage();
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mProjectNameText) {
            this.onProjectFieldModified();
            if (!this.mValues.useDefaultLocation && !this.mValues.projectLocationModifiedByUser) {
                this.updateLocationPathField(null);
            }
        } else if (source == this.mLocationText) {
            this.mValues.projectLocationModifiedByUser = true;
            if (!this.mValues.useDefaultLocation) {
                File f;
                this.mValues.projectLocation = f = new File(this.mLocationText.getText().trim());
                if (f.exists() && f.isDirectory() && !f.equals(this.mValues.projectLocation)) {
                    this.updateLocationPathField(this.mValues.projectLocation.getPath());
                }
            }
        }
        this.validatePage();
    }

    private void onProjectFieldModified() {
        this.mValues.projectName = this.mProjectNameText.getText().trim();
        this.mValues.projectNameModifiedByUser = true;
        if (!this.mValues.applicationNameModifiedByUser) {
            this.mValues.applicationName = AdtUtils.capitalize(this.mValues.projectName);
            if (!this.mValues.testApplicationNameModified) {
                this.mValues.testApplicationName = ApplicationInfoPage.suggestTestApplicationName(this.mValues.applicationName);
            }
        }
        if (!this.mValues.activityNameModifiedByUser) {
            String name = AdtUtils.capitalize(this.mValues.projectName);
            this.mValues.activityName = String.valueOf(SdkUtils.stripWhitespace((String)name)) + "Activity";
        }
        if (!this.mValues.testProjectModified) {
            this.mValues.testProjectName = ApplicationInfoPage.suggestTestProjectName(this.mValues.projectName);
        }
        if (!this.mValues.projectLocationModifiedByUser) {
            this.updateLocationPathField(null);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mCreateNewButton && this.mCreateNewButton != null && this.mCreateNewButton.getSelection()) {
            this.mValues.useExisting = false;
            if (this.mValues.mode == NewProjectWizardState.Mode.SAMPLE) {
                this.mValues.mode = NewProjectWizardState.Mode.ANY;
            }
            this.updateLocationState();
        } else if (source == this.mCreateSampleRadioButton && this.mCreateSampleRadioButton.getSelection()) {
            this.mValues.useExisting = true;
            this.mValues.useDefaultLocation = true;
            if (!this.mUseDefaultCheckBox.getSelection()) {
                try {
                    this.mIgnore = true;
                    this.mUseDefaultCheckBox.setSelection(true);
                }
                finally {
                    this.mIgnore = false;
                }
            }
            this.mValues.mode = NewProjectWizardState.Mode.SAMPLE;
            this.updateLocationState();
        } else if (source == this.mUseDefaultCheckBox) {
            this.mValues.useDefaultLocation = this.mUseDefaultCheckBox.getSelection();
            this.updateLocationState();
        } else if (source == this.mBrowseButton) {
            this.onOpenDirectoryBrowser();
        }
        this.validatePage();
    }

    private void updateLocationState() {
        boolean isNewProject = !this.mValues.useExisting;
        boolean isCreateFromSample = this.mValues.mode == NewProjectWizardState.Mode.SAMPLE;
        boolean useDefault = this.mValues.useDefaultLocation && !isCreateFromSample;
        boolean locationEnabled = (!isNewProject || !useDefault) && !isCreateFromSample;
        this.mUseDefaultCheckBox.setEnabled(isNewProject);
        this.mLocationLabel.setEnabled(locationEnabled);
        this.mLocationText.setEnabled(locationEnabled);
        this.mBrowseButton.setEnabled(locationEnabled);
        this.updateLocationPathField(null);
    }

    private void onOpenDirectoryBrowser() {
        String existingDir = this.mLocationText.getText().trim();
        if (existingDir.length() == 0) {
            existingDir = null;
        } else {
            File f = new File(existingDir);
            if (!f.exists()) {
                existingDir = null;
            }
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(this.mLocationText.getShell());
        directoryDialog.setMessage("Browse for folder");
        directoryDialog.setFilterPath(existingDir);
        String dir = directoryDialog.open();
        if (dir != null) {
            this.updateLocationPathField(dir);
            this.validatePage();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private IWorkingSet[] getWorkingSets() {
        return this.mWorkingSetGroup.getSelectedWorkingSets();
    }

    private void setWorkingSets(IWorkingSet[] workingSets) {
        assert (workingSets != null);
        this.mWorkingSetGroup.setWorkingSets(workingSets);
    }

    private void updateLocationPathField(String absDir) {
        boolean customLocation;
        boolean isNewProject = !this.mValues.useExisting || this.mValues.mode == NewProjectWizardState.Mode.SAMPLE;
        boolean useDefault = this.mValues.useDefaultLocation;
        boolean bl = customLocation = !isNewProject || !useDefault;
        if (!this.mIgnore) {
            try {
                this.mIgnore = true;
                if (customLocation) {
                    if (absDir != null) {
                        sAutoComputeCustomLocation = sAutoComputeCustomLocation && absDir.equals(sCustomLocationOsPath);
                        sCustomLocationOsPath = TextProcessor.process((String)absDir);
                    } else if (sAutoComputeCustomLocation || !isNewProject && !new File(sCustomLocationOsPath).isDirectory()) {
                        sCustomLocationOsPath = System.getProperty("user.home");
                    }
                    if (!this.mLocationText.getText().equals(sCustomLocationOsPath)) {
                        this.mLocationText.setText(sCustomLocationOsPath);
                        this.mValues.projectLocation = new File(sCustomLocationOsPath);
                    }
                } else {
                    String value = Platform.getLocation().append(this.mValues.projectName).toString();
                    value = TextProcessor.process((String)value);
                    if (!this.mLocationText.getText().equals(value)) {
                        this.mLocationText.setText(value);
                        this.mValues.projectLocation = new File(value);
                    }
                }
            }
            finally {
                this.mIgnore = false;
            }
        }
        if (this.mValues.useExisting && this.mValues.projectLocation != null && this.mValues.projectLocation.exists() && this.mValues.mode != NewProjectWizardState.Mode.SAMPLE) {
            this.mValues.extractFromAndroidManifest(new Path(this.mValues.projectLocation.getPath()));
            if (!this.mValues.projectNameModifiedByUser && this.mValues.projectName != null) {
                try {
                    this.mIgnore = true;
                    this.mProjectNameText.setText(this.mValues.projectName);
                }
                finally {
                    this.mIgnore = false;
                }
            }
        }
    }

    private void validatePage() {
        IStatus validLocation;
        IStatus status = null;
        if (this.mValues.mode != NewProjectWizardState.Mode.SAMPLE) {
            status = ProjectNamePage.validateProjectName(this.mValues.projectName);
        }
        if ((status == null || status.getSeverity() != 4) && (validLocation = this.validateLocation()) != null) {
            status = validLocation;
        }
        if (!this.mCheckedSdkUptodate) {
            File file = new File(AndmoreAndroidPlugin.getOsSdkFolder(), String.valueOf(SdkConstants.OS_SDK_TOOLS_LIB_FOLDER) + File.separator + "proguard-project.txt");
            if (!file.exists()) {
                status = new Status(4, "org.eclipse.andmore", String.format("You do not have the latest version of the SDK Tools installed: Please update. (Missing %1$s)", file.getPath()));
            } else {
                this.mCheckedSdkUptodate = true;
            }
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    private IStatus validateLocation() {
        if (this.mValues.mode == NewProjectWizardState.Mode.SAMPLE) {
            return null;
        }
        Path path = new Path(this.mValues.projectLocation.getPath());
        if (!this.mValues.useExisting) {
            if (!this.mValues.useDefaultLocation) {
                String[] l;
                IProject handle;
                URI uri = URIUtil.toURI((String)path.toOSString());
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus locationStatus = workspace.validateProjectLocationURI(handle = workspace.getRoot().getProject(this.mValues.projectName), uri);
                if (!locationStatus.isOK()) {
                    return locationStatus;
                }
                File f = path.toFile();
                if (f.exists() && !f.isDirectory()) {
                    return new Status(4, "org.eclipse.andmore", "A directory name must be specified.");
                }
                if (f.isDirectory() && (l = f.list()) != null && l.length != 0) {
                    return new Status(2, "org.eclipse.andmore", "The selected output directory is not empty.");
                }
            } else {
                if (this.mValues.projectLocation.getPath().length() == 0) {
                    return new Status(4, "org.eclipse.andmore", "A directory name must be specified.");
                }
                File dest = path.toFile();
                if (dest.exists()) {
                    return new Status(4, "org.eclipse.andmore", String.format("There is already a file or directory named \"%1$s\" in the selected location.", this.mValues.projectName));
                }
            }
        } else {
            File f = path.toFile();
            if (!f.isDirectory()) {
                return new Status(4, "org.eclipse.andmore", "An existing directory name must be specified.");
            }
            String osPath = path.append("AndroidManifest.xml").toOSString();
            File manifestFile = new File(osPath);
            if (!manifestFile.isFile()) {
                return new Status(4, "org.eclipse.andmore", String.format("Choose a valid Android code directory\n(%1$s not found in %2$s.)", "AndroidManifest.xml", f.getName()));
            }
            ManifestData manifestData = AndroidManifestHelper.parseForData(osPath);
            if (manifestData == null) {
                return new Status(4, "org.eclipse.andmore", String.format("File %1$s could not be parsed.", osPath));
            }
            String packageName = manifestData.getPackage();
            if (packageName == null || packageName.length() == 0) {
                return new Status(4, "org.eclipse.andmore", String.format("No package name defined in %1$s.", osPath));
            }
            ManifestData.Activity[] activities = manifestData.getActivities();
            if ((activities == null || activities.length == 0) && this.mValues.createActivity) {
                return new Status(4, "org.eclipse.andmore", String.format("No activity name defined in %1$s.", osPath));
            }
            if (path.append(".project").toFile().exists()) {
                return new Status(2, "org.eclipse.andmore", "An Eclipse project already exists in this directory.\nConsider using File > Import > Existing Project instead.");
            }
        }
        return null;
    }

    public static IStatus validateProjectName(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return new Status(4, "org.eclipse.andmore", "Project name must be specified");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject existingProj = iProjectArray[n2];
            if (projectName.equalsIgnoreCase(existingProj.getName())) {
                return new Status(4, "org.eclipse.andmore", "A project with that name already exists in the workspace");
            }
            ++n2;
        }
        return null;
    }

    public IWizardPage getNextPage() {
        this.mValues.workingSets = this.getWorkingSets();
        return super.getNextPage();
    }
}

