/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.newxmlfile;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.resources.ResourceFolderType;
import com.android.utils.Pair;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlFormatPreferences;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlPrettyPrinter;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderPreviewManager;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.project.SupportLibraryHelper;
import org.eclipse.andmore.internal.wizards.newxmlfile.ChooseConfigurationPage;
import org.eclipse.andmore.internal.wizards.newxmlfile.NewXmlFileCreationPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;

public class NewXmlFileWizard
extends Wizard
implements INewWizard {
    public static final String XML_HEADER_LINE = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    private static final String PROJECT_LOGO_LARGE = "android-64";
    protected static final String MAIN_PAGE_NAME = "newAndroidXmlFilePage";
    private NewXmlFileCreationPage mMainPage;
    private ChooseConfigurationPage mConfigPage;
    private Values mValues;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setHelpAvailable(false);
        this.setWindowTitle("New Android XML File");
        this.setImageDescriptor();
        this.mValues = new Values();
        this.mMainPage = this.createMainPage(this.mValues);
        this.mMainPage.setTitle("New Android XML File");
        this.mMainPage.setDescription("Creates a new Android XML file.");
        this.mMainPage.setInitialSelection(selection);
        this.mConfigPage = new ChooseConfigurationPage(this.mValues);
        AndmoreAndroidPlugin.getDefault().refreshSdk();
    }

    protected NewXmlFileCreationPage createMainPage(Values values) {
        return new NewXmlFileCreationPage(MAIN_PAGE_NAME, values);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mMainPage);
        this.addPage((IWizardPage)this.mConfigPage);
    }

    public boolean performFinish() {
        final Pair<IFile, IRegion> created = this.createXmlFile();
        if (created == null) {
            return false;
        }
        AndmoreAndroidPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IFile file = (IFile)created.getFirst();
                IRegion region = (IRegion)created.getSecond();
                try {
                    AndroidXmlEditor xmlEditor;
                    IEditorPart editor = AndmoreAndroidPlugin.openFile(file, null, false);
                    if (editor instanceof AndroidXmlEditor && !(xmlEditor = (AndroidXmlEditor)editor).hasMultiplePages()) {
                        xmlEditor.show(region.getOffset(), region.getLength(), true);
                    }
                }
                catch (PartInitException e) {
                    AndmoreAndroidPlugin.log(e, "Failed to create %1$s: missing type", file.getFullPath().toString());
                }
            }
        });
        return true;
    }

    private Pair<IFile, IRegion> createXmlFile() {
        IFile file = this.mValues.getDestinationFile();
        NewXmlFileCreationPage.TypeInfo type = this.mValues.type;
        if (type == null) {
            String name = file.getFullPath().toString();
            AndmoreAndroidPlugin.log(4, "Failed to create %1$s: missing type", name);
            return null;
        }
        String xmlns = type.getXmlns();
        String root = this.mMainPage.getRootElement();
        if (root == null) {
            AndmoreAndroidPlugin.log(4, "Failed to create %1$s: missing root element", file.toString());
            return null;
        }
        String attrs = type.getDefaultAttrs(this.mValues.project, root);
        String child = type.getChild(this.mValues.project, root);
        return NewXmlFileWizard.createXmlFile(file, xmlns, root, attrs, child, type.getResFolderType());
    }

    private static Pair<IFile, IRegion> createXmlFile(IFile file, String xmlns, String root, String rootAttributes, String child, ResourceFolderType folderType) {
        String fileContents;
        IProject project;
        int minSdk;
        String name = file.getFullPath().toString();
        boolean need_delete = false;
        if (file.exists()) {
            if (!AndmoreAndroidPlugin.displayPrompt("New Android XML File", String.format("Do you want to overwrite the file %1$s ?", name))) {
                return null;
            }
            need_delete = true;
        } else {
            AdtUtils.createWsParentDirectory(file.getParent());
        }
        StringBuilder sb = new StringBuilder(XML_HEADER_LINE);
        if (folderType == ResourceFolderType.LAYOUT && root.equals("GridLayout") && (minSdk = ManifestInfo.get(project = file.getParent().getProject()).getMinSdkVersion()) < 14 && (root = SupportLibraryHelper.getTagFor(project, "android.widget.GridLayout")).equals("android.widget.GridLayout")) {
            root = "GridLayout";
        }
        sb.append('<').append(root);
        if (xmlns != null) {
            sb.append('\n').append("  xmlns:android=\"").append(xmlns).append('\"');
        }
        if (rootAttributes != null) {
            sb.append("\n  ");
            sb.append(rootAttributes.replace("\n", "\n  "));
        }
        sb.append(">\n");
        if (child != null) {
            sb.append(child);
        }
        boolean autoFormat = AdtPrefs.getPrefs().getUseCustomXmlFormatter();
        sb.append("${indent}");
        sb.append("${caret}");
        if (!autoFormat) {
            sb.append('\n');
        }
        sb.append("</").append(root).append(">\n");
        EclipseXmlFormatPreferences formatPrefs = EclipseXmlFormatPreferences.create();
        if (!autoFormat) {
            fileContents = sb.toString();
        } else {
            XmlFormatStyle style = EclipseXmlPrettyPrinter.getForFolderType(folderType);
            fileContents = EclipseXmlPrettyPrinter.prettyPrint(sb.toString(), formatPrefs, style, null);
        }
        fileContents = fileContents.replace("${indent}", formatPrefs.getOneIndentUnit());
        int caretOffset = fileContents.indexOf("${caret}");
        if (caretOffset != -1) {
            fileContents = fileContents.replace("${caret}", "");
        }
        String error = null;
        try {
            Region region;
            byte[] buf = fileContents.getBytes("UTF8");
            ByteArrayInputStream stream = new ByteArrayInputStream(buf);
            if (need_delete) {
                file.delete(3, null);
            }
            file.create((InputStream)stream, true, null);
            Region region2 = region = caretOffset != -1 ? new Region(caretOffset, 0) : null;
            if (file.getParent().getName().indexOf(45) != -1 && (folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES)) {
                RenderPreviewManager.bumpRevision();
            }
            return Pair.of((Object)file, (Object)region);
        }
        catch (UnsupportedEncodingException e) {
            error = e.getMessage();
        }
        catch (CoreException e) {
            error = e.getMessage();
        }
        error = String.format("Failed to generate %1$s: %2$s", name, error);
        AndmoreAndroidPlugin.displayError("New Android XML File", error);
        return null;
    }

    public static boolean canCreateXmlFile(ResourceFolderType folderType) {
        NewXmlFileCreationPage.TypeInfo typeInfo = NewXmlFileCreationPage.getTypeInfo(folderType);
        return typeInfo != null && (typeInfo.getDefaultRoot(null) != null || typeInfo.getRootSeed() instanceof String);
    }

    public static Pair<IFile, IRegion> createXmlFile(IProject project, IFile file, ResourceFolderType folderType) {
        NewXmlFileCreationPage.TypeInfo type = NewXmlFileCreationPage.getTypeInfo(folderType);
        String xmlns = type.getXmlns();
        String root = type.getDefaultRoot(project);
        if (root == null) {
            root = type.getRootSeed().toString();
        }
        String attrs = type.getDefaultAttrs(project, root);
        return NewXmlFileWizard.createXmlFile(file, xmlns, root, attrs, null, folderType);
    }

    private void setImageDescriptor() {
        ImageDescriptor desc = IconFactory.getInstance().getImageDescriptor(PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(desc);
    }

    public static class NewLayoutWizard
    extends NewXmlFileWizard {
        @Override
        public void init(IWorkbench workbench, IStructuredSelection selection) {
            super.init(workbench, selection);
            this.setWindowTitle("New Android Layout XML File");
            ((NewXmlFileWizard)this).mMainPage.setTitle("New Android Layout XML File");
            ((NewXmlFileWizard)this).mMainPage.setDescription("Creates a new Android Layout XML file.");
            ((NewXmlFileWizard)this).mMainPage.setInitialFolderType(ResourceFolderType.LAYOUT);
        }
    }

    public static class NewValuesWizard
    extends NewXmlFileWizard {
        @Override
        public void init(IWorkbench workbench, IStructuredSelection selection) {
            super.init(workbench, selection);
            this.setWindowTitle("New Android Values XML File");
            ((NewXmlFileWizard)this).mMainPage.setTitle("New Android Values XML File");
            ((NewXmlFileWizard)this).mMainPage.setDescription("Creates a new Android Values XML file.");
            ((NewXmlFileWizard)this).mMainPage.setInitialFolderType(ResourceFolderType.VALUES);
        }
    }

    public static class Values {
        public IProject project;
        public String name;
        public NewXmlFileCreationPage.TypeInfo type;
        public String folderPath;
        public FolderConfiguration configuration = new FolderConfiguration();

        public String getFileName() {
            String fileName;
            if (this.name == null) {
                fileName = "";
            } else {
                fileName = this.name.trim();
                if (fileName.length() > 0 && fileName.indexOf(46) == -1) {
                    fileName = String.valueOf(fileName) + ".xml";
                }
            }
            return fileName;
        }

        public IFile getDestinationFile() {
            String fileName = this.getFileName();
            if (this.project != null && this.folderPath != null && this.folderPath.length() > 0 && fileName.length() > 0) {
                IPath dest = new Path(this.folderPath).append(fileName);
                IFile file = this.project.getFile(dest);
                return file;
            }
            return null;
        }
    }
}

