/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import org.eclipse.birt.report.designer.internal.ui.editors.rulers.DragEditorGuide;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.DragEditorGuideEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuideEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.rulers.RulerProvider;

public class EditorRulerEditPartFactory
implements EditPartFactory {
    protected GraphicalViewer diagramViewer;

    public EditorRulerEditPartFactory(GraphicalViewer primaryViewer) {
        this.diagramViewer = primaryViewer;
    }

    protected EditPart createRulerEditPart(EditPart parentEditPart, Object model) {
        return new EditorRulerEditPart(model);
    }

    protected EditPart createGuideEditPart(EditPart parentEditPart, Object model) {
        if (model instanceof DragEditorGuide) {
            return new DragEditorGuideEditPart(model);
        }
        return new EditorGuideEditPart(model);
    }

    public EditPart createEditPart(EditPart parentEditPart, Object model) {
        EditPart part = null;
        if (this.isRuler(model)) {
            part = this.createRulerEditPart(parentEditPart, model);
        } else if (model != null) {
            part = this.createGuideEditPart(parentEditPart, model);
        }
        return part;
    }

    protected Object getHorizontalRuler() {
        Object ruler = null;
        RulerProvider provider = (RulerProvider)this.diagramViewer.getProperty("horizontal ruler");
        if (provider != null) {
            ruler = provider.getRuler();
        }
        return ruler;
    }

    protected Object getVerticalRuler() {
        Object ruler = null;
        RulerProvider provider = (RulerProvider)this.diagramViewer.getProperty("vertical ruler");
        if (provider != null) {
            ruler = provider.getRuler();
        }
        return ruler;
    }

    protected boolean isRuler(Object model) {
        boolean result = false;
        if (model != null) {
            result = model == this.getHorizontalRuler() || model == this.getVerticalRuler();
        }
        return result;
    }
}

