/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionLoader;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class ScriptableObjectExtensionLoader
extends ExtensionLoader {
    public static final String EXTENSION_POINT = "org.eclipse.birt.report.model.IScriptableObjectClassInfo";
    private static final String ELEMENT_TAG = "scriptableClassInfo";
    private static final String DEFAULT_ROM = "BIRT_ROM";

    public ScriptableObjectExtensionLoader() {
        super(EXTENSION_POINT);
    }

    @Override
    protected void loadExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        ScriptableObjectElementLoader loader = new ScriptableObjectElementLoader();
        IConfigurationElement currentTag = configElements[0];
        if (ELEMENT_TAG.equals(currentTag.getName())) {
            loader.loadElement(currentTag);
        }
    }

    private class ScriptableObjectElementLoader
    extends ExtensionLoader.ExtensionElementLoader {
        private ScriptableObjectElementLoader() {
            super(ScriptableObjectExtensionLoader.this);
        }

        @Override
        public void loadElement(IConfigurationElement elementTag) {
            String extensionName = elementTag.getAttribute("extensionName");
            String className = elementTag.getAttribute("class");
            if (!this.checkRequiredAttribute("class", className)) {
                return;
            }
            try {
                IScriptableObjectClassInfo factory = (IScriptableObjectClassInfo)elementTag.createExecutableExtension("class");
                MetaDataDictionary metaData = MetaDataDictionary.getInstance();
                if (StringUtil.isBlank(extensionName) || ScriptableObjectExtensionLoader.DEFAULT_ROM.equalsIgnoreCase(extensionName)) {
                    metaData.setScriptableFactory(factory);
                    return;
                }
                IElementDefn elementDefn = metaData.getExtension(extensionName);
                if (elementDefn == null || !(elementDefn instanceof PeerExtensionElementDefn)) {
                    ScriptableObjectExtensionLoader.this.handleError(new ExtensionException(new String[]{extensionName}, "INVALID_ELEMENT_TYPE"));
                    return;
                }
                PeerExtensionElementDefn peerDefn = (PeerExtensionElementDefn)elementDefn;
                peerDefn.setScriptableFactory(factory);
            }
            catch (FrameworkException frameworkException) {
                ScriptableObjectExtensionLoader.this.handleError(new ExtensionException(new String[]{className}, "FAILED_TO_CREATE_INSTANCE"));
                return;
            }
        }
    }
}

