/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.gradle;

import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.osgi.util.NLS;

public final class GradleDistributionFormatter {
    public static String toString(GradleDistribution gradleDistribution) {
        Preconditions.checkNotNull((Object)gradleDistribution);
        GradleDistributionWrapper gradleDistributionWrapper = GradleDistributionWrapper.from(gradleDistribution);
        return GradleDistributionFormatter.toString(gradleDistributionWrapper);
    }

    public static String toString(GradleDistributionWrapper gradleDistributionWrapper) {
        Preconditions.checkNotNull((Object)gradleDistributionWrapper);
        switch (gradleDistributionWrapper.getType()) {
            case WRAPPER: {
                return CoreMessages.GradleDistribution_Value_UseGradleWrapper;
            }
            case LOCAL_INSTALLATION: {
                return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseLocalInstallation_0, (Object)gradleDistributionWrapper.getConfiguration());
            }
            case REMOTE_DISTRIBUTION: {
                return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseRemoteDistribution_0, (Object)gradleDistributionWrapper.getConfiguration());
            }
            case VERSION: {
                return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseGradleVersion_0, (Object)gradleDistributionWrapper.getConfiguration());
            }
        }
        throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + (Object)((Object)gradleDistributionWrapper.getType()));
    }
}

