/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.cdt.arduino.core.internal.board.LibraryIndex;
import org.eclipse.cdt.arduino.core.internal.board.PackageIndex;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ArduinoManager {
    public static final String BOARD_OPTION_ID = "org.eclipse.cdt.arduino.option.board";
    public static final String PLATFORM_OPTION_ID = "org.eclipse.cdt.arduino.option.platform";
    public static final String PACKAGE_OPTION_ID = "org.eclipse.cdt.arduino.option.package";
    public static final String AVR_TOOLCHAIN_ID = "org.eclipse.cdt.arduino.toolChain.avr";
    public static final String LIBRARIES_URL = "http://downloads.arduino.cc/libraries/library_index.json";
    public static final String LIBRARIES_FILE = "library_index.json";
    private static final String LIBRARIES = "libraries";
    private static final String VERSION_KEY = "version";
    private static final String ACCEPTED_KEY = "accepted";
    private static final String VERSION = "2";
    private Properties props;
    private Path arduinoHome = ArduinoPreferences.getArduinoHome();
    private Map<String, ArduinoPackage> packages;
    private Map<String, ArduinoLibrary> installedLibraries;

    private Path getVersionFile() {
        return ArduinoPreferences.getArduinoHome().resolve(".version");
    }

    private synchronized void init() throws CoreException {
        if (!this.arduinoHome.equals(ArduinoPreferences.getArduinoHome())) {
            this.props = null;
            this.packages = null;
            this.installedLibraries = null;
            this.arduinoHome = ArduinoPreferences.getArduinoHome();
        }
        if (this.props == null) {
            int version;
            Throwable throwable;
            if (!Files.exists(ArduinoPreferences.getArduinoHome(), new LinkOption[0])) {
                try {
                    Files.createDirectories(ArduinoPreferences.getArduinoHome(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw Activator.coreException(e);
                }
            }
            this.props = new Properties();
            Path propsFile = this.getVersionFile();
            if (Files.exists(propsFile, new LinkOption[0])) {
                try {
                    Throwable throwable2 = null;
                    throwable = null;
                    try (FileReader reader = new FileReader(propsFile.toFile());){
                        this.props.load(reader);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw Activator.coreException(e);
                }
            }
            if ((version = Integer.parseInt(this.props.getProperty(VERSION_KEY, "1"))) < Integer.parseInt(VERSION)) {
                this.props.setProperty(VERSION_KEY, VERSION);
                try {
                    throwable = null;
                    Object var4_11 = null;
                    try (FileWriter writer = new FileWriter(this.getVersionFile().toFile());){
                        this.props.store(writer, "");
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw Activator.coreException(e);
                }
            }
        }
    }

    public void convertLibrariesDir() throws CoreException {
        Path librariesDir = ArduinoPreferences.getArduinoHome().resolve(LIBRARIES);
        if (!Files.isDirectory(librariesDir, new LinkOption[0])) {
            return;
        }
        try {
            Path tmpDir = Files.createTempDirectory("alib", new FileAttribute[0]);
            Path tmpLibDir = tmpDir.resolve(LIBRARIES);
            Files.move(librariesDir, tmpLibDir, new CopyOption[0]);
            Files.list(tmpLibDir).forEach(path3 -> {
                try {
                    Optional<Path> latest = Files.list(path3).reduce((path1, path2) -> ArduinoManager.compareVersions(path1.getFileName().toString(), path2.getFileName().toString()) > 0 ? path1 : path2);
                    if (latest.isPresent()) {
                        Files.move(latest.get(), librariesDir.resolve(path3.getFileName()), new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            ArduinoManager.recursiveDelete(tmpDir);
        }
        catch (IOException | RuntimeException e) {
            throw Activator.coreException(e);
        }
    }

    public boolean licenseAccepted() throws CoreException {
        this.init();
        return Boolean.getBoolean(this.props.getProperty(ACCEPTED_KEY, Boolean.FALSE.toString()));
    }

    public void acceptLicense() throws CoreException {
        this.init();
        this.props.setProperty(ACCEPTED_KEY, Boolean.TRUE.toString());
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter writer = new FileWriter(this.getVersionFile().toFile());){
                this.props.store(writer, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw Activator.coreException(e);
        }
    }

    public Collection<ArduinoPlatform> getInstalledPlatforms() throws CoreException {
        ArrayList<ArduinoPlatform> platforms = new ArrayList<ArduinoPlatform>();
        for (ArduinoPackage pkg : this.getPackages()) {
            platforms.addAll(pkg.getInstalledPlatforms());
        }
        return platforms;
    }

    public ArduinoPlatform getInstalledPlatform(String packageName, String architecture) throws CoreException {
        ArduinoPackage pkg = this.getPackage(packageName);
        return pkg != null ? pkg.getInstalledPlatform(architecture) : null;
    }

    public synchronized Collection<ArduinoPlatform> getAvailablePlatforms(IProgressMonitor monitor) throws CoreException {
        ArrayList<ArduinoPlatform> platforms = new ArrayList<ArduinoPlatform>();
        URL[] urls = ArduinoPreferences.getBoardUrlList();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(urls.length + 1));
        sub.beginTask("Downloading package descriptions", urls.length);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            Path packagePath = ArduinoPreferences.getArduinoHome().resolve(Paths.get(url.getPath(), new String[0]).getFileName());
            try {
                Files.createDirectories(ArduinoPreferences.getArduinoHome(), new FileAttribute[0]);
                Throwable throwable = null;
                Object var11_14 = null;
                try (InputStream in = url.openStream();){
                    Files.copy(in, packagePath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw Activator.coreException(String.format("Error loading %s", url.toString()), e);
            }
            sub.worked(1);
            ++n2;
        }
        sub.beginTask("Loading available packages", 1);
        this.resetPackages();
        for (ArduinoPackage pkg : this.getPackages()) {
            platforms.addAll(pkg.getAvailablePlatforms());
        }
        sub.done();
        return platforms;
    }

    public synchronized Collection<ArduinoPlatform> getPlatformUpdates(IProgressMonitor monitor) throws CoreException {
        ArrayList<ArduinoPlatform> platforms = new ArrayList<ArduinoPlatform>();
        URL[] urls = ArduinoPreferences.getBoardUrlList();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(urls.length + 1));
        sub.beginTask("Downloading package descriptions", urls.length);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            Path packagePath = ArduinoPreferences.getArduinoHome().resolve(Paths.get(url.getPath(), new String[0]).getFileName());
            try {
                Files.createDirectories(ArduinoPreferences.getArduinoHome(), new FileAttribute[0]);
                Throwable throwable = null;
                Object var11_14 = null;
                try (InputStream in = url.openStream();){
                    Files.copy(in, packagePath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw Activator.coreException(String.format("Error loading %s", url.toString()), e);
            }
            sub.worked(1);
            ++n2;
        }
        sub.beginTask("Loading available package updates", 1);
        this.resetPackages();
        for (ArduinoPackage pkg : this.getPackages()) {
            platforms.addAll(pkg.getPlatformUpdates());
        }
        sub.done();
        return platforms;
    }

    public void installPlatforms(Collection<ArduinoPlatform> platforms, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)platforms.size());
        for (ArduinoPlatform platform : platforms) {
            sub.setTaskName(String.format("Installing %s %s", platform.getName(), platform.getVersion()));
            platform.install((IProgressMonitor)sub);
            sub.worked(1);
        }
        sub.done();
    }

    public void uninstallPlatforms(Collection<ArduinoPlatform> platforms, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)platforms.size());
        for (ArduinoPlatform platform : platforms) {
            sub.setTaskName(String.format("Uninstalling %s", platform.getName()));
            platform.uninstall((IProgressMonitor)sub);
            sub.worked(1);
        }
        sub.done();
    }

    public static List<ArduinoPlatform> getSortedPlatforms(Collection<ArduinoPlatform> platforms) {
        ArrayList<ArduinoPlatform> result = new ArrayList<ArduinoPlatform>(platforms);
        Collections.sort(result, (plat1, plat2) -> {
            String p2;
            String p1 = plat1.getPackage().getName();
            int c1 = p1.equals(p2 = plat2.getPackage().getName()) ? 0 : (p1.equals("arduino") ? -1 : (p2.equals("arduino") ? 1 : plat1.getPackage().getName().compareToIgnoreCase(plat2.getPackage().getName())));
            if (c1 > 0) {
                return 1;
            }
            if (c1 < 0) {
                return -1;
            }
            return plat1.getArchitecture().compareToIgnoreCase(plat2.getArchitecture());
        });
        return result;
    }

    public static List<ArduinoLibrary> getSortedLibraries(Collection<ArduinoLibrary> libraries) {
        ArrayList<ArduinoLibrary> result = new ArrayList<ArduinoLibrary>(libraries);
        Collections.sort(result, (lib1, lib2) -> lib1.getName().compareToIgnoreCase(lib2.getName()));
        return result;
    }

    private synchronized void initPackages() throws CoreException {
        this.init();
        if (this.packages == null) {
            this.packages = new HashMap<String, ArduinoPackage>();
            try {
                Files.list(ArduinoPreferences.getArduinoHome()).filter(path -> path.getFileName().toString().startsWith("package_")).forEach(path -> {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (FileReader reader = new FileReader(path.toFile());){
                            PackageIndex index = (PackageIndex)new Gson().fromJson((Reader)reader, PackageIndex.class);
                            for (ArduinoPackage pkg : index.getPackages()) {
                                ArduinoPackage p = this.packages.get(pkg.getName());
                                if (p == null) {
                                    pkg.init();
                                    this.packages.put(pkg.getName(), pkg);
                                    continue;
                                }
                                p.merge(pkg);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        Activator.log(e);
                    }
                });
            }
            catch (IOException e) {
                throw Activator.coreException(e);
            }
        }
    }

    private Collection<ArduinoPackage> getPackages() throws CoreException {
        this.initPackages();
        return this.packages.values();
    }

    public void resetPackages() {
        this.packages = null;
    }

    public ArduinoPackage getPackage(String packageName) throws CoreException {
        if (packageName == null) {
            return null;
        }
        this.initPackages();
        return this.packages.get(packageName);
    }

    public Collection<ArduinoBoard> getInstalledBoards() throws CoreException {
        ArrayList<ArduinoBoard> boards = new ArrayList<ArduinoBoard>();
        for (ArduinoPlatform platform : this.getInstalledPlatforms()) {
            boards.addAll(platform.getBoards());
        }
        return boards;
    }

    public ArduinoBoard getBoard(String packageName, String architecture, String boardId) throws CoreException {
        for (ArduinoPlatform platform : this.getInstalledPlatforms()) {
            if (!platform.getPackage().getName().equals(packageName) || !platform.getArchitecture().equals(architecture)) continue;
            return platform.getBoard(boardId);
        }
        for (ArduinoPlatform platform : this.getInstalledPlatforms()) {
            if (!platform.getPackage().getName().equals(packageName) || !platform.getName().equals(architecture)) continue;
            return platform.getBoardByName(boardId);
        }
        return null;
    }

    public ArduinoTool getTool(String packageName, String toolName, String version) {
        ArduinoPackage pkg = this.packages.get(packageName);
        return pkg != null ? pkg.getTool(toolName, version) : null;
    }

    private void initInstalledLibraries() throws CoreException {
        this.init();
        if (this.installedLibraries == null) {
            this.installedLibraries = new HashMap<String, ArduinoLibrary>();
            Path librariesDir = ArduinoPreferences.getArduinoHome().resolve(LIBRARIES);
            if (Files.isDirectory(librariesDir, new LinkOption[0])) {
                try {
                    Files.find(librariesDir, 3, (path, attrs) -> path.getFileName().toString().equals("library.properties"), new FileVisitOption[0]).forEach(path -> {
                        try {
                            ArduinoLibrary library = new ArduinoLibrary((Path)path);
                            this.installedLibraries.put(library.getName(), library);
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (IOException e) {
                    throw Activator.coreException(e);
                }
            }
        }
    }

    public Collection<ArduinoLibrary> getInstalledLibraries() throws CoreException {
        this.initInstalledLibraries();
        return this.installedLibraries.values();
    }

    public ArduinoLibrary getInstalledLibrary(String name) throws CoreException {
        this.initInstalledLibraries();
        return this.installedLibraries.get(name);
    }

    public Collection<ArduinoLibrary> getAvailableLibraries(IProgressMonitor monitor) throws CoreException {
        try {
            this.initInstalledLibraries();
            HashMap<String, ArduinoLibrary> libs = new HashMap<String, ArduinoLibrary>();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Downloading library index", (int)2);
            Path librariesPath = ArduinoPreferences.getArduinoHome().resolve(LIBRARIES_FILE);
            URL librariesUrl = new URL(LIBRARIES_URL);
            Files.createDirectories(ArduinoPreferences.getArduinoHome(), new FileAttribute[0]);
            Files.copy(librariesUrl.openStream(), librariesPath, StandardCopyOption.REPLACE_EXISTING);
            sub.worked(1);
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileReader reader = new FileReader(librariesPath.toFile());){
                sub.setTaskName("Calculating available libraries");
                LibraryIndex libraryIndex = (LibraryIndex)new Gson().fromJson((Reader)reader, LibraryIndex.class);
                for (ArduinoLibrary library : libraryIndex.getLibraries()) {
                    ArduinoLibrary current;
                    String libraryName = library.getName();
                    if (this.installedLibraries.containsKey(libraryName) || (current = (ArduinoLibrary)libs.get(libraryName)) != null && ArduinoManager.compareVersions(library.getVersion(), current.getVersion()) <= 0) continue;
                    libs.put(libraryName, library);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            sub.done();
            return libs.values();
        }
        catch (IOException e) {
            throw Activator.coreException(e);
        }
    }

    public Collection<ArduinoLibrary> getLibraryUpdates(IProgressMonitor monitor) throws CoreException {
        try {
            this.initInstalledLibraries();
            HashMap<String, ArduinoLibrary> libs = new HashMap<String, ArduinoLibrary>();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Downloading library index", (int)2);
            Path librariesPath = ArduinoPreferences.getArduinoHome().resolve(LIBRARIES_FILE);
            URL librariesUrl = new URL(LIBRARIES_URL);
            Files.createDirectories(ArduinoPreferences.getArduinoHome(), new FileAttribute[0]);
            Files.copy(librariesUrl.openStream(), librariesPath, StandardCopyOption.REPLACE_EXISTING);
            sub.worked(1);
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileReader reader = new FileReader(librariesPath.toFile());){
                sub.setTaskName("Calculating library updates");
                LibraryIndex libraryIndex = (LibraryIndex)new Gson().fromJson((Reader)reader, LibraryIndex.class);
                for (ArduinoLibrary library : libraryIndex.getLibraries()) {
                    ArduinoLibrary current;
                    String libraryName = library.getName();
                    ArduinoLibrary installed = this.installedLibraries.get(libraryName);
                    if (installed == null || ArduinoManager.compareVersions(library.getVersion(), installed.getVersion()) <= 0 || (current = (ArduinoLibrary)libs.get(libraryName)) != null && ArduinoManager.compareVersions(library.getVersion(), current.getVersion()) <= 0) continue;
                    libs.put(libraryName, library);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            sub.done();
            return libs.values();
        }
        catch (IOException e) {
            throw Activator.coreException(e);
        }
    }

    public void installLibraries(Collection<ArduinoLibrary> libraries, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)libraries.size());
        for (ArduinoLibrary library : libraries) {
            sub.setTaskName(String.format("Installing %s", library.getName()));
            library.install((IProgressMonitor)sub);
            try {
                ArduinoLibrary newLibrary = new ArduinoLibrary(library.getInstallPath().resolve("library.properties"));
                this.installedLibraries.put(newLibrary.getName(), newLibrary);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            sub.worked(1);
        }
        sub.done();
    }

    public void uninstallLibraries(Collection<ArduinoLibrary> libraries, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)libraries.size());
        for (ArduinoLibrary library : libraries) {
            sub.setTaskName(String.format("Installing %s", library.getName()));
            library.uninstall((IProgressMonitor)sub);
            this.installedLibraries.remove(library.getName());
            sub.worked(1);
        }
        sub.done();
    }

    public Collection<ArduinoLibrary> getLibraries(IProject project) throws CoreException {
        this.initInstalledLibraries();
        IEclipsePreferences settings = this.getSettings(project);
        String librarySetting = settings.get(LIBRARIES, "[]");
        JsonArray libArray = new JsonParser().parse(librarySetting).getAsJsonArray();
        ArrayList<ArduinoLibrary> libraries = new ArrayList<ArduinoLibrary>(libArray.size());
        for (JsonElement libElement : libArray) {
            ArduinoLibrary lib;
            ArduinoPlatform platform;
            if (libElement.isJsonPrimitive()) {
                String libName = libElement.getAsString();
                ArduinoLibrary lib2 = this.installedLibraries.get(libName);
                if (lib2 == null) continue;
                libraries.add(lib2);
                continue;
            }
            JsonObject libObj = libElement.getAsJsonObject();
            String packageName = libObj.get("package").getAsString();
            String platformName = libObj.get("platform").getAsString();
            String libName = libObj.get("library").getAsString();
            ArduinoPackage pkg = this.getPackage(packageName);
            if (pkg == null || (platform = pkg.getInstalledPlatform(platformName)) == null || (lib = platform.getLibrary(libName)) == null) continue;
            libraries.add(lib);
        }
        return libraries;
    }

    public void setLibraries(IProject project, Collection<ArduinoLibrary> libraries) throws CoreException {
        JsonArray elements = new JsonArray();
        for (ArduinoLibrary library : libraries) {
            ArduinoPlatform platform = library.getPlatform();
            if (platform != null) {
                JsonObject libObj = new JsonObject();
                libObj.addProperty("package", platform.getPackage().getName());
                libObj.addProperty("platform", platform.getArchitecture());
                libObj.addProperty("library", library.getName());
                elements.add((JsonElement)libObj);
                continue;
            }
            elements.add((JsonElement)new JsonPrimitive(library.getName()));
        }
        IEclipsePreferences settings = this.getSettings(project);
        settings.put(LIBRARIES, new Gson().toJson((JsonElement)elements));
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            throw Activator.coreException(e);
        }
    }

    private IEclipsePreferences getSettings(IProject project) {
        return new ProjectScope(project).getNode(Activator.getId());
    }

    public static void downloadAndInstall(String url, String archiveFileName, Path installPath, IProgressMonitor monitor) throws IOException {
        Throwable error = null;
        int retries = 3;
        while (retries > 0 && !monitor.isCanceled()) {
            try {
                URL dl = new URL(url);
                Path dlDir = ArduinoPreferences.getArduinoHome().resolve("downloads");
                Files.createDirectories(dlDir, new FileAttribute[0]);
                Path archivePath = dlDir.resolve(archiveFileName);
                URLConnection conn = dl.openConnection();
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
                Files.copy(conn.getInputStream(), archivePath, StandardCopyOption.REPLACE_EXISTING);
                boolean isWin = Platform.getOS().equals("win32");
                try (ArchiveInputStream archiveIn = null;){
                    String compressor = null;
                    String archiver = null;
                    if (archiveFileName.endsWith("tar.bz2")) {
                        compressor = "bzip2";
                        archiver = "tar";
                    } else if (archiveFileName.endsWith(".tar.gz") || archiveFileName.endsWith(".tgz")) {
                        compressor = "gz";
                        archiver = "tar";
                    } else if (archiveFileName.endsWith(".tar.xz")) {
                        compressor = "xz";
                        archiver = "tar";
                    } else if (archiveFileName.endsWith(".zip")) {
                        archiver = "zip";
                    }
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(archivePath.toFile()));
                    if (compressor != null) {
                        in = new CompressorStreamFactory().createCompressorInputStream(compressor, (InputStream)in);
                    }
                    archiveIn = new ArchiveStreamFactory().createArchiveInputStream(archiver, (InputStream)in);
                    ArchiveEntry entry = archiveIn.getNextEntry();
                    while (entry != null) {
                        block34: {
                            Path entryPath;
                            Path path;
                            if (entry.isDirectory() || (path = Paths.get(entry.getName(), new String[0])).endsWith("pax_global_header")) break block34;
                            switch (path.getName(0).toString()) {
                                case "i586": 
                                case "i686": {
                                    entryPath = installPath.resolve(path);
                                    break;
                                }
                                default: {
                                    entryPath = installPath.resolve(path.subpath(1, path.getNameCount()));
                                }
                            }
                            Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                            if (entry instanceof TarArchiveEntry) {
                                TarArchiveEntry tarEntry = (TarArchiveEntry)entry;
                                if (tarEntry.isLink()) {
                                    Path linkPath = Paths.get(tarEntry.getLinkName(), new String[0]);
                                    linkPath = installPath.resolve(linkPath.subpath(1, linkPath.getNameCount()));
                                    Files.deleteIfExists(entryPath);
                                    Files.createSymbolicLink(entryPath, entryPath.getParent().relativize(linkPath), new FileAttribute[0]);
                                } else if (tarEntry.isSymbolicLink()) {
                                    Path linkPath = Paths.get(tarEntry.getLinkName(), new String[0]);
                                    Files.deleteIfExists(entryPath);
                                    Files.createSymbolicLink(entryPath, linkPath, new FileAttribute[0]);
                                } else {
                                    Files.copy((InputStream)archiveIn, entryPath, StandardCopyOption.REPLACE_EXISTING);
                                }
                                if (!isWin && !tarEntry.isSymbolicLink()) {
                                    int mode = tarEntry.getMode();
                                    Files.setPosixFilePermissions(entryPath, ArduinoManager.toPerms(mode));
                                }
                            } else {
                                Files.copy((InputStream)archiveIn, entryPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        entry = archiveIn.getNextEntry();
                    }
                }
                return;
            }
            catch (IOException | ArchiveException | CompressorException e) {
                error = e;
                --retries;
            }
        }
        if (error instanceof IOException) {
            throw (IOException)error;
        }
        throw new IOException(error);
    }

    public static int compareVersions(String version1, String version2) {
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        if (version2 == null) {
            return 1;
        }
        String[] v1 = version1.split("\\.");
        String[] v2 = version2.split("\\.");
        int i = 0;
        while (i < Math.max(v1.length, v2.length)) {
            block11: {
                int vi2;
                int vi1;
                block10: {
                    if (v1.length <= i) {
                        return v2.length < i ? 0 : -1;
                    }
                    if (v2.length <= i) {
                        return 1;
                    }
                    vi1 = Integer.parseInt(v1[i]);
                    vi2 = Integer.parseInt(v2[i]);
                    if (vi1 >= vi2) break block10;
                    return -1;
                }
                try {
                    if (vi1 > vi2) {
                        return 1;
                    }
                }
                catch (NumberFormatException e) {
                    int c = v1[i].compareTo(v2[i]);
                    if (c < 0) {
                        return -1;
                    }
                    if (c <= 0) break block11;
                    return 1;
                }
            }
            ++i;
        }
        return 0;
    }

    private static Set<PosixFilePermission> toPerms(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static void recursiveDelete(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

