/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.build;

import java.util.Collection;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoToolChain;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;

public class ArduinoBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.arduino.core.provider";
    private static final ICBuildConfigurationManager configManager = Activator.getService(ICBuildConfigurationManager.class);
    private static final ArduinoManager arduinoManager = Activator.getService(ArduinoManager.class);

    public String getId() {
        return ID;
    }

    public ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        if (config.getName().equals("")) {
            Collection<ArduinoBoard> boards;
            ArduinoBoard board = arduinoManager.getBoard("arduino", "avr", "uno");
            if (board == null && !(boards = arduinoManager.getInstalledBoards()).isEmpty()) {
                board = boards.iterator().next();
            }
            if (board != null) {
                IToolChain toolChain = this.createToolChain(config);
                return new ArduinoBuildConfiguration(config, name, "run", board, toolChain);
            }
        } else {
            IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
            IRemoteConnectionType connectionType = remoteManager.getConnectionType("org.eclipse.cdt.arduino.core.connectionType");
            IRemoteConnection connection = connectionType.getConnection(name);
            if (connection == null) {
                throw Activator.coreException(String.format("Unknown connection: %s", name), null);
            }
            ArduinoRemoteConnection target = (ArduinoRemoteConnection)connection.getService(ArduinoRemoteConnection.class);
            if (target != null) {
                IToolChain toolChain = this.createToolChain(config);
                return new ArduinoBuildConfiguration(config, name, "run", target, toolChain);
            }
        }
        return null;
    }

    public ArduinoBuildConfiguration getConfiguration(IProject project, ArduinoRemoteConnection target, String launchMode, IProgressMonitor monitor) throws CoreException {
        IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArduinoBuildConfiguration arduinoConfig;
            IBuildConfiguration config = iBuildConfigurationArray[n2];
            ICBuildConfiguration cconfig = (ICBuildConfiguration)config.getAdapter(ICBuildConfiguration.class);
            if (cconfig != null && (arduinoConfig = (ArduinoBuildConfiguration)((Object)cconfig.getAdapter(ArduinoBuildConfiguration.class))) != null && target.equals(arduinoConfig.getTarget()) && arduinoConfig.getLaunchMode().equals(launchMode)) {
                return arduinoConfig;
            }
            ++n2;
        }
        String configName = target.getRemoteConnection().getName();
        IBuildConfiguration config = configManager.createBuildConfiguration((ICBuildConfigurationProvider)this, project, configName, monitor);
        IToolChain toolChain = this.createToolChain(config);
        ArduinoBuildConfiguration arduinoConfig = new ArduinoBuildConfiguration(config, configName, "run", target, toolChain);
        configManager.addBuildConfiguration(config, (ICBuildConfiguration)arduinoConfig);
        return arduinoConfig;
    }

    private IToolChain createToolChain(IBuildConfiguration config) throws CoreException {
        IToolChainManager toolChainManager = Activator.getService(IToolChainManager.class);
        IToolChainProvider provider = toolChainManager.getProvider("org.eclipse.cdt.arduino.core.toolChainProvider");
        ArduinoToolChain toolChain = new ArduinoToolChain(provider, config);
        toolChainManager.addToolChain((IToolChain)toolChain);
        return toolChain;
    }
}

