/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.ui.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.ui.internal.Activator;
import org.eclipse.cdt.cmake.ui.internal.NewCMakeToolChainFileWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CMakePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ICMakeToolChainManager manager;
    private Table filesTable;
    private Button removeButton;
    private Map<Path, ICMakeToolChainFile> filesToAdd = new HashMap<Path, ICMakeToolChainFile>();
    private Map<Path, ICMakeToolChainFile> filesToRemove = new HashMap<Path, ICMakeToolChainFile>();

    public void init(IWorkbench workbench) {
        this.manager = Activator.getService(ICMakeToolChainManager.class);
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Group filesGroup = new Group(control, 0);
        filesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        filesGroup.setText("ToolChain Files");
        filesGroup.setLayout((Layout)new GridLayout(2, false));
        Composite filesComp = new Composite((Composite)filesGroup, 0);
        filesComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filesTable = new Table(filesComp, 68100);
        this.filesTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filesTable.setHeaderVisible(true);
        this.filesTable.setLinesVisible(true);
        this.filesTable.addListener(13, e -> {
            TableItem[] items = this.filesTable.getSelection();
            this.removeButton.setEnabled(items.length > 0);
        });
        TableColumn pathColumn = new TableColumn(this.filesTable, 0);
        pathColumn.setText("ToolChain File");
        TableColumn osColumn = new TableColumn(this.filesTable, 0);
        osColumn.setText("OS");
        TableColumn archColumn = new TableColumn(this.filesTable, 0);
        archColumn.setText("CPU");
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)pathColumn, (ColumnLayoutData)new ColumnWeightData(75, 350, true));
        tableLayout.setColumnData((Widget)osColumn, (ColumnLayoutData)new ColumnWeightData(25, 100, true));
        tableLayout.setColumnData((Widget)archColumn, (ColumnLayoutData)new ColumnWeightData(25, 100, true));
        filesComp.setLayout((Layout)tableLayout);
        Composite buttonsComp = new Composite((Composite)filesGroup, 0);
        buttonsComp.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonsComp.setLayout((Layout)new GridLayout());
        Button addButton = new Button(buttonsComp, 8);
        addButton.setLayoutData((Object)new GridData(4, 4, false, false));
        addButton.setText("Add...");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCMakeToolChainFileWizard wizard = new NewCMakeToolChainFileWizard(CMakePreferencePage.this.getFiles());
                WizardDialog dialog = new WizardDialog(CMakePreferencePage.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ICMakeToolChainFile file = wizard.getNewFile();
                    if (CMakePreferencePage.this.filesToRemove.containsKey(file.getPath())) {
                        CMakePreferencePage.this.filesToRemove.remove(file.getPath());
                    } else {
                        CMakePreferencePage.this.filesToAdd.put(file.getPath(), file);
                    }
                    CMakePreferencePage.this.updateTable();
                }
            }
        });
        this.removeButton = new Button(buttonsComp, 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, e -> {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Deregister CMake ToolChain File", (String)"Do you wish to deregister the selected files?")) {
                TableItem[] tableItemArray = this.filesTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ICMakeToolChainFile file = (ICMakeToolChainFile)item.getData();
                    if (this.filesToAdd.containsKey(file.getPath())) {
                        this.filesToAdd.remove(file.getPath());
                    } else {
                        this.filesToRemove.put(file.getPath(), file);
                    }
                    this.updateTable();
                    ++n2;
                }
            }
        });
        this.updateTable();
        return control;
    }

    private void updateTable() {
        ArrayList<ICMakeToolChainFile> sorted = new ArrayList<ICMakeToolChainFile>(this.getFiles().values());
        Collections.sort(sorted, (o1, o2) -> o1.getPath().toString().compareToIgnoreCase(o2.getPath().toString()));
        this.filesTable.removeAll();
        for (ICMakeToolChainFile file : sorted) {
            String arch;
            TableItem item = new TableItem(this.filesTable, 0);
            item.setText(0, file.getPath().toString());
            String os = file.getProperty("os");
            if (os != null) {
                item.setText(1, os);
            }
            if ((arch = file.getProperty("arch")) != null) {
                item.setText(2, arch);
            }
            item.setData((Object)file);
        }
    }

    private Map<Path, ICMakeToolChainFile> getFiles() {
        HashMap<Path, ICMakeToolChainFile> files = new HashMap<Path, ICMakeToolChainFile>();
        for (ICMakeToolChainFile file : this.manager.getToolChainFiles()) {
            files.put(file.getPath(), file);
        }
        for (ICMakeToolChainFile file : this.filesToAdd.values()) {
            files.put(file.getPath(), file);
        }
        for (ICMakeToolChainFile file : this.filesToRemove.values()) {
            files.remove(file.getPath());
        }
        return files;
    }

    public boolean performOk() {
        for (ICMakeToolChainFile file : this.filesToAdd.values()) {
            this.manager.addToolChainFile(file);
        }
        for (ICMakeToolChainFile file : this.filesToRemove.values()) {
            this.manager.removeToolChainFile(file);
        }
        this.filesToAdd.clear();
        this.filesToRemove.clear();
        return true;
    }
}

