/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.ui.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.ui.internal.Activator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewCMakeToolChainFilePage
extends WizardPage {
    private final Map<Path, ICMakeToolChainFile> existing;
    private Text pathText;
    private Text osText;
    private Text archText;

    public NewCMakeToolChainFilePage(Map<Path, ICMakeToolChainFile> existing) {
        super("NewCMakeToolChainFilePage", "New CMake ToolChain File", null);
        this.existing = existing;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label pathLabel = new Label(comp, 0);
        pathLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        pathLabel.setText("Path:");
        Composite pathComp = new Composite(comp, 0);
        pathComp.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pathComp.setLayout((Layout)layout);
        this.pathText = new Text(pathComp, 2048);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.addModifyListener(e -> this.validate());
        Button pathButton = new Button(pathComp, 8);
        pathButton.setLayoutData((Object)new GridData(4, 4, false, false));
        pathButton.setText("Browse...");
        pathButton.addListener(13, e -> {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText("Select location for CMake toolchain file");
            String path = dialog.open();
            if (path != null) {
                this.pathText.setText(path);
            }
        });
        Label osLabel = new Label(comp, 0);
        osLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        osLabel.setText("Target OS:");
        this.osText = new Text(comp, 2048);
        this.osText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.osText.addModifyListener(e -> this.validate());
        Label archLabel = new Label(comp, 0);
        archLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        archLabel.setText("Target CPU:");
        this.archText = new Text(comp, 2048);
        this.archText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.archText.addModifyListener(e -> this.validate());
        this.setControl((Control)comp);
        this.validate();
    }

    private void validate() {
        this.setPageComplete(false);
        String path = this.pathText.getText();
        if (path.isEmpty()) {
            this.setErrorMessage("Please set the path to the CMake toolchain file.");
            return;
        }
        if (this.existing.containsKey(Paths.get(path, new String[0]))) {
            this.setErrorMessage("CMake toolchain file entry already exists.");
            return;
        }
        if (this.osText.getText().isEmpty()) {
            this.setErrorMessage("Please set the target operating system.");
            return;
        }
        if (this.archText.getText().isEmpty()) {
            this.setErrorMessage("Please set the target CPU architecture.");
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    public ICMakeToolChainFile getNewFile() {
        String arch;
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        ICMakeToolChainFile file = manager.newToolChainFile(Paths.get(this.pathText.getText(), new String[0]));
        String os = this.osText.getText();
        if (!os.isEmpty()) {
            file.setProperty("os", os);
        }
        if (!(arch = this.archText.getText()).isEmpty()) {
            file.setProperty("arch", arch);
        }
        return file;
    }
}

